/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.common;

import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseWrapper.class);
    private static final int RESPONSE_CODE_NONE = -1;
    private static Gson _gson = new Gson();
    public int responseCode = -1;
    public String responseContent;
    public ErrorObject error;
    public int rateLimitQuota;
    public int rateLimitRemaining;
    public int rateLimitReset;

    public void setRateLimit(String quota, String remaining, String reset) {
        if (null == quota) {
            return;
        }
        try {
            this.rateLimitQuota = Integer.parseInt(quota);
            this.rateLimitRemaining = Integer.parseInt(remaining);
            this.rateLimitReset = Integer.parseInt(reset);
            LOG.debug("JPush API Rate Limiting params - quota:" + quota + ", remaining:" + remaining + ", reset:" + reset);
        }
        catch (NumberFormatException e) {
            LOG.debug("Unexpected - parse rate limiting headers error.");
        }
    }

    public void setErrorObject() {
        this.error = (ErrorObject)_gson.fromJson(this.responseContent, ErrorObject.class);
    }

    public boolean isServerResponse() {
        if (this.responseCode == 200) {
            return true;
        }
        return this.responseCode > 0 && null != this.error && this.error.error.code > 0;
    }

    public String toString() {
        return _gson.toJson((Object)this);
    }

    public class ErrorEntity {
        public int code;
        public String message;

        public String toString() {
            return _gson.toJson((Object)this);
        }
    }

    public class ErrorObject {
        public ErrorEntity error;
    }
}

