/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push;

import cn.jpush.api.common.APIConnectionException;
import cn.jpush.api.common.APIRequestException;
import cn.jpush.api.common.NativeHttpClient;
import cn.jpush.api.common.ResponseWrapper;
import cn.jpush.api.common.ServiceHelper;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.PushPayload;

public class PushClient {
    public static final String HOST_NAME_SSL = "https://api.jpush.cn";
    public static final String PUSH_PATH = "/v3/push";
    private final NativeHttpClient _httpClient;
    private final String _masterSecret;
    private final String _appKey;
    private boolean _apnsProduction = true;
    private long _timeToLive = 86400L;
    private boolean _globalSettingEnabled = false;
    private final String _authCode;
    private String _baseUrl;

    public PushClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, 3);
    }

    public PushClient(String masterSecret, String appKey, int maxRetryTimes) {
        this._masterSecret = masterSecret;
        this._appKey = appKey;
        ServiceHelper.checkBasic(appKey, masterSecret);
        this._authCode = ServiceHelper.getAuthorizationBase64(this._appKey, this._masterSecret);
        this._baseUrl = "https://api.jpush.cn/v3/push";
        this._httpClient = new NativeHttpClient(maxRetryTimes);
    }

    public PushClient(String masterSecret, String appKey, boolean apnsProduction, long timeToLive) {
        this(masterSecret, appKey);
        this._apnsProduction = apnsProduction;
        this._timeToLive = timeToLive;
        this._globalSettingEnabled = true;
    }

    public void setBaseUrl(String baseUrl) {
        this._baseUrl = baseUrl;
    }

    public PushResult sendPush(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        if (this._globalSettingEnabled) {
            pushPayload.resetOptionsTimeToLive(this._timeToLive);
            pushPayload.resetOptionsApnsProduction(this._apnsProduction);
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl, pushPayload.toString(), this._authCode);
        return PushResult.fromResponse(response);
    }

    public PushResult sendPush(String payloadString) throws APIConnectionException, APIRequestException {
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl, payloadString, this._authCode);
        return PushResult.fromResponse(response);
    }
}

