/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model;

import cn.jpush.api.push.model.PushModel;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class Message
implements PushModel {
    private static final String TITLE = "title";
    private static final String MSG_CONTENT = "msg_content";
    private static final String CONTENT_TYPE = "content_type";
    private static final String EXTRAS = "extras";
    private final String title;
    private final String msgContent;
    private final String contentType;
    private final ImmutableMap<String, String> extras;
    private final ImmutableMap<String, Number> numberExtras;
    private final ImmutableMap<String, Boolean> booleanExtras;

    private Message(String title, String msgContent, String contentType, ImmutableMap<String, String> extras, ImmutableMap<String, Number> numberExtras, ImmutableMap<String, Boolean> booleanExtras) {
        this.title = title;
        this.msgContent = msgContent;
        this.contentType = contentType;
        this.extras = extras;
        this.numberExtras = numberExtras;
        this.booleanExtras = booleanExtras;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Message content(String msgContent) {
        return new Builder().setMsgContent(msgContent).build();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.title) {
            json.add(TITLE, (JsonElement)new JsonPrimitive(this.title));
        }
        if (null != this.msgContent) {
            json.add(MSG_CONTENT, (JsonElement)new JsonPrimitive(this.msgContent));
        }
        if (null != this.contentType) {
            json.add(CONTENT_TYPE, (JsonElement)new JsonPrimitive(this.contentType));
        }
        JsonObject extrasObject = null;
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras) {
            extrasObject = new JsonObject();
        }
        if (null != this.extras) {
            for (String key : this.extras.keySet()) {
                extrasObject.add(key, (JsonElement)new JsonPrimitive((String)this.extras.get((Object)key)));
            }
        }
        if (null != this.numberExtras) {
            for (String key : this.numberExtras.keySet()) {
                extrasObject.add(key, (JsonElement)new JsonPrimitive((Number)this.numberExtras.get((Object)key)));
            }
        }
        if (null != this.booleanExtras) {
            for (String key : this.booleanExtras.keySet()) {
                extrasObject.add(key, (JsonElement)new JsonPrimitive((Boolean)this.booleanExtras.get((Object)key)));
            }
        }
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras) {
            json.add(EXTRAS, (JsonElement)extrasObject);
        }
        return json;
    }

    public static class Builder {
        private String title;
        private String msgContent;
        private String contentType;
        private ImmutableMap.Builder<String, String> extrasBuilder;
        private ImmutableMap.Builder<String, Number> numberExtrasBuilder;
        private ImmutableMap.Builder<String, Boolean> booleanExtrasBuilder;

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setMsgContent(String msgContent) {
            this.msgContent = msgContent;
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder addExtra(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = ImmutableMap.builder();
            }
            this.extrasBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder addExtras(Map<String, String> extras) {
            Preconditions.checkArgument((null != extras ? 1 : 0) != 0, (Object)"extras should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = ImmutableMap.builder();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put((Object)key, (Object)extras.get(key));
            }
            return this;
        }

        public Builder addExtra(String key, Number value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = ImmutableMap.builder();
            }
            this.numberExtrasBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder addExtra(String key, Boolean value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = ImmutableMap.builder();
            }
            this.booleanExtrasBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Message build() {
            Preconditions.checkArgument((null != this.msgContent ? 1 : 0) != 0, (Object)"msgContent should be set");
            return new Message(this.title, this.msgContent, this.contentType, null == this.extrasBuilder ? null : this.extrasBuilder.build(), null == this.numberExtrasBuilder ? null : this.numberExtrasBuilder.build(), null == this.booleanExtrasBuilder ? null : this.booleanExtrasBuilder.build());
        }
    }
}

