/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model;

import cn.jpush.api.common.DeviceType;
import cn.jpush.api.push.model.PushModel;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

public class Platform
implements PushModel {
    private static final String ALL = "all";
    private final boolean all;
    private final ImmutableSet<DeviceType> deviceTypes;

    private Platform(boolean all, ImmutableSet<DeviceType> deviceTypes) {
        this.all = all;
        this.deviceTypes = deviceTypes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Platform all() {
        return Platform.newBuilder().setAll(true).build();
    }

    public static Platform android() {
        return Platform.newBuilder().addDeviceType(DeviceType.Android).build();
    }

    public static Platform ios() {
        return Platform.newBuilder().addDeviceType(DeviceType.IOS).build();
    }

    public static Platform winphone() {
        return Platform.newBuilder().addDeviceType(DeviceType.WinPhone).build();
    }

    public static Platform android_ios() {
        return Platform.newBuilder().addDeviceType(DeviceType.Android).addDeviceType(DeviceType.IOS).build();
    }

    public static Platform android_winphone() {
        return Platform.newBuilder().addDeviceType(DeviceType.Android).addDeviceType(DeviceType.WinPhone).build();
    }

    public static Platform ios_winphone() {
        return Platform.newBuilder().addDeviceType(DeviceType.IOS).addDeviceType(DeviceType.WinPhone).build();
    }

    public boolean isAll() {
        return this.all;
    }

    @Override
    public JsonElement toJSON() {
        if (this.all) {
            return new JsonPrimitive(ALL);
        }
        JsonArray json = new JsonArray();
        for (DeviceType deviceType : this.deviceTypes) {
            json.add((JsonElement)new JsonPrimitive(deviceType.value()));
        }
        return json;
    }

    public static class Builder {
        private boolean all;
        private ImmutableSet.Builder<DeviceType> deviceTypes;

        public Builder setAll(boolean all) {
            this.all = all;
            return this;
        }

        public Builder addDeviceType(DeviceType deviceType) {
            if (null == this.deviceTypes) {
                this.deviceTypes = ImmutableSet.builder();
            }
            this.deviceTypes.add((Object)deviceType);
            return this;
        }

        public Platform build() {
            Preconditions.checkArgument((!this.all || null == this.deviceTypes ? 1 : 0) != 0, (Object)"Since all is enabled, any platform should not be set.");
            Preconditions.checkArgument((this.all || null != this.deviceTypes ? 1 : 0) != 0, (Object)"No any deviceType is set.");
            return new Platform(this.all, null == this.deviceTypes ? null : this.deviceTypes.build());
        }
    }
}

