/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.notification.PlatformNotification;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class AndroidNotification
extends PlatformNotification {
    public static final String NOTIFICATION_ANDROID = "android";
    private static final String TITLE = "title";
    private static final String BUILDER_ID = "builder_id";
    private final String title;
    private final int builderId;

    private AndroidNotification(String alert, String title, int builderId, ImmutableMap<String, String> extras, ImmutableMap<String, Number> numberExtras, ImmutableMap<String, Boolean> booleanExtras) {
        super(alert, extras, numberExtras, booleanExtras);
        this.title = title;
        this.builderId = builderId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static AndroidNotification alert(String alert) {
        return AndroidNotification.newBuilder().setAlert(alert).build();
    }

    @Override
    public String getPlatform() {
        return NOTIFICATION_ANDROID;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = super.toJSON().getAsJsonObject();
        if (this.builderId > 0) {
            json.add(BUILDER_ID, (JsonElement)new JsonPrimitive((Number)this.builderId));
        }
        if (null != this.title) {
            json.add(TITLE, (JsonElement)new JsonPrimitive(this.title));
        }
        return json;
    }

    public static class Builder
    extends PlatformNotification.Builder<AndroidNotification> {
        private String title;
        private int builderId;

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBuilderId(int builderId) {
            this.builderId = builderId;
            return this;
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder addExtra(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = ImmutableMap.builder();
            }
            this.extrasBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder addExtras(Map<String, String> extras) {
            Preconditions.checkArgument((null != extras ? 1 : 0) != 0, (Object)"extras should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = ImmutableMap.builder();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put((Object)key, (Object)extras.get(key));
            }
            return this;
        }

        public Builder addExtra(String key, Number value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = ImmutableMap.builder();
            }
            this.numberExtrasBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder addExtra(String key, Boolean value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = ImmutableMap.builder();
            }
            this.booleanExtrasBuilder.put((Object)key, (Object)value);
            return this;
        }

        @Override
        public AndroidNotification build() {
            return new AndroidNotification(this.alert, this.title, this.builderId, null == this.extrasBuilder ? null : this.extrasBuilder.build(), null == this.numberExtrasBuilder ? null : this.numberExtrasBuilder.build(), null == this.booleanExtrasBuilder ? null : this.booleanExtrasBuilder.build());
        }
    }
}

