/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.notification.PlatformNotification;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class IosNotification
extends PlatformNotification {
    public static final String NOTIFICATION_IOS = "ios";
    private static final String DEFAULT_SOUND = "";
    private static final int BADGE_UNDEFINED = -1;
    private static final int DEFAULT_BADGE = 1;
    private static final String BADGE = "badge";
    private static final String SOUND = "sound";
    private static final String CONTENT_AVAILABLE = "content-available";
    private final boolean soundDisabled;
    private final boolean badgeDisabled;
    private final String sound;
    private final int badge;
    private final boolean contentAvailable;

    private IosNotification(String alert, String sound, int badge, boolean contentAvailable, boolean soundDisabled, boolean badgeDisabled, ImmutableMap<String, String> extras, ImmutableMap<String, Number> numberExtras, ImmutableMap<String, Boolean> booleanExtras) {
        super(alert, extras, numberExtras, booleanExtras);
        this.sound = sound;
        this.badge = badge;
        this.contentAvailable = contentAvailable;
        this.soundDisabled = soundDisabled;
        this.badgeDisabled = badgeDisabled;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static IosNotification alert(String alert) {
        return IosNotification.newBuilder().setAlert(alert).build();
    }

    @Override
    public String getPlatform() {
        return NOTIFICATION_IOS;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = super.toJSON().getAsJsonObject();
        if (!this.badgeDisabled) {
            if (this.badge >= 0) {
                json.add(BADGE, (JsonElement)new JsonPrimitive((Number)this.badge));
            } else if (this.badge == -1) {
                json.add(BADGE, (JsonElement)new JsonPrimitive((Number)1));
            }
        }
        if (!this.soundDisabled) {
            if (null != this.sound) {
                json.add(SOUND, (JsonElement)new JsonPrimitive(this.sound));
            } else {
                json.add(SOUND, (JsonElement)new JsonPrimitive(DEFAULT_SOUND));
            }
        }
        if (this.contentAvailable) {
            json.add(CONTENT_AVAILABLE, (JsonElement)new JsonPrimitive((Number)1));
        }
        return json;
    }

    public static class Builder
    extends PlatformNotification.Builder<IosNotification> {
        private String sound;
        private int badge = -1;
        private boolean contentAvailable = false;
        private boolean soundDisabled = false;
        private boolean badgeDisabled = false;

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder disableSound() {
            this.soundDisabled = true;
            return this;
        }

        public Builder setBadge(int badge) {
            this.badge = badge;
            return this;
        }

        public Builder disableBadge() {
            this.badgeDisabled = true;
            return this;
        }

        public Builder setContentAvailable(boolean contentAvailable) {
            this.contentAvailable = contentAvailable;
            return this;
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder addExtra(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = ImmutableMap.builder();
            }
            this.extrasBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder addExtras(Map<String, String> extras) {
            Preconditions.checkArgument((null != extras ? 1 : 0) != 0, (Object)"extras should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = ImmutableMap.builder();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put((Object)key, (Object)extras.get(key));
            }
            return this;
        }

        public Builder addExtra(String key, Number value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = ImmutableMap.builder();
            }
            this.numberExtrasBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder addExtra(String key, Boolean value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = ImmutableMap.builder();
            }
            this.booleanExtrasBuilder.put((Object)key, (Object)value);
            return this;
        }

        @Override
        public IosNotification build() {
            return new IosNotification(this.alert, this.sound, this.badge, this.contentAvailable, this.soundDisabled, this.badgeDisabled, null == this.extrasBuilder ? null : this.extrasBuilder.build(), null == this.numberExtrasBuilder ? null : this.numberExtrasBuilder.build(), null == this.booleanExtrasBuilder ? null : this.booleanExtrasBuilder.build());
        }
    }
}

