/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.PushModel;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import cn.jpush.api.push.model.notification.WinphoneNotification;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class Notification
implements PushModel {
    private final String alert;
    private final ImmutableSet<PlatformNotification> notifications;

    private Notification(String alert, ImmutableSet<PlatformNotification> notifications) {
        this.alert = alert;
        this.notifications = notifications;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Notification alert(String alert) {
        return Notification.newBuilder().setAlert(alert).build();
    }

    public static Notification android(String alert, String title, Map<String, String> extras) {
        return Notification.newBuilder().addPlatformNotification(AndroidNotification.newBuilder().setAlert(alert).setTitle(title).addExtras(extras).build()).build();
    }

    public static Notification ios(String alert, Map<String, String> extras) {
        return Notification.newBuilder().addPlatformNotification(IosNotification.newBuilder().setAlert(alert).addExtras(extras).build()).build();
    }

    public static Notification winphone(String alert, Map<String, String> extras) {
        return Notification.newBuilder().addPlatformNotification(WinphoneNotification.newBuilder().setAlert(alert).addExtras(extras).build()).build();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.alert) {
            json.add("alert", (JsonElement)new JsonPrimitive(this.alert));
        }
        if (null != this.notifications) {
            for (PlatformNotification pn : this.notifications) {
                if (this.alert != null && pn.getAlert() == null) {
                    pn.setAlert(this.alert);
                }
                Preconditions.checkArgument((null != pn.getAlert() ? 1 : 0) != 0, (Object)"For any platform notification, alert field is needed. It can be empty string.");
                json.add(pn.getPlatform(), pn.toJSON());
            }
        }
        return json;
    }

    public static class Builder {
        private String alert;
        private ImmutableSet.Builder<PlatformNotification> builder;

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder addPlatformNotification(PlatformNotification notification) {
            if (null == this.builder) {
                this.builder = ImmutableSet.builder();
            }
            this.builder.add((Object)notification);
            return this;
        }

        public Notification build() {
            Preconditions.checkArgument((null != this.builder || null != this.alert ? 1 : 0) != 0, (Object)"No notification payload is set.");
            return new Notification(this.alert, null == this.builder ? null : this.builder.build());
        }
    }
}

