/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.report;

import cn.jpush.api.common.APIConnectionException;
import cn.jpush.api.common.APIRequestException;
import cn.jpush.api.common.NativeHttpClient;
import cn.jpush.api.common.ResponseWrapper;
import cn.jpush.api.common.ServiceHelper;
import cn.jpush.api.common.TimeUnit;
import cn.jpush.api.report.MessagesResult;
import cn.jpush.api.report.ReceivedsResult;
import cn.jpush.api.report.UsersResult;
import cn.jpush.api.utils.StringUtils;
import java.net.URLEncoder;
import java.util.regex.Pattern;

public class ReportClient {
    private static final String REPORT_HOST_NAME = "https://report.jpush.cn";
    private static final String REPORT_RECEIVE_PATH = "/v3/received";
    private static final String REPORT_USER_PATH = "/v3/users";
    private static final String REPORT_MESSAGE_PATH = "/v3/messages";
    private final NativeHttpClient _httpClient;
    private String _masterSecret;
    private String _appKey;
    private static final Pattern MSGID_PATTERNS = Pattern.compile("[^0-9, ]");

    public ReportClient(String masterSecret, String appKey, int maxRetryTimes) {
        this._masterSecret = masterSecret;
        this._appKey = appKey;
        ServiceHelper.checkBasic(appKey, masterSecret);
        this._httpClient = new NativeHttpClient(maxRetryTimes);
    }

    public ReportClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, 3);
    }

    public ReceivedsResult getReceiveds(String[] msgIdArray) throws APIConnectionException, APIRequestException {
        return this.getReceiveds(StringUtils.arrayToString(msgIdArray));
    }

    public ReceivedsResult getReceiveds(String msgIds) throws APIConnectionException, APIRequestException {
        ReportClient.checkMsgids(msgIds);
        String authCode = ServiceHelper.getAuthorizationBase64(this._appKey, this._masterSecret);
        String url = "https://report.jpush.cn/v3/received?msg_ids=" + msgIds;
        ResponseWrapper response = this._httpClient.sendGet(url, null, authCode);
        return ReceivedsResult.fromResponse(response);
    }

    public MessagesResult getMessages(String msgIds) throws APIConnectionException, APIRequestException {
        ReportClient.checkMsgids(msgIds);
        String authCode = ServiceHelper.getAuthorizationBase64(this._appKey, this._masterSecret);
        String url = "https://report.jpush.cn/v3/messages?msg_ids=" + msgIds;
        ResponseWrapper response = this._httpClient.sendGet(url, null, authCode);
        return MessagesResult.fromResponse(response);
    }

    public UsersResult getUsers(TimeUnit timeUnit, String start, int duration) throws APIConnectionException, APIRequestException {
        String authCode = ServiceHelper.getAuthorizationBase64(this._appKey, this._masterSecret);
        String startEncoded = null;
        try {
            startEncoded = URLEncoder.encode(start, "utf-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        String url = "https://report.jpush.cn/v3/users?time_unit=" + timeUnit.toString() + "&start=" + startEncoded + "&duration=" + duration;
        ResponseWrapper response = this._httpClient.sendGet(url, null, authCode);
        return UsersResult.fromResponse(response);
    }

    public static void checkMsgids(String msgIds) {
        if (StringUtils.isTrimedEmpty(msgIds)) {
            throw new IllegalArgumentException("msgIds param is required.");
        }
        if (MSGID_PATTERNS.matcher(msgIds).find()) {
            throw new IllegalArgumentException("msgIds param format is incorrect. It should be msg_id (number) which response from JPush Push API. If there are many, use ',' as interval. ");
        }
        if ((msgIds = msgIds.trim()).endsWith(",")) {
            msgIds = msgIds.substring(0, msgIds.length() - 1);
        }
        String[] splits = msgIds.split(",");
        try {
            for (String s : splits) {
                if (StringUtils.isEmpty(s = s.trim())) continue;
                Integer.parseInt(s);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Every msg_id should be valid Integer number which splits by ','");
        }
    }
}

