/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api;

import cn.jpush.api.common.TimeUnit;
import cn.jpush.api.common.connection.HttpProxy;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.common.resp.BooleanResult;
import cn.jpush.api.common.resp.DefaultResult;
import cn.jpush.api.device.AliasDeviceListResult;
import cn.jpush.api.device.DeviceClient;
import cn.jpush.api.device.TagAliasResult;
import cn.jpush.api.device.TagListResult;
import cn.jpush.api.push.PushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.report.MessagesResult;
import cn.jpush.api.report.ReceivedsResult;
import cn.jpush.api.report.ReportClient;
import cn.jpush.api.report.UsersResult;
import java.util.Map;
import java.util.Set;

public class JPushClient {
    private final PushClient _pushClient;
    private final ReportClient _reportClient;
    private final DeviceClient _deviceClient;

    public JPushClient(String masterSecret, String appKey) {
        this._pushClient = new PushClient(masterSecret, appKey);
        this._reportClient = new ReportClient(masterSecret, appKey);
        this._deviceClient = new DeviceClient(masterSecret, appKey);
    }

    public JPushClient(String masterSecret, String appKey, int maxRetryTimes) {
        this._pushClient = new PushClient(masterSecret, appKey, maxRetryTimes);
        this._reportClient = new ReportClient(masterSecret, appKey, maxRetryTimes);
        this._deviceClient = new DeviceClient(masterSecret, appKey, maxRetryTimes);
    }

    public JPushClient(String masterSecret, String appKey, int maxRetryTimes, HttpProxy proxy) {
        this._pushClient = new PushClient(masterSecret, appKey, maxRetryTimes, proxy);
        this._reportClient = new ReportClient(masterSecret, appKey, maxRetryTimes, proxy);
        this._deviceClient = new DeviceClient(masterSecret, appKey, maxRetryTimes, proxy);
    }

    public JPushClient(String masterSecret, String appKey, boolean apnsProduction, long timeToLive) {
        this._pushClient = new PushClient(masterSecret, appKey, apnsProduction, timeToLive);
        this._reportClient = new ReportClient(masterSecret, appKey);
        this._deviceClient = new DeviceClient(masterSecret, appKey);
    }

    public PushResult sendPush(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        return this._pushClient.sendPush(pushPayload);
    }

    public PushResult sendPush(String payloadString) throws APIConnectionException, APIRequestException {
        return this._pushClient.sendPush(payloadString);
    }

    public PushResult sendPushValidate(PushPayload paylaod) throws APIConnectionException, APIRequestException {
        return this._pushClient.sendPushValidate(paylaod);
    }

    public PushResult sendPushValidate(String payloadString) throws APIConnectionException, APIRequestException {
        return this._pushClient.sendPushValidate(payloadString);
    }

    public ReceivedsResult getReportReceiveds(String msgIds) throws APIConnectionException, APIRequestException {
        return this._reportClient.getReceiveds(msgIds);
    }

    public UsersResult getReportUsers(TimeUnit timeUnit, String start, int duration) throws APIConnectionException, APIRequestException {
        return this._reportClient.getUsers(timeUnit, start, duration);
    }

    public MessagesResult getReportMessages(String msgIds) throws APIConnectionException, APIRequestException {
        return this._reportClient.getMessages(msgIds);
    }

    public PushResult sendNotificationAll(String alert) throws APIConnectionException, APIRequestException {
        PushPayload payload = PushPayload.alertAll(alert);
        return this._pushClient.sendPush(payload);
    }

    public PushResult sendAndroidNotificationWithAlias(String title, String alert, Map<String, String> extras, String ... alias) throws APIConnectionException, APIRequestException {
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.alias(alias)).setNotification(Notification.android(alert, title, extras)).build();
        return this._pushClient.sendPush(payload);
    }

    public PushResult sendAndroidNotificationWithRegistrationID(String title, String alert, Map<String, String> extras, String ... registrationID) throws APIConnectionException, APIRequestException {
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.registrationId(registrationID)).setNotification(Notification.android(alert, title, extras)).build();
        return this._pushClient.sendPush(payload);
    }

    public PushResult sendIosNotificationWithAlias(String alert, Map<String, String> extras, String ... alias) throws APIConnectionException, APIRequestException {
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.alias(alias)).setNotification(Notification.ios(alert, extras)).build();
        return this._pushClient.sendPush(payload);
    }

    public PushResult sendIosNotificationWithRegistrationID(String alert, Map<String, String> extras, String ... registrationID) throws APIConnectionException, APIRequestException {
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.registrationId(registrationID)).setNotification(Notification.ios(alert, extras)).build();
        return this._pushClient.sendPush(payload);
    }

    public PushResult sendMessageAll(String msgContent) throws APIConnectionException, APIRequestException {
        PushPayload payload = PushPayload.messageAll(msgContent);
        return this._pushClient.sendPush(payload);
    }

    public PushResult sendAndroidMessageWithAlias(String title, String msgContent, String ... alias) throws APIConnectionException, APIRequestException {
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.alias(alias)).setMessage(Message.newBuilder().setTitle(title).setMsgContent(msgContent).build()).build();
        return this._pushClient.sendPush(payload);
    }

    public PushResult sendAndroidMessageWithRegistrationID(String title, String msgContent, String ... registrationID) throws APIConnectionException, APIRequestException {
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.registrationId(registrationID)).setMessage(Message.newBuilder().setTitle(title).setMsgContent(msgContent).build()).build();
        return this._pushClient.sendPush(payload);
    }

    public PushResult sendIosMessageWithAlias(String title, String msgContent, String ... alias) throws APIConnectionException, APIRequestException {
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.alias(alias)).setMessage(Message.newBuilder().setTitle(title).setMsgContent(msgContent).build()).build();
        return this._pushClient.sendPush(payload);
    }

    public PushResult sendIosMessageWithRegistrationID(String title, String msgContent, String ... registrationID) throws APIConnectionException, APIRequestException {
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.registrationId(registrationID)).setMessage(Message.newBuilder().setTitle(title).setMsgContent(msgContent).build()).build();
        return this._pushClient.sendPush(payload);
    }

    public PushResult sendMessageWithRegistrationID(String title, String msgContent, String ... registrationID) throws APIConnectionException, APIRequestException {
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.registrationId(registrationID)).setMessage(Message.newBuilder().setTitle(title).setMsgContent(msgContent).build()).build();
        return this._pushClient.sendPush(payload);
    }

    public TagAliasResult getDeviceTagAlias(String registrationId) throws APIConnectionException, APIRequestException {
        return this._deviceClient.getDeviceTagAlias(registrationId);
    }

    public DefaultResult updateDeviceTagAlias(String registrationId, boolean clearAlias, boolean clearTag) throws APIConnectionException, APIRequestException {
        return this._deviceClient.updateDeviceTagAlias(registrationId, clearAlias, clearTag);
    }

    public DefaultResult updateDeviceTagAlias(String registrationId, String alias, Set<String> tagsToAdd, Set<String> tagsToRemove) throws APIConnectionException, APIRequestException {
        return this._deviceClient.updateDeviceTagAlias(registrationId, alias, tagsToAdd, tagsToRemove);
    }

    public TagListResult getTagList() throws APIConnectionException, APIRequestException {
        return this._deviceClient.getTagList();
    }

    public BooleanResult isDeviceInTag(String theTag, String registrationID) throws APIConnectionException, APIRequestException {
        return this._deviceClient.isDeviceInTag(theTag, registrationID);
    }

    public DefaultResult addRemoveDevicesFromTag(String theTag, Set<String> toAddUsers, Set<String> toRemoveUsers) throws APIConnectionException, APIRequestException {
        return this._deviceClient.addRemoveDevicesFromTag(theTag, toAddUsers, toRemoveUsers);
    }

    public DefaultResult deleteTag(String theTag, String platform) throws APIConnectionException, APIRequestException {
        return this._deviceClient.deleteTag(theTag, platform);
    }

    public AliasDeviceListResult getAliasDeviceList(String alias, String platform) throws APIConnectionException, APIRequestException {
        return this._deviceClient.getAliasDeviceList(alias, platform);
    }

    public DefaultResult deleteAlias(String alias, String platform) throws APIConnectionException, APIRequestException {
        return this._deviceClient.deleteAlias(alias, platform);
    }
}

