/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.report;

import cn.jpush.api.common.ClientConfig;
import cn.jpush.api.common.ServiceHelper;
import cn.jpush.api.common.TimeUnit;
import cn.jpush.api.common.connection.HttpProxy;
import cn.jpush.api.common.connection.NativeHttpClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.common.resp.BaseResult;
import cn.jpush.api.common.resp.ResponseWrapper;
import cn.jpush.api.report.MessagesResult;
import cn.jpush.api.report.ReceivedsResult;
import cn.jpush.api.report.UsersResult;
import cn.jpush.api.utils.StringUtils;
import java.net.URLEncoder;
import java.util.regex.Pattern;

public class ReportClient {
    private final NativeHttpClient _httpClient;
    private String _hostName;
    private String _receivePath;
    private String _userPath;
    private String _messagePath;
    private static final Pattern MSGID_PATTERNS = Pattern.compile("[^0-9, ]");

    public ReportClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, 3, null);
    }

    public ReportClient(String masterSecret, String appKey, int maxRetryTimes) {
        this(masterSecret, appKey, maxRetryTimes, null);
    }

    public ReportClient(String masterSecret, String appKey, int maxRetryTimes, HttpProxy proxy) {
        this(masterSecret, appKey, maxRetryTimes, proxy, ClientConfig.getInstance());
    }

    public ReportClient(String masterSecret, String appKey, int maxRetryTimes, HttpProxy proxy, ClientConfig conf) {
        ServiceHelper.checkBasic(appKey, masterSecret);
        this._hostName = (String)conf.get("report.host.name");
        this._receivePath = (String)conf.get("report.receive.path");
        this._userPath = (String)conf.get("report.user.path");
        this._messagePath = (String)conf.get("report.message.path");
        String authCode = ServiceHelper.getBasicAuthorization(appKey, masterSecret);
        this._httpClient = new NativeHttpClient(authCode, maxRetryTimes, proxy);
    }

    public ReceivedsResult getReceiveds(String[] msgIdArray) throws APIConnectionException, APIRequestException {
        return this.getReceiveds(StringUtils.arrayToString(msgIdArray));
    }

    public ReceivedsResult getReceiveds(String msgIds) throws APIConnectionException, APIRequestException {
        ReportClient.checkMsgids(msgIds);
        String url = this._hostName + this._receivePath + "?msg_ids=" + msgIds;
        ResponseWrapper response = this._httpClient.sendGet(url);
        return ReceivedsResult.fromResponse(response);
    }

    public MessagesResult getMessages(String msgIds) throws APIConnectionException, APIRequestException {
        ReportClient.checkMsgids(msgIds);
        String url = this._hostName + this._messagePath + "?msg_ids=" + msgIds;
        ResponseWrapper response = this._httpClient.sendGet(url);
        return MessagesResult.fromResponse(response);
    }

    public UsersResult getUsers(TimeUnit timeUnit, String start, int duration) throws APIConnectionException, APIRequestException {
        String startEncoded = null;
        try {
            startEncoded = URLEncoder.encode(start, "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String url = this._hostName + this._userPath + "?time_unit=" + timeUnit.toString() + "&start=" + startEncoded + "&duration=" + duration;
        ResponseWrapper response = this._httpClient.sendGet(url);
        return BaseResult.fromResponse(response, UsersResult.class);
    }

    public static void checkMsgids(String msgIds) {
        if (StringUtils.isTrimedEmpty(msgIds)) {
            throw new IllegalArgumentException("msgIds param is required.");
        }
        if (MSGID_PATTERNS.matcher(msgIds).find()) {
            throw new IllegalArgumentException("msgIds param format is incorrect. It should be msg_id (number) which response from JPush Push API. If there are many, use ',' as interval. ");
        }
        if ((msgIds = msgIds.trim()).endsWith(",")) {
            msgIds = msgIds.substring(0, msgIds.length() - 1);
        }
        String[] splits = msgIds.split(",");
        try {
            for (String s : splits) {
                if (StringUtils.isEmpty(s = s.trim())) continue;
                Long.parseLong(s);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Every msg_id should be valid Long number which splits by ','");
        }
    }
}

