/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.common.resp;

import cn.jpush.api.common.resp.IRateLimiting;
import cn.jpush.api.common.resp.ResponseWrapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public abstract class BaseResult
implements IRateLimiting {
    public static final int ERROR_CODE_NONE = -1;
    public static final int ERROR_CODE_OK = 0;
    public static final String ERROR_MESSAGE_NONE = "None error message.";
    protected static final int RESPONSE_OK = 200;
    protected static Gson _gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    private ResponseWrapper responseWrapper;

    public void setResponseWrapper(ResponseWrapper responseWrapper) {
        this.responseWrapper = responseWrapper;
    }

    public String getOriginalContent() {
        if (null != this.responseWrapper) {
            return this.responseWrapper.responseContent;
        }
        return null;
    }

    public int getResponseCode() {
        if (null != this.responseWrapper) {
            return this.responseWrapper.responseCode;
        }
        return -1;
    }

    public boolean isResultOK() {
        if (null != this.responseWrapper) {
            return this.responseWrapper.responseCode / 200 == 1;
        }
        return false;
    }

    public static <T extends BaseResult> T fromResponse(ResponseWrapper responseWrapper, Class<T> clazz) {
        BaseResult result = null;
        if (responseWrapper.isServerResponse()) {
            result = (BaseResult)_gson.fromJson(responseWrapper.responseContent, clazz);
        } else {
            try {
                result = (BaseResult)clazz.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        result.setResponseWrapper(responseWrapper);
        return (T)result;
    }

    @Override
    public int getRateLimitQuota() {
        if (null != this.responseWrapper) {
            return this.responseWrapper.rateLimitQuota;
        }
        return 0;
    }

    @Override
    public int getRateLimitRemaining() {
        if (null != this.responseWrapper) {
            return this.responseWrapper.rateLimitRemaining;
        }
        return 0;
    }

    @Override
    public int getRateLimitReset() {
        if (null != this.responseWrapper) {
            return this.responseWrapper.rateLimitReset;
        }
        return 0;
    }

    public String toString() {
        return _gson.toJson((Object)this);
    }
}

