/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.connection.NativeHttpClient;
import cn.jiguang.common.connection.NettyHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.BaseResult;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jpush.api.push.CIDResult;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.PushPayload;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;

public class PushClient {
    private IHttpClient _httpClient;
    private String _baseUrl;
    private String _pushPath;
    private String _pushValidatePath;
    private JsonParser _jsonParser = new JsonParser();
    private int _apnsProduction;
    private long _timeToLive;

    public PushClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, null, ClientConfig.getInstance());
    }

    @Deprecated
    public PushClient(String masterSecret, String appKey, int maxRetryTimes) {
        this(masterSecret, appKey, maxRetryTimes, null);
    }

    @Deprecated
    public PushClient(String masterSecret, String appKey, int maxRetryTimes, HttpProxy proxy) {
        ServiceHelper.checkBasic((String)appKey, (String)masterSecret);
        ClientConfig conf = ClientConfig.getInstance();
        conf.setMaxRetryTimes(maxRetryTimes);
        this._baseUrl = (String)conf.get((Object)"push.host.name");
        this._pushPath = (String)conf.get((Object)"push.path");
        this._pushValidatePath = (String)conf.get((Object)"push.validate.path");
        this._apnsProduction = (Integer)conf.get((Object)"apns.production");
        this._timeToLive = (Long)conf.get((Object)"time.to.live");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public PushClient(String masterSecret, String appKey, HttpProxy proxy, ClientConfig conf) {
        ServiceHelper.checkBasic((String)appKey, (String)masterSecret);
        this._baseUrl = (String)conf.get((Object)"push.host.name");
        this._pushPath = (String)conf.get((Object)"push.path");
        this._pushValidatePath = (String)conf.get((Object)"push.validate.path");
        this._apnsProduction = (Integer)conf.get((Object)"apns.production");
        this._timeToLive = (Long)conf.get((Object)"time.to.live");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    @Deprecated
    public PushClient(String masterSecret, String appKey, boolean apnsProduction, long timeToLive) {
        this(masterSecret, appKey);
        this._apnsProduction = apnsProduction ? 1 : 0;
        this._timeToLive = timeToLive;
    }

    @Deprecated
    public void setDefaults(boolean apnsProduction, long timeToLive) {
        this._apnsProduction = apnsProduction ? 1 : 0;
        this._timeToLive = timeToLive;
    }

    public void setBaseUrl(String baseUrl) {
        this._baseUrl = baseUrl;
    }

    public PushResult sendPush(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != pushPayload ? 1 : 0) != 0, (Object)"pushPayload should not be null");
        if (this._apnsProduction > 0) {
            pushPayload.resetOptionsApnsProduction(true);
        } else if (this._apnsProduction == 0) {
            pushPayload.resetOptionsApnsProduction(false);
        }
        if (this._timeToLive >= 0L) {
            pushPayload.resetOptionsTimeToLive(this._timeToLive);
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._pushPath, pushPayload.toString());
        return (PushResult)BaseResult.fromResponse((ResponseWrapper)response, PushResult.class);
    }

    public PushResult sendPushValidate(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != pushPayload ? 1 : 0) != 0, (Object)"pushPayload should not be null");
        if (this._apnsProduction > 0) {
            pushPayload.resetOptionsApnsProduction(true);
        } else if (this._apnsProduction == 0) {
            pushPayload.resetOptionsApnsProduction(false);
        }
        if (this._timeToLive >= 0L) {
            pushPayload.resetOptionsTimeToLive(this._timeToLive);
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._pushValidatePath, pushPayload.toString());
        return (PushResult)BaseResult.fromResponse((ResponseWrapper)response, PushResult.class);
    }

    public PushResult sendPush(String payloadString) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)payloadString), (Object)"pushPayload should not be empty");
        try {
            this._jsonParser.parse(payloadString);
        }
        catch (JsonParseException e) {
            Preconditions.checkArgument((boolean)false, (Object)"payloadString should be a valid JSON string.");
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._pushPath, payloadString);
        return (PushResult)BaseResult.fromResponse((ResponseWrapper)response, PushResult.class);
    }

    public PushResult sendPushValidate(String payloadString) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)payloadString), (Object)"pushPayload should not be empty");
        try {
            this._jsonParser.parse(payloadString);
        }
        catch (JsonParseException e) {
            Preconditions.checkArgument((boolean)false, (Object)"payloadString should be a valid JSON string.");
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._pushValidatePath, payloadString);
        return (PushResult)BaseResult.fromResponse((ResponseWrapper)response, PushResult.class);
    }

    public CIDResult getCidList(int count, String type) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((count >= 1 && count <= 1000 ? 1 : 0) != 0, (Object)"count should not less than 1 or larger than 1000");
        Preconditions.checkArgument((type == null || type.equals("push") || type.equals("schedule") ? 1 : 0) != 0, (Object)"type should be \"push\" or \"schedule\"");
        ResponseWrapper responseWrapper = type != null ? this._httpClient.sendGet(this._baseUrl + this._pushPath + "/cid?count=" + count + "&type=" + type) : this._httpClient.sendGet(this._baseUrl + this._pushPath + "/cid?count=" + count);
        return (CIDResult)BaseResult.fromResponse((ResponseWrapper)responseWrapper, CIDResult.class);
    }

    public void setHttpClient(IHttpClient client) {
        this._httpClient = client;
    }

    public void close() {
        if (this._httpClient != null && this._httpClient instanceof NettyHttpClient) {
            ((NettyHttpClient)this._httpClient).close();
        }
    }
}

