/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.ConfigManager;
import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.upload.StorageManager;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;

public final class Base64Uploader {
    public static State save(HttpServletRequest request, Map<String, Object> conf) {
        long maxSize;
        String filedName = (String)conf.get("fieldName");
        String fileName = request.getParameter(filedName);
        byte[] data = Base64Uploader.decode(fileName);
        if (!Base64Uploader.validSize(data, maxSize = ((Long)conf.get("maxSize")).longValue())) {
            return new BaseState(false, 1);
        }
        String suffix = FileType.getSuffix("JPG");
        String savePath = PathFormat.parse((String)conf.get("savePath"), (String)conf.get("filename"));
        savePath = savePath + suffix;
        String rootPath = ConfigManager.getRootPath(request, conf);
        String physicalPath = rootPath + savePath;
        State storageState = StorageManager.saveBinaryFile(data, physicalPath);
        if (storageState.isSuccess()) {
            storageState.putInfo("url", PathFormat.format(savePath));
            storageState.putInfo("type", suffix);
            storageState.putInfo("original", "");
        }
        return storageState;
    }

    private static byte[] decode(String content) {
        return Base64.decodeBase64((String)content);
    }

    private static boolean validSize(byte[] data, long length) {
        return (long)data.length <= length;
    }
}

