/*
 * Decompiled with CFR 0.152.
 */
package cn.zyjblogs.crypto.sm2;

import cn.zyjblogs.crypto.SmException;
import cn.zyjblogs.crypto.sm2.SM2EngineExtend;
import cn.zyjblogs.crypto.sm2.SM2KeyPair;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

public class SM2 {
    public static final String CRYPTO_NAME_SM2 = "sm2p256v1";
    public static final String BC04 = "04";
    private static final byte SM2_CIPHER_FIRST_BIT = 4;
    private static final int DEFAULT_KEY_SIZE = 128;

    public static SM2KeyPair generateSm2Keys(boolean compressed) {
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(domainParameters, new SecureRandom()));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = keyPairGenerator.generateKeyPair();
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ECPoint ecPoint = publicKeyParameters.getQ();
        String publicKey = Hex.toHexString((byte[])ecPoint.getEncoded(compressed)).toUpperCase(Locale.ROOT);
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BigInteger intPrivateKey = privateKeyParameters.getD();
        String privateKey = intPrivateKey.toString(16).toUpperCase(Locale.ROOT);
        return new SM2KeyPair(publicKey, privateKey);
    }

    public static String encrypt(String pubKey, String data) {
        return SM2.encrypt(pubKey, data, SM2EngineExtend.CIPHER_MODE_NORM, EncodeType.UTF8, EncodeType.HEX);
    }

    public static String encrypt(String pubKey, String data, EncodeType inputType, EncodeType outType) {
        return SM2.encrypt(pubKey, data, SM2EngineExtend.CIPHER_MODE_NORM, inputType, outType);
    }

    public static String encrypt(String pubKey, String data, Mode mode, EncodeType inputType, EncodeType outType) {
        return SM2.encrypt(pubKey, data, Mode.CIPHER_MODE_BC == mode ? SM2EngineExtend.CIPHER_MODE_BC : SM2EngineExtend.CIPHER_MODE_NORM, inputType, outType);
    }

    public static String encrypt(String pubKey, String data, int cipherMode, EncodeType inputType, EncodeType outType) {
        if (Objects.equals((Object)EncodeType.UTF8, (Object)outType)) {
            throw new SmException("\u52a0\u5bc6\u6682\u4e0d\u652f\u6301UTF-8\u7f16\u7801\u683c\u5f0f\u6570\u636e\u8f93\u51fa!,\u8bf7\u4fee\u6539\u8f93\u51fa\u7c7b\u578b");
        }
        try {
            if (pubKey.length() == 128) {
                pubKey = BC04 + pubKey;
            }
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
            ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)pubKey));
            ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
            SM2EngineExtend sm2Engine = new SM2EngineExtend();
            sm2Engine.init(true, cipherMode, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
            byte[] in = EncodeType.HEX.equals((Object)inputType) ? Hex.decode((String)data) : (EncodeType.BASE64.equals((Object)inputType) ? Base64.getDecoder().decode(data.getBytes(StandardCharsets.UTF_8)) : data.getBytes(StandardCharsets.UTF_8));
            return SM2.processBlock(sm2Engine, outType, in);
        }
        catch (InvalidCipherTextException e) {
            throw new SmException("\u52a0\u5bc6\u9519\u8bef", e);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    private static String processBlock(SM2EngineExtend sm2Engine, EncodeType outType, byte[] in) throws InvalidCipherTextException {
        byte[] arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
        if (EncodeType.BASE64.equals((Object)outType)) {
            byte[] base64Bytes = Base64.getEncoder().encode(arrayOfBytes);
            return new String(base64Bytes, StandardCharsets.UTF_8);
        }
        if (EncodeType.HEX.equals((Object)outType)) {
            return Hex.toHexString((byte[])arrayOfBytes).toUpperCase(Locale.ROOT);
        }
        return new String(arrayOfBytes, StandardCharsets.UTF_8);
    }

    private static byte[] addBitIfNeed(byte[] base64Decode) {
        byte first = base64Decode[0];
        if (first == 4) {
            return base64Decode;
        }
        byte[] finalByte = new byte[base64Decode.length + 1];
        finalByte[0] = 4;
        System.arraycopy(base64Decode, 0, finalByte, 1, base64Decode.length);
        return finalByte;
    }

    public static String decrypt(String priKey, String cipherData) {
        return SM2.decrypt(priKey, cipherData, SM2EngineExtend.CIPHER_MODE_NORM, EncodeType.HEX, EncodeType.UTF8);
    }

    public static String decrypt(String priKey, String cipherData, EncodeType inputType, EncodeType outType) {
        return SM2.decrypt(priKey, cipherData, SM2EngineExtend.CIPHER_MODE_NORM, inputType, outType);
    }

    public static String decrypt(String priKey, String cipherData, int cipherMode, EncodeType inputType, EncodeType outType) {
        if (Objects.equals((Object)EncodeType.UTF8, (Object)inputType)) {
            throw new SmException("\u89e3\u5bc6\u6682\u4e0d\u652f\u6301UTF-8\u7f16\u7801\u683c\u5f0f\u6570\u636e\u8f93\u5165!,\u8bf7\u4fee\u6539\u8f93\u5165\u7c7b\u578b");
        }
        try {
            byte[] cipherDataByte;
            if (EncodeType.HEX.equals((Object)inputType)) {
                if (!cipherData.startsWith(BC04)) {
                    cipherData = BC04 + cipherData;
                }
                cipherDataByte = Hex.decode((String)cipherData);
            } else if (EncodeType.BASE64.equals((Object)inputType)) {
                cipherDataByte = Base64.getDecoder().decode(cipherData);
                cipherDataByte = SM2.addBitIfNeed(cipherDataByte);
            } else {
                cipherDataByte = cipherData.getBytes(StandardCharsets.UTF_8);
            }
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
            BigInteger privateKeyD = new BigInteger(priKey, 16);
            ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
            SM2EngineExtend sm2Engine = new SM2EngineExtend();
            sm2Engine.init(false, cipherMode, (CipherParameters)privateKeyParameters);
            return SM2.processBlock(sm2Engine, outType, cipherDataByte);
        }
        catch (InvalidCipherTextException e) {
            throw new SmException("\u89e3\u5bc6\u9519\u8bef", e);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static String sign(String priKey, String plainText) {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN(), sm2ECParameters.getH());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)provider);
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)provider);
            BigInteger bigInteger = new BigInteger(priKey, 16);
            BCECPrivateKey bcecPrivateKey = (BCECPrivateKey)keyFactory.generatePrivate((KeySpec)new ECPrivateKeySpec(bigInteger, ecParameterSpec));
            signature.initSign((PrivateKey)bcecPrivateKey);
            signature.update(plainText.getBytes());
            return Hex.toHexString((byte[])signature.sign()).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static boolean verify(String pubKey, String plainText, String signatureValue) {
        if (pubKey.length() == 128) {
            pubKey = BC04 + pubKey;
        }
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN(), sm2ECParameters.getH());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)provider);
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)provider);
            ECPoint ecPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)pubKey));
            BCECPublicKey bcecPublicKey = (BCECPublicKey)keyFactory.generatePublic((KeySpec)new ECPublicKeySpec(ecPoint, ecParameterSpec));
            signature.initVerify((PublicKey)bcecPublicKey);
            signature.update(plainText.getBytes());
            return signature.verify(Hex.decode((String)signatureValue));
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static boolean certVerify(String certStr, String plaintext, String signValueStr) {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            byte[] signValue = Hex.decode((String)signValueStr);
            CertificateFactory factory = new CertificateFactory();
            X509Certificate certificate = (X509Certificate)factory.engineGenerateCertificate((InputStream)new ByteArrayInputStream(Hex.decode((String)certStr)));
            Signature signature = Signature.getInstance(certificate.getSigAlgName(), (Provider)provider);
            signature.initVerify(certificate);
            signature.update(plaintext.getBytes());
            return signature.verify(signValue);
        }
        catch (Exception e) {
            throw new SmException(e);
        }
    }

    public static void main(String[] args) {
        String data = "dPhq2XdoMcgD5m7M0I51SX7MkzMerWMcPdBdv/tX8B5jOyM28n+CcXUn721/9N0ELVgC2P0eBRn4jD04rPScJd5izcC7+xXT5LUwbV2S6wc0g2RC8nkuZITc4rdrACPvNxd18b6y";
        String pub = "0417f347d7fa08ae6ad9bf8ef6ac6c313810e05044290f7c18dc9b913b252603505cf7cdbf7ac7d88de508e78bbc2d74cb28c0a90724ed4b751cc69bdfe55b68de";
        String pri = "73d76cf4f553535d6ec45478fb1581baa0c83e166b347af10ab129966d3f187f";
        try {
            String decrypt2 = SM2.decrypt(pri, "BCWhJJ0BFPt/RuhS37sk22/5GuemkzG7kt+CLwRSz34taiKPjc0TDoY959dCf7C2cZJ2uzLoqRmcH/pV7uWGhPzTIZmKM8wPpVIeuN616dNVm+5/YpaQfcawis6KpJOeeU4fcyrYf9wcawtkow==", 1, EncodeType.BASE64, EncodeType.UTF8);
            System.out.println("-------------");
            System.out.println(decrypt2);
            String encrypt1 = SM2.encrypt(pub, decrypt2);
            System.out.println("-------------");
            System.out.println(encrypt1);
            String decrypt3 = SM2.decrypt(pri, encrypt1);
            System.out.println("aaa:" + decrypt3);
            String decrypt4 = SM2.encrypt(pub, decrypt3, 1, EncodeType.UTF8, EncodeType.BASE64);
            System.out.println(decrypt4);
            System.out.println("-----------");
            String decrypt5 = SM2.decrypt(pri, decrypt4, 1, EncodeType.BASE64, EncodeType.BASE64);
            System.out.println(decrypt5);
            String decrypt5_1 = SM2.encrypt(pub, decrypt5, 1, EncodeType.BASE64, EncodeType.BASE64);
            System.out.println(decrypt5_1);
            String decrypt5_2 = SM2.decrypt(pri, decrypt5_1, 1, EncodeType.BASE64, EncodeType.BASE64);
            System.out.println(decrypt5_2);
            System.out.println(new String(Base64.getDecoder().decode(decrypt5)));
            String decrypt6 = SM2.encrypt(pub, decrypt5, 1, EncodeType.BASE64, EncodeType.HEX);
            System.out.println(decrypt6);
            System.out.println("-----------");
            String decrypt7 = SM2.decrypt(pri, decrypt6, 1, EncodeType.HEX, EncodeType.UTF8);
            System.out.println(decrypt7);
            String decrypt8 = SM2.decrypt(pri, data, 1, EncodeType.BASE64, EncodeType.UTF8);
            System.out.println(decrypt8);
            String datanew = "BPCv4lM/sVXzEJ7uFkXrvuKUVFS3EU9uCkV9vhgJQb92cY3FWfIa1M1UtYxkbfleEdiZHZooh5DV3HaakkYsCTbR/lKF4FC3ZplGGf9rCbCuovf7fFf5TJwX2m83qkNMTuW4o9QdjOQu4MiFtYbTMMTSb/0kNKHkrT8mCSY+6yLg7XIHmzepoGiWhQ2KB9diF066YzjKNDGbP3u9/zoQBCFKr190G7F6NH042kfLPRrpV3IkewJbNKGCCQ0SIvNJ475beYq5jpRbug2WOsR8qLEsPsIl7SPXh0ezB1hLwgmqFqM/B3QbobKP+lFmtbjjIumLgdGM9OzmG82TFZM3k0piIYQPS6JPHjR3nqrnxpwYxn2bKUifnrrrM8smyoa99BzJ4IPnZ7/3oxLwkRFnMee8oyMy1WCab0k5OKmAM/dk2weflyhXyY5mxGYHjdjpsj9ipOcKjqF6LKobMxSAOpn+pRfywvJr/CKE1dcq7k1gK/xZozQVqyENoM3BEyVEYfEUHrI1pxG8/2ugYYXIN4jX6XqR8COxnJOS8XuPi8Ukqsx/E3EwgWEbI3PvtRRaiI4RNWyc1oMyNDr8Al5caf67cUo2pasoF8IrUlZtePBEAmITHfzVm9sCfGz4eNw5b2a5YSLofCYX7R6C0b/+69uutyhmLb3Na9TOyseTEYJcf0pzO8DHdWZDTldH8+swARdulURCBR3AMs2ePDnfJwMcEyNt1jpacVDSRPIVhxOcgdeD3juaYpiEYdVTPBHv+RJoOi6pv87ZheeDejjpGUMLAGEC/P+SpGdG8IT7THEPw16/hNK/lzqAzmYa7lkAH2WycWbnaBed3bHJbJBNjP9DsBpAf3V/PGreXNWeD66g+gCQDhyOUdiWqoaEoCLA7nkOcQqEeDZNegQn5ZfU/cW4yW1sxfb3CNzqxJaA/qayon+BeCYmy3FpA0SIkAbA0/qTG7VWg4u4kAQBG+FZ+lJ9Eaj9JaFiCgqfQRBMEoLuVdH24UeRljIfRptuYDcPydCFRzDWhYqwguPeGluEb9JO8eESZ+waX48xtniMvxbQ0CzfDlMWJwO9EiPJyIj2b86/ibBfSq9vuWwSdeLLL2Jvjn5LB9cwzSU8yQzLgle9YGSC0sbQIMuyFHUhDUVyFTVPE3/bYpotuetoeQVMYvLe9H73825Q6PxY+CCMHb0Jqjva2JAf6emYGx1vb5MGoJzoxz/7lSxJ56I9yMfrwLMljToMSufcV+bhQYb6r468qtQ10eXlKom/I8ZqZIJHsIaZBxsxJe1UyxqGitasg55gqNLLDwv+6UmnvGT/B6g9bmfc363/gO5mQlJfZSlpUodZrXMCYZmNI1ZZFRQbu5aEdtL9M2lXeCnTJa2GDOqpbG5I3aWVcepUcCsx4375bJOo3g24dwhzTCyh7/dW9sPhqb3SSXb/l+JxFzUoBXzxQgpBzakwq1uGrCKYPkNfYrmxRej87ZGgQFGlCVjEUHwRhvnkLHTXeP2f3b8zCeu+6us=";
            String decrypt9 = SM2.decrypt(pri, datanew, 1, EncodeType.BASE64, EncodeType.UTF8);
            System.out.println(decrypt9);
            SM2KeyPair sm2KeyPair = SM2.generateSm2Keys(true);
            System.out.println("\u516c\u94a5\n" + sm2KeyPair.getPublicKey());
            System.out.println("\u79c1\u94a5\n" + sm2KeyPair.getPrivateKey());
            String a = SM2.encrypt(sm2KeyPair.getPublicKey(), "\u597d\u5403\u554a");
            System.out.println(a);
            System.out.println(SM2.decrypt(sm2KeyPair.getPrivateKey(), a));
            String data1 = "c4eba3e104f1858a4ad0eeea125537e80ad28d10e6b084c26a1c318dba4bec334bf246cdd3900bc35e20a2c8bf6948a050f5c9077b0617db7d98489c37f3cc8aebebf98a39c0f127e6d37a8ec31f3968f07c7a01b8d3e1a554d53b75de8ede6d50050d8a1c60e976e74829b0f32bc049edf7";
            System.out.println(SM2.decrypt("69A124C827FA42573FF1047368BA8428C04A04B5B947BBD202956CF1A78D1FB0", data1, 1, EncodeType.HEX, EncodeType.UTF8));
            String sign = SM2.sign("69A124C827FA42573FF1047368BA8428C04A04B5B947BBD202956CF1A78D1FB0", data1);
            System.out.println("\u79c1\u94a5\u7b7e\u540d:\n" + sign);
            System.out.println(SM2.verify("032AB168CD73ED25824DB20B5F190C7C54971BC821450DEE0AC84C779CF3A9F897", data1, sign));
            String base64 = "BTcOfUO9+YxUeVl3nAkrebsu7H1scPwAppe0slpHLSMa4+2GhvW4ZTr++8AFT5pND3rcLtU76bzoIencvojqhvV8drMjGA6yPbp+6dg/KABNcE0SRwHhzNcTrf5SxTC4yI1TIuvo";
            String decrypt10 = SM2.decrypt(pri, base64, 1, EncodeType.BASE64, EncodeType.UTF8);
            System.out.println(decrypt10);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Mode {
        CIPHER_MODE_BC,
        CIPHER_MODE_NORM;

    }

    public static enum EncodeType {
        UTF8,
        HEX,
        BASE64;

    }
}

