/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.cli.completers;

import co.cask.common.cli.completers.AbstractCompleter;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class StringsCompleter
extends AbstractCompleter {
    protected abstract Supplier<Collection<String>> getStringsSupplier();

    @Override
    protected Collection<String> getAllCandidates() {
        return this.getStrings();
    }

    @Override
    protected Collection<String> getCandidates(String buffer) {
        ArrayList mutableCandidates = Lists.newArrayList();
        for (String candidate : this.getStrings()) {
            if (!candidate.startsWith(buffer)) continue;
            mutableCandidates.add(candidate);
        }
        Collections.sort(mutableCandidates, Ordering.usingToString());
        return Collections.unmodifiableList(mutableCandidates);
    }

    public Collection<String> getStrings() {
        return (Collection)this.getStringsSupplier().get();
    }
}

