/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.cli.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class TreeNode<T> {
    private final T data;
    private final ArrayList<TreeNode<T>> children;
    private final TreeNode<T> parent;

    public TreeNode(T data, TreeNode<T> parent) {
        this.data = data;
        this.parent = parent;
        this.children = Lists.newArrayList();
    }

    public TreeNode() {
        this(null, null);
    }

    public TreeNode<T> findChild(T childData) {
        for (TreeNode<T> candidate : this.children) {
            if (!childData.equals(candidate.data)) continue;
            return candidate;
        }
        return null;
    }

    public TreeNode<T> findOrCreateChild(T childData) {
        for (TreeNode<T> candidate : this.children) {
            if (!childData.equals(candidate.data)) continue;
            return candidate;
        }
        return this.addChild(childData);
    }

    public TreeNode<T> addChild(T data) {
        TreeNode<T> result = new TreeNode<T>(data, this);
        this.children.add(result);
        return result;
    }

    public T getData() {
        return this.data;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public String toString() {
        return "TreeNode{" + this.data + '}';
    }
}

