/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import co.cask.http.HttpResponder;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public abstract class AbstractHttpResponder
implements HttpResponder {
    private static final Gson GSON = new Gson();

    @Override
    public void sendJson(HttpResponseStatus status, Object object) {
        this.sendJson(status, object, object.getClass());
    }

    @Override
    public void sendJson(HttpResponseStatus status, Object object, Type type) {
        this.sendJson(status, object, type, GSON);
    }

    @Override
    public void sendJson(HttpResponseStatus status, Object object, Type type, Gson gson) {
        try {
            ChannelBuffer channelBuffer = ChannelBuffers.dynamicBuffer();
            try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new ChannelBufferOutputStream(channelBuffer), Charsets.UTF_8));){
                gson.toJson(object, type, jsonWriter);
            }
            this.sendContent(status, channelBuffer, "application/json", (Multimap<String, String>)ImmutableMultimap.of());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void sendString(HttpResponseStatus status, String data) {
        this.sendString(status, data, null);
    }

    @Override
    public void sendString(HttpResponseStatus status, String data, @Nullable Multimap<String, String> headers) {
        if (data == null) {
            this.sendStatus(status, headers);
            return;
        }
        try {
            ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer((ByteBuffer)Charsets.UTF_8.encode(data));
            this.sendContent(status, channelBuffer, "text/plain; charset=utf-8", headers);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void sendStatus(HttpResponseStatus status) {
        this.sendContent(status, null, null, (Multimap<String, String>)ImmutableMultimap.of());
    }

    @Override
    public void sendStatus(HttpResponseStatus status, @Nullable Multimap<String, String> headers) {
        this.sendContent(status, null, null, headers);
    }

    @Override
    public void sendByteArray(HttpResponseStatus status, byte[] bytes, @Nullable Multimap<String, String> headers) {
        ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer((byte[])bytes);
        this.sendContent(status, channelBuffer, "application/octet-stream", headers);
    }

    @Override
    public void sendBytes(HttpResponseStatus status, ByteBuffer buffer, @Nullable Multimap<String, String> headers) {
        this.sendContent(status, ChannelBuffers.wrappedBuffer((ByteBuffer)buffer), "application/octet-stream", headers);
    }
}

