/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import co.cask.http.AbstractHttpResponder;
import co.cask.http.BodyProducer;
import co.cask.http.ChannelChunkResponder;
import co.cask.http.ChunkResponder;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.channel.FileRegion;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHttpResponder
extends AbstractHttpResponder {
    private static final Logger LOG = LoggerFactory.getLogger(BasicHttpResponder.class);
    private final Channel channel;
    private final boolean keepAlive;
    private final AtomicBoolean responded;

    public BasicHttpResponder(Channel channel, boolean keepAlive) {
        this.channel = channel;
        this.keepAlive = keepAlive;
        this.responded = new AtomicBoolean(false);
    }

    @Override
    public ChunkResponder sendChunkStart(HttpResponseStatus status, @Nullable Multimap<String, String> headers) {
        Preconditions.checkArgument((status.getCode() >= 200 && status.getCode() < 210 ? 1 : 0) != 0, (Object)"Http Chunk Failure");
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        this.setCustomHeaders((HttpResponse)response, headers);
        response.setChunked(true);
        if (!this.hasContentLength(headers)) {
            response.setHeader("Transfer-Encoding", (Object)"chunked");
        }
        boolean responseKeepAlive = this.setResponseKeepAlive((HttpResponse)response);
        Preconditions.checkArgument((boolean)this.responded.compareAndSet(false, true), (Object)"Response has been already sent");
        this.channel.write((Object)response);
        return new ChannelChunkResponder(this.channel, responseKeepAlive);
    }

    @Override
    public void sendContent(HttpResponseStatus status, @Nullable ChannelBuffer content, String contentType, @Nullable Multimap<String, String> headers) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        this.setCustomHeaders((HttpResponse)response, headers);
        if (content != null) {
            response.setContent(content);
            response.setHeader("Content-Type", (Object)contentType);
            response.setHeader("Content-Length", (Object)content.readableBytes());
        } else {
            response.setHeader("Content-Length", (Object)0);
        }
        boolean responseKeepAlive = this.setResponseKeepAlive((HttpResponse)response);
        Preconditions.checkArgument((boolean)this.responded.compareAndSet(false, true), (Object)"Response has been already sent");
        ChannelFuture future = this.channel.write((Object)response);
        if (!responseKeepAlive) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void sendFile(File file, @Nullable Multimap<String, String> headers) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.setCustomHeaders((HttpResponse)response, headers);
        response.setHeader("Content-Length", (Object)file.length());
        boolean responseKeepAlive = this.setResponseKeepAlive((HttpResponse)response);
        Preconditions.checkArgument((boolean)this.responded.compareAndSet(false, true), (Object)"Response has been already sent");
        this.channel.write((Object)response);
        try {
            FileChannel fc = new RandomAccessFile(file, "r").getChannel();
            DefaultFileRegion region = new DefaultFileRegion(fc, 0L, file.length());
            ChannelFuture writeFuture = this.channel.write((Object)region);
            writeFuture.addListener(new ChannelFutureListener((FileRegion)region, responseKeepAlive){
                final /* synthetic */ FileRegion val$region;
                final /* synthetic */ boolean val$responseKeepAlive;
                {
                    this.val$region = fileRegion;
                    this.val$responseKeepAlive = bl;
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    this.val$region.releaseExternalResources();
                    if (!this.val$responseKeepAlive) {
                        BasicHttpResponder.this.channel.close();
                    }
                }
            });
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void sendContent(HttpResponseStatus status, final BodyProducer bodyProducer, @Nullable Multimap<String, String> headers) {
        long contentLength;
        try {
            contentLength = bodyProducer.getContentLength();
        }
        catch (Throwable t) {
            bodyProducer.handleError(t);
            this.sendContent(HttpResponseStatus.INTERNAL_SERVER_ERROR, ChannelBuffers.wrappedBuffer((ByteBuffer)Charsets.UTF_8.encode("Failed to determined content length. Cause: " + t.getMessage())), "text/plain", (Multimap<String, String>)ImmutableMultimap.of((Object)"Connection", (Object)"close"));
            return;
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.setCustomHeaders((HttpResponse)response, headers);
        response.setChunked(true);
        if (contentLength < 0L) {
            response.setHeader("Transfer-Encoding", (Object)"chunked");
            response.removeHeader("Content-Length");
        } else {
            response.setHeader("Content-Length", (Object)contentLength);
            response.removeHeader("Transfer-Encoding");
        }
        boolean responseKeepAlive = this.setResponseKeepAlive((HttpResponse)response);
        final ChannelFutureListener completionListener = this.createBodyProducerCompletionListener(bodyProducer, responseKeepAlive);
        Preconditions.checkArgument((boolean)this.responded.compareAndSet(false, true), (Object)"Response has been already sent");
        this.channel.write((Object)response).addListener(new ChannelFutureListener(){
            long size = 0L;

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    BasicHttpResponder.this.callBodyProducerHandleError(bodyProducer, future.getCause());
                    BasicHttpResponder.this.channel.close();
                    return;
                }
                try {
                    DefaultHttpChunk chunk = new DefaultHttpChunk(bodyProducer.nextChunk());
                    if (contentLength >= 0L) {
                        this.size += (long)chunk.getContent().readableBytes();
                        if (this.size > contentLength) {
                            BasicHttpResponder.this.callBodyProducerHandleError(bodyProducer, new IllegalStateException("Cannot write body longer than content length. Content-Length: " + contentLength + ", bytes produced: " + this.size));
                            BasicHttpResponder.this.channel.close();
                            return;
                        }
                        if (chunk.isLast() && this.size != contentLength) {
                            BasicHttpResponder.this.callBodyProducerHandleError(bodyProducer, new IllegalStateException("Body size doesn't match with content length. Content-Length: " + contentLength + ", bytes produced: " + this.size));
                            BasicHttpResponder.this.channel.close();
                            return;
                        }
                    }
                    ChannelFuture writeFuture = BasicHttpResponder.this.channel.write((Object)chunk);
                    if (chunk.isLast()) {
                        writeFuture.addListener(completionListener);
                    } else {
                        writeFuture.addListener((ChannelFutureListener)this);
                    }
                }
                catch (Throwable t) {
                    BasicHttpResponder.this.callBodyProducerHandleError(bodyProducer, t);
                    BasicHttpResponder.this.channel.close();
                }
            }
        });
    }

    private void callBodyProducerHandleError(BodyProducer bodyProducer, @Nullable Throwable failureCause) {
        try {
            bodyProducer.handleError(failureCause);
        }
        catch (Throwable t) {
            LOG.warn("Exception raised from BodyProducer.handleError() for {}", (Object)bodyProducer, (Object)t);
        }
    }

    private ChannelFutureListener createBodyProducerCompletionListener(final BodyProducer bodyProducer, final boolean responseKeepAlive) {
        return new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    BasicHttpResponder.this.callBodyProducerHandleError(bodyProducer, future.getCause());
                    BasicHttpResponder.this.channel.close();
                    return;
                }
                try {
                    bodyProducer.finished();
                    if (!responseKeepAlive) {
                        BasicHttpResponder.this.channel.close();
                    }
                }
                catch (Throwable t) {
                    BasicHttpResponder.this.callBodyProducerHandleError(bodyProducer, t);
                    BasicHttpResponder.this.channel.close();
                }
            }
        };
    }

    private void setCustomHeaders(HttpResponse response, @Nullable Multimap<String, String> headers) {
        if (headers != null) {
            for (Map.Entry entry : headers.asMap().entrySet()) {
                response.setHeader((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
    }

    private boolean setResponseKeepAlive(HttpResponse response) {
        boolean responseKeepAlive;
        boolean closeConn = "close".equalsIgnoreCase(response.getHeader("Connection"));
        boolean bl = responseKeepAlive = this.keepAlive && !closeConn;
        if (responseKeepAlive) {
            response.setHeader("Connection", (Object)"keep-alive");
        } else {
            response.setHeader("Connection", (Object)"close");
        }
        return responseKeepAlive;
    }

    private boolean hasContentLength(@Nullable Multimap<String, String> headers) {
        if (headers == null) {
            return false;
        }
        for (String key : headers.keySet()) {
            if (!"Content-Length".equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }
}

