/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import co.cask.http.ChunkResponder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;

final class ChannelChunkResponder
implements ChunkResponder {
    private final Channel channel;
    private final boolean keepAlive;
    private final AtomicBoolean closed;

    ChannelChunkResponder(Channel channel, boolean keepAlive) {
        this.channel = channel;
        this.keepAlive = keepAlive;
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public void sendChunk(ByteBuffer chunk) throws IOException {
        this.sendChunk(ChannelBuffers.wrappedBuffer((ByteBuffer)chunk));
    }

    @Override
    public void sendChunk(ChannelBuffer chunk) throws IOException {
        if (this.closed.get()) {
            throw new IOException("ChunkResponder already closed.");
        }
        if (!this.channel.isConnected()) {
            throw new IOException("Connection already closed.");
        }
        this.channel.write((Object)new DefaultHttpChunk(chunk));
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        ChannelFuture future = this.channel.write((Object)new DefaultHttpChunkTrailer());
        if (!this.keepAlive) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }
}

