/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

final class HandlerException
extends Exception {
    private final HttpResponseStatus failureStatus;
    private final String message;

    HandlerException(HttpResponseStatus failureStatus, String message) {
        super(message);
        this.failureStatus = failureStatus;
        this.message = message;
    }

    HandlerException(HttpResponseStatus failureStatus, String message, Throwable cause) {
        super(message, cause);
        this.failureStatus = failureStatus;
        this.message = message;
    }

    HttpResponse createFailureResponse() {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.failureStatus);
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)this.message, (Charset)Charsets.UTF_8));
        return response;
    }
}

