/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import co.cask.http.BodyConsumer;
import co.cask.http.ExceptionHandler;
import co.cask.http.HandlerException;
import co.cask.http.HttpHandler;
import co.cask.http.HttpResponder;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.ClosedChannelException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpMethodInfo {
    private static final Logger LOG = LoggerFactory.getLogger(HttpMethodInfo.class);
    private final Method method;
    private final HttpHandler handler;
    private final boolean isChunkedRequest;
    private final ChannelBuffer requestContent;
    private final HttpRequest request;
    private final HttpResponder responder;
    private final Object[] args;
    private final boolean isStreaming;
    private final ExceptionHandler exceptionHandler;
    private BodyConsumer bodyConsumer;

    HttpMethodInfo(Method method, HttpHandler handler, HttpRequest request, HttpResponder responder, Object[] args, ExceptionHandler exceptionHandler) {
        this.method = method;
        this.handler = handler;
        this.isChunkedRequest = request.isChunked();
        this.requestContent = request.getContent();
        this.isStreaming = BodyConsumer.class.isAssignableFrom(method.getReturnType());
        this.request = this.rewriteRequest(request, this.isStreaming);
        this.responder = responder;
        this.exceptionHandler = exceptionHandler;
        this.args = new Object[args.length + 2];
        this.args[0] = request;
        this.args[1] = responder;
        System.arraycopy(args, 0, this.args, 2, args.length);
    }

    void invoke() throws Exception {
        Object invokeResult;
        this.bodyConsumer = null;
        try {
            invokeResult = this.method.invoke((Object)this.handler, this.args);
        }
        catch (InvocationTargetException e) {
            this.exceptionHandler.handle(e.getTargetException(), this.request, this.responder);
            return;
        }
        if (this.isStreaming) {
            this.bodyConsumer = (BodyConsumer)invokeResult;
            if (this.bodyConsumer != null && this.requestContent.readable()) {
                this.bodyConsumerChunk(this.requestContent);
            }
            if (this.bodyConsumer != null && !this.isChunkedRequest) {
                this.bodyConsumerFinish();
            }
        }
    }

    void chunk(HttpChunk chunk) throws Exception {
        if (this.bodyConsumer == null) {
            return;
        }
        if (chunk.isLast()) {
            this.bodyConsumerFinish();
        } else {
            this.bodyConsumerChunk(chunk.getContent());
        }
    }

    void disconnected() {
        if (this.bodyConsumer != null) {
            this.bodyConsumerError(new ClosedChannelException());
        }
    }

    private void bodyConsumerChunk(ChannelBuffer buffer) throws HandlerException {
        try {
            this.bodyConsumer.chunk(buffer, this.responder);
        }
        catch (Throwable t) {
            try {
                this.bodyConsumerError(t);
            }
            catch (Throwable t2) {
                this.exceptionHandler.handle(t2, this.request, this.responder);
                LOG.debug("Handled exception thrown from handleError. original exception from chunk call was:", t);
                return;
            }
            this.exceptionHandler.handle(t, this.request, this.responder);
        }
    }

    private void bodyConsumerFinish() {
        BodyConsumer consumer = this.bodyConsumer;
        this.bodyConsumer = null;
        try {
            consumer.finished(this.responder);
        }
        catch (Throwable t) {
            this.exceptionHandler.handle(t, this.request, this.responder);
        }
    }

    private void bodyConsumerError(Throwable cause) {
        BodyConsumer consumer = this.bodyConsumer;
        this.bodyConsumer = null;
        consumer.handleError(cause);
    }

    void sendError(HttpResponseStatus status, Throwable ex) {
        String msg = ex instanceof InvocationTargetException ? String.format("Exception Encountered while processing request : %s", ((Throwable)Objects.firstNonNull((Object)ex.getCause(), (Object)ex)).getMessage()) : String.format("Exception Encountered while processing request: %s", ex.getMessage());
        this.responder.sendString(status, msg, (Multimap<String, String>)ImmutableMultimap.of((Object)"Connection", (Object)"close"));
        if (this.bodyConsumer != null) {
            this.bodyConsumerError(ex);
        }
    }

    boolean isStreaming() {
        return this.isStreaming;
    }

    private HttpRequest rewriteRequest(HttpRequest request, boolean isStreaming) {
        if (!isStreaming) {
            return request;
        }
        if (!request.isChunked() || request.getContent().readable()) {
            request.setChunked(true);
            request.setContent(ChannelBuffers.EMPTY_BUFFER);
        }
        return request;
    }
}

