/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import co.cask.http.ExceptionHandler;
import co.cask.http.HandlerContext;
import co.cask.http.HandlerException;
import co.cask.http.HandlerHook;
import co.cask.http.HandlerInfo;
import co.cask.http.HttpHandler;
import co.cask.http.HttpMethodInfo;
import co.cask.http.HttpResourceModel;
import co.cask.http.HttpResponder;
import co.cask.http.PatternPathRouterWithGroups;
import co.cask.http.URLRewriter;
import co.cask.http.WrappedHttpResponder;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpResourceHandler
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResourceHandler.class);
    private static final int MAX_PATH_PARTS = 25;
    private final PatternPathRouterWithGroups<HttpResourceModel> patternRouter = PatternPathRouterWithGroups.create(25);
    private final Iterable<HttpHandler> handlers;
    private final Iterable<HandlerHook> handlerHooks;
    private final URLRewriter urlRewriter;

    public HttpResourceHandler(Iterable<? extends HttpHandler> handlers, Iterable<? extends HandlerHook> handlerHooks, URLRewriter urlRewriter, ExceptionHandler exceptionHandler) {
        this.handlers = ImmutableList.copyOf(handlers);
        this.handlerHooks = ImmutableList.copyOf(handlerHooks);
        this.urlRewriter = urlRewriter;
        for (HttpHandler httpHandler : handlers) {
            LOG.trace("Parsing handler {}", (Object)httpHandler.getClass().getName());
            String basePath = "";
            if (httpHandler.getClass().isAnnotationPresent(Path.class)) {
                basePath = httpHandler.getClass().getAnnotation(Path.class).value();
            }
            for (Method method : httpHandler.getClass().getDeclaredMethods()) {
                if (method.getParameterTypes().length >= 2 && method.getParameterTypes()[0].isAssignableFrom(HttpRequest.class) && method.getParameterTypes()[1].isAssignableFrom(HttpResponder.class) && Modifier.isPublic(method.getModifiers())) {
                    String relativePath = "";
                    if (method.getAnnotation(Path.class) != null) {
                        relativePath = method.getAnnotation(Path.class).value();
                    }
                    String absolutePath = String.format("%s/%s", basePath, relativePath);
                    Set<HttpMethod> httpMethods = this.getHttpMethods(method);
                    Preconditions.checkArgument((httpMethods.size() >= 1 ? 1 : 0) != 0, (Object)String.format("No HttpMethod found for method: %s", method.getName()));
                    HttpResourceModel resourceModel = new HttpResourceModel(httpMethods, absolutePath, method, httpHandler, exceptionHandler);
                    LOG.trace("Adding resource model {}", (Object)resourceModel);
                    this.patternRouter.add(absolutePath, resourceModel);
                    continue;
                }
                LOG.trace("Not adding method {}({}) to path routing like. HTTP calls will not be routed to this method", (Object)method.getName(), method.getParameterTypes());
            }
        }
    }

    private Set<HttpMethod> getHttpMethods(Method method) {
        HashSet httpMethods = Sets.newHashSet();
        if (method.isAnnotationPresent(GET.class)) {
            httpMethods.add(HttpMethod.GET);
        }
        if (method.isAnnotationPresent(PUT.class)) {
            httpMethods.add(HttpMethod.PUT);
        }
        if (method.isAnnotationPresent(POST.class)) {
            httpMethods.add(HttpMethod.POST);
        }
        if (method.isAnnotationPresent(DELETE.class)) {
            httpMethods.add(HttpMethod.DELETE);
        }
        return ImmutableSet.copyOf((Collection)httpMethods);
    }

    public void handle(HttpRequest request, HttpResponder responder) {
        if (this.urlRewriter != null) {
            try {
                request.setUri(URI.create(request.getUri()).normalize().toString());
                if (!this.urlRewriter.rewrite(request, responder)) {
                    return;
                }
            }
            catch (Throwable t) {
                responder.sendString(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Caught exception processing request. Reason: %s", t.getMessage()));
                LOG.error("Exception thrown during rewriting of uri {}", (Object)request.getUri(), (Object)t);
                return;
            }
        }
        try {
            String path = URI.create(request.getUri()).normalize().getPath();
            List<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>> routableDestinations = this.patternRouter.getDestinations(path);
            PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel> matchedDestination = this.getMatchedDestination(routableDestinations, request.getMethod(), path);
            if (matchedDestination != null) {
                HttpResourceModel httpResourceModel = matchedDestination.getDestination();
                boolean terminated = false;
                HandlerInfo info = new HandlerInfo(httpResourceModel.getMethod().getDeclaringClass().getName(), httpResourceModel.getMethod().getName());
                for (HandlerHook hook : this.handlerHooks) {
                    if (hook.preCall(request, responder, info)) continue;
                    terminated = true;
                    break;
                }
                if (!terminated && httpResourceModel.handle(request, responder = new WrappedHttpResponder(responder, this.handlerHooks, request, info), matchedDestination.getGroupNameValues()).isStreaming()) {
                    responder.sendString(HttpResponseStatus.METHOD_NOT_ALLOWED, String.format("Body Consumer not supported for internalHttpResponder: %s", request.getUri()));
                }
            } else if (routableDestinations.size() > 0) {
                responder.sendString(HttpResponseStatus.METHOD_NOT_ALLOWED, String.format("Problem accessing: %s. Reason: Method Not Allowed", request.getUri()));
            } else {
                responder.sendString(HttpResponseStatus.NOT_FOUND, String.format("Problem accessing: %s. Reason: Not Found", request.getUri()));
            }
        }
        catch (Throwable t) {
            responder.sendString(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Caught exception processing request. Reason: %s", t.getMessage()));
            LOG.error("Exception thrown during request processing for uri {}", (Object)request.getUri(), (Object)t);
        }
    }

    public HttpMethodInfo getDestinationMethod(HttpRequest request, HttpResponder responder) throws Exception {
        block11: {
            if (this.urlRewriter != null) {
                try {
                    request.setUri(URI.create(request.getUri()).normalize().toString());
                    if (!this.urlRewriter.rewrite(request, responder)) {
                        return null;
                    }
                }
                catch (Throwable t) {
                    LOG.error("Exception thrown during rewriting of uri {}", (Object)request.getUri(), (Object)t);
                    throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Caught exception processing request. Reason: %s", t.getMessage()));
                }
            }
            try {
                String path = URI.create(request.getUri()).normalize().getPath();
                List<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>> routableDestinations = this.patternRouter.getDestinations(path);
                PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel> matchedDestination = this.getMatchedDestination(routableDestinations, request.getMethod(), path);
                if (matchedDestination != null) {
                    HttpResourceModel httpResourceModel = matchedDestination.getDestination();
                    boolean terminated = false;
                    HandlerInfo info = new HandlerInfo(httpResourceModel.getMethod().getDeclaringClass().getName(), httpResourceModel.getMethod().getName());
                    for (HandlerHook hook : this.handlerHooks) {
                        if (hook.preCall(request, responder, info)) continue;
                        terminated = true;
                        break;
                    }
                    if (!terminated) {
                        responder = new WrappedHttpResponder(responder, this.handlerHooks, request, info);
                        return httpResourceModel.handle(request, responder, matchedDestination.getGroupNameValues());
                    }
                    break block11;
                }
                if (routableDestinations.size() > 0) {
                    throw new HandlerException(HttpResponseStatus.METHOD_NOT_ALLOWED, request.getUri());
                }
                throw new HandlerException(HttpResponseStatus.NOT_FOUND, String.format("Problem accessing: %s. Reason: Not Found", request.getUri()));
            }
            catch (Throwable t) {
                if (t instanceof HandlerException) {
                    throw (HandlerException)t;
                }
                throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Caught exception processing request. Reason: %s", t.getMessage()), t);
            }
        }
        return null;
    }

    private PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel> getMatchedDestination(List<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>> routableDestinations, HttpMethod targetHttpMethod, String requestUri) {
        LOG.trace("Routable destinations for request {}: {}", (Object)requestUri, routableDestinations);
        Iterable requestUriParts = Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)requestUri);
        ArrayList matchedDestinations = Lists.newArrayListWithExpectedSize((int)routableDestinations.size());
        long maxScore = 0L;
        for (PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel> destination : routableDestinations) {
            HttpResourceModel resourceModel = destination.getDestination();
            for (HttpMethod httpMethod : resourceModel.getHttpMethod()) {
                if (!targetHttpMethod.equals((Object)httpMethod)) continue;
                long score = this.getWeightedMatchScore(requestUriParts, Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)resourceModel.getPath()));
                LOG.trace("Max score = {}. Weighted score for {} is {}. ", new Object[]{maxScore, destination, score});
                if (score > maxScore) {
                    maxScore = score;
                    matchedDestinations.clear();
                    matchedDestinations.add(destination);
                    continue;
                }
                if (score != maxScore) continue;
                matchedDestinations.add(destination);
            }
        }
        if (matchedDestinations.size() > 1) {
            throw new IllegalStateException(String.format("Multiple matched handlers found for request uri %s: %s", requestUri, matchedDestinations));
        }
        if (matchedDestinations.size() == 1) {
            return (PatternPathRouterWithGroups.RoutableDestination)matchedDestinations.get(0);
        }
        return null;
    }

    private long getWeightedMatchScore(Iterable<String> requestUriParts, Iterable<String> destUriParts) {
        long score = 0L;
        Iterator<String> rit = requestUriParts.iterator();
        Iterator<String> dit = destUriParts.iterator();
        while (rit.hasNext() && dit.hasNext()) {
            String destPart;
            String requestPart = rit.next();
            if (requestPart.equals(destPart = dit.next())) {
                score = score * 5L + 4L;
                continue;
            }
            if (PatternPathRouterWithGroups.GROUP_PATTERN.matcher(destPart).matches()) {
                score = score * 5L + 3L;
                continue;
            }
            score = score * 5L + 2L;
        }
        return score;
    }

    @Override
    public void init(HandlerContext context) {
        for (HttpHandler handler : this.handlers) {
            handler.init(context);
        }
    }

    @Override
    public void destroy(HandlerContext context) {
        for (HttpHandler handler : this.handlers) {
            try {
                handler.destroy(context);
            }
            catch (Throwable t) {
                LOG.warn("Exception raised in calling handler.destroy() for handler {}", (Object)handler, (Object)t);
            }
        }
    }
}

