/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import co.cask.http.ExceptionHandler;
import co.cask.http.HandlerException;
import co.cask.http.HttpHandler;
import co.cask.http.HttpMethodInfo;
import co.cask.http.HttpResponder;
import co.cask.http.ParamConvertUtils;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;

public final class HttpResourceModel {
    private static final Set<Class<? extends Annotation>> SUPPORTED_PARAM_ANNOTATIONS = ImmutableSet.of(PathParam.class, QueryParam.class, HeaderParam.class);
    private final Set<HttpMethod> httpMethods;
    private final String path;
    private final Method method;
    private final HttpHandler handler;
    private final List<Map<Class<? extends Annotation>, ParameterInfo<?>>> paramsInfo;
    private final ExceptionHandler exceptionHandler;

    public HttpResourceModel(Set<HttpMethod> httpMethods, String path, Method method, HttpHandler handler, ExceptionHandler exceptionHandler) {
        this.httpMethods = httpMethods;
        this.path = path;
        this.method = method;
        this.handler = handler;
        this.paramsInfo = this.createParametersInfos(method);
        this.exceptionHandler = exceptionHandler;
    }

    public Set<HttpMethod> getHttpMethod() {
        return this.httpMethods;
    }

    public String getPath() {
        return this.path;
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpHandler getHttpHandler() {
        return this.handler;
    }

    public HttpMethodInfo handle(HttpRequest request, HttpResponder responder, Map<String, String> groupValues) throws Exception {
        try {
            if (this.httpMethods.contains(request.getMethod())) {
                Object[] args = new Object[this.paramsInfo.size()];
                int idx = 0;
                for (Map<Class<Annotation>, ParameterInfo<?>> info : this.paramsInfo) {
                    if (info.containsKey(PathParam.class)) {
                        args[idx] = this.getPathParamValue(info, groupValues);
                    }
                    if (info.containsKey(QueryParam.class)) {
                        args[idx] = this.getQueryParamValue(info, request.getUri());
                    }
                    if (info.containsKey(HeaderParam.class)) {
                        args[idx] = this.getHeaderParamValue(info, request);
                    }
                    ++idx;
                }
                return new HttpMethodInfo(this.method, this.handler, request, responder, args, this.exceptionHandler);
            }
            throw new HandlerException(HttpResponseStatus.METHOD_NOT_ALLOWED, String.format("Problem accessing: %s. Reason: Method Not Allowed", request.getUri()));
        }
        catch (Throwable e) {
            throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Error in executing request: %s %s", request.getMethod(), request.getUri()), e);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("httpMethods", this.httpMethods).add("path", (Object)this.path).add("method", (Object)this.method).add("handler", (Object)this.handler).toString();
    }

    private Object getPathParamValue(Map<Class<? extends Annotation>, ParameterInfo<?>> annotations, Map<String, String> groupValues) {
        ParameterInfo<?> info = annotations.get(PathParam.class);
        PathParam pathParam = (PathParam)info.getAnnotation();
        String value = groupValues.get(pathParam.value());
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Could not resolve value for parameter %s", (Object[])new Object[]{pathParam.value()});
        return info.convert(value);
    }

    private Object getQueryParamValue(Map<Class<? extends Annotation>, ParameterInfo<?>> annotations, String uri) {
        ParameterInfo<?> info = annotations.get(QueryParam.class);
        QueryParam queryParam = (QueryParam)info.getAnnotation();
        List values = (List)new QueryStringDecoder(uri).getParameters().get(queryParam.value());
        return values == null ? info.convert(this.defaultValue(annotations)) : info.convert(values);
    }

    private Object getHeaderParamValue(Map<Class<? extends Annotation>, ParameterInfo<?>> annotations, HttpRequest request) {
        ParameterInfo<?> info = annotations.get(HeaderParam.class);
        HeaderParam headerParam = (HeaderParam)info.getAnnotation();
        String headerName = headerParam.value();
        List headers = request.getHeaders(headerParam.value());
        return request.containsHeader(headerName) ? info.convert(headers) : info.convert(this.defaultValue(annotations));
    }

    private List<String> defaultValue(Map<Class<? extends Annotation>, ParameterInfo<?>> annotations) {
        ImmutableList values = ImmutableList.of();
        ParameterInfo<?> defaultInfo = annotations.get(DefaultValue.class);
        if (defaultInfo != null) {
            DefaultValue defaultValue = (DefaultValue)defaultInfo.getAnnotation();
            values = ImmutableList.of((Object)defaultValue.value());
        }
        return values;
    }

    private List<Map<Class<? extends Annotation>, ParameterInfo<?>>> createParametersInfos(Method method) {
        if (method.getParameterTypes().length <= 2) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        Type[] parameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 2; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            IdentityHashMap paramAnnotations = Maps.newIdentityHashMap();
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                ParameterInfo<Object> parameterInfo = PathParam.class.isAssignableFrom(annotationType) ? ParameterInfo.create(annotation, ParamConvertUtils.createPathParamConverter(parameterTypes[i])) : (QueryParam.class.isAssignableFrom(annotationType) ? ParameterInfo.create(annotation, ParamConvertUtils.createQueryParamConverter(parameterTypes[i])) : (HeaderParam.class.isAssignableFrom(annotationType) ? ParameterInfo.create(annotation, ParamConvertUtils.createHeaderParamConverter(parameterTypes[i])) : ParameterInfo.create(annotation, null)));
                paramAnnotations.put(annotationType, parameterInfo);
            }
            if (Sets.intersection(SUPPORTED_PARAM_ANNOTATIONS, paramAnnotations.keySet()).size() != 1) {
                throw new IllegalArgumentException(String.format("Must have exactly one annotation from %s for parameter %d in method %s", SUPPORTED_PARAM_ANNOTATIONS, i, method));
            }
            result.add(Collections.unmodifiableMap(paramAnnotations));
        }
        return result.build();
    }

    private static final class ParameterInfo<T> {
        private final Annotation annotation;
        private final Function<T, Object> converter;

        static <V> ParameterInfo<V> create(Annotation annotation, @Nullable Function<V, Object> converter) {
            return new ParameterInfo<V>(annotation, converter);
        }

        private ParameterInfo(Annotation annotation, @Nullable Function<T, Object> converter) {
            this.annotation = annotation;
            this.converter = converter;
        }

        <V extends Annotation> V getAnnotation() {
            return (V)this.annotation;
        }

        Object convert(T input) {
            return this.converter == null ? null : this.converter.apply(input);
        }
    }
}

