/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import co.cask.http.AbstractHttpResponder;
import co.cask.http.BasicInternalHttpResponse;
import co.cask.http.BodyProducer;
import co.cask.http.ChunkResponder;
import co.cask.http.InternalHttpResponse;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalHttpResponder
extends AbstractHttpResponder {
    private static final Logger LOG = LoggerFactory.getLogger(InternalHttpResponder.class);
    private int statusCode = 0;
    private InputSupplier<? extends InputStream> inputSupplier;

    @Override
    public ChunkResponder sendChunkStart(HttpResponseStatus status, @Nullable Multimap<String, String> headers) {
        this.statusCode = status.getCode();
        return new ChunkResponder(){
            private ChannelBuffer contentChunks = ChannelBuffers.EMPTY_BUFFER;
            private boolean closed;

            @Override
            public void sendChunk(ByteBuffer chunk) throws IOException {
                this.sendChunk(ChannelBuffers.wrappedBuffer((ByteBuffer)chunk));
            }

            @Override
            public synchronized void sendChunk(ChannelBuffer chunk) throws IOException {
                if (this.closed) {
                    throw new IOException("ChunkResponder already closed.");
                }
                this.contentChunks = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{this.contentChunks, chunk});
            }

            @Override
            public synchronized void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                InternalHttpResponder.this.inputSupplier = InternalHttpResponder.this.createContentSupplier(this.contentChunks);
            }
        };
    }

    @Override
    public void sendContent(HttpResponseStatus status, @Nullable ChannelBuffer content, String contentType, @Nullable Multimap<String, String> headers) {
        this.statusCode = status.getCode();
        this.inputSupplier = this.createContentSupplier(content == null ? ChannelBuffers.EMPTY_BUFFER : content);
    }

    @Override
    public void sendFile(File file, @Nullable Multimap<String, String> headers) {
        this.statusCode = HttpResponseStatus.OK.getCode();
        this.inputSupplier = Files.newInputStreamSupplier((File)file);
    }

    @Override
    public void sendContent(HttpResponseStatus status, BodyProducer bodyProducer, @Nullable Multimap<String, String> headers) {
        this.statusCode = status.getCode();
        ChannelBuffer contentChunks = ChannelBuffers.EMPTY_BUFFER;
        try {
            ChannelBuffer chunk = bodyProducer.nextChunk();
            while (chunk.readable()) {
                contentChunks = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{contentChunks, chunk});
                chunk = bodyProducer.nextChunk();
            }
            bodyProducer.finished();
            this.inputSupplier = this.createContentSupplier(contentChunks);
        }
        catch (Throwable t) {
            try {
                bodyProducer.handleError(t);
            }
            catch (Throwable et) {
                LOG.warn("Exception raised from BodyProducer.handleError() for {}", (Object)bodyProducer, (Object)et);
            }
        }
    }

    public InternalHttpResponse getResponse() {
        return new BasicInternalHttpResponse(this.statusCode, this.inputSupplier);
    }

    private InputSupplier<InputStream> createContentSupplier(ChannelBuffer content) {
        final ChannelBuffer responseContent = content.duplicate();
        responseContent.markReaderIndex();
        return new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                responseContent.resetReaderIndex();
                return new ChannelBufferInputStream(responseContent);
            }
        };
    }
}

