/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import co.cask.http.BasicHandlerContext;
import co.cask.http.ExceptionHandler;
import co.cask.http.HandlerContext;
import co.cask.http.HandlerHook;
import co.cask.http.HttpDispatcher;
import co.cask.http.HttpHandler;
import co.cask.http.HttpResourceHandler;
import co.cask.http.RequestRouter;
import co.cask.http.SSLConfig;
import co.cask.http.SSLHandlerFactory;
import co.cask.http.URLRewriter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.ExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyHttpService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpService.class);
    private static final int CLOSE_CHANNEL_TIMEOUT = 5;
    private final String serviceName;
    private final int bossThreadPoolSize;
    private final int workerThreadPoolSize;
    private final int execThreadPoolSize;
    private final long execThreadKeepAliveSecs;
    private final Map<String, Object> channelConfigs;
    private final RejectedExecutionHandler rejectedExecutionHandler;
    private final HandlerContext handlerContext;
    private final ChannelGroup channelGroup;
    private final HttpResourceHandler resourceHandler;
    private final Function<ChannelPipeline, ChannelPipeline> pipelineModifier;
    private final int httpChunkLimit;
    private final SSLHandlerFactory sslHandlerFactory;
    private ServerBootstrap bootstrap;
    private ExecutionHandler executionHandler;
    private InetSocketAddress bindAddress;

    private NettyHttpService(String serviceName, InetSocketAddress bindAddress, int bossThreadPoolSize, int workerThreadPoolSize, int execThreadPoolSize, long execThreadKeepAliveSecs, Map<String, Object> channelConfigs, RejectedExecutionHandler rejectedExecutionHandler, URLRewriter urlRewriter, Iterable<? extends HttpHandler> httpHandlers, Iterable<? extends HandlerHook> handlerHooks, int httpChunkLimit, Function<ChannelPipeline, ChannelPipeline> pipelineModifier, SSLHandlerFactory sslHandlerFactory, ExceptionHandler exceptionHandler) {
        this.serviceName = serviceName;
        this.bindAddress = bindAddress;
        this.bossThreadPoolSize = bossThreadPoolSize;
        this.workerThreadPoolSize = workerThreadPoolSize;
        this.execThreadPoolSize = execThreadPoolSize;
        this.execThreadKeepAliveSecs = execThreadKeepAliveSecs;
        this.channelConfigs = ImmutableMap.copyOf(channelConfigs);
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        this.channelGroup = new DefaultChannelGroup();
        this.resourceHandler = new HttpResourceHandler(httpHandlers, handlerHooks, urlRewriter, exceptionHandler);
        this.handlerContext = new BasicHandlerContext(this.resourceHandler);
        this.httpChunkLimit = httpChunkLimit;
        this.pipelineModifier = pipelineModifier;
        this.sslHandlerFactory = sslHandlerFactory;
    }

    private boolean isSSLEnabled() {
        return this.sslHandlerFactory != null;
    }

    private ExecutionHandler createExecutionHandler(int threadPoolSize, long threadKeepAliveSecs) {
        ThreadFactory threadFactory = new ThreadFactory(){
            private final ThreadGroup threadGroup;
            private final AtomicLong count;
            {
                this.threadGroup = new ThreadGroup(NettyHttpService.this.serviceName + "-executor-thread");
                this.count = new AtomicLong(0L);
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.threadGroup, r, String.format("%s-executor-%d", NettyHttpService.this.serviceName, this.count.getAndIncrement()));
                t.setDaemon(true);
                return t;
            }
        };
        OrderedMemoryAwareThreadPoolExecutor threadPoolExecutor = new OrderedMemoryAwareThreadPoolExecutor(threadPoolSize, 0L, 0L, threadKeepAliveSecs, TimeUnit.SECONDS, threadFactory);
        threadPoolExecutor.setRejectedExecutionHandler(this.rejectedExecutionHandler);
        return new ExecutionHandler((Executor)threadPoolExecutor);
    }

    private void bootStrap(int threadPoolSize, long threadKeepAliveSecs) throws Exception {
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)ThreadNameDeterminer.CURRENT);
        this.executionHandler = threadPoolSize > 0 ? this.createExecutionHandler(threadPoolSize, threadKeepAliveSecs) : null;
        ExecutorService bossExecutor = Executors.newFixedThreadPool(this.bossThreadPoolSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.serviceName + "-boss-thread-%d").build());
        ExecutorService workerExecutor = Executors.newFixedThreadPool(this.workerThreadPoolSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.serviceName + "-worker-thread-%d").build());
        this.bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)bossExecutor, this.bossThreadPoolSize, (Executor)workerExecutor, this.workerThreadPoolSize));
        this.bootstrap.setOptions(this.channelConfigs);
        this.resourceHandler.init(this.handlerContext);
        SimpleChannelUpstreamHandler connectionTracker = new SimpleChannelUpstreamHandler(){

            public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
                NettyHttpService.this.channelGroup.add((Object)e.getChannel());
                super.handleUpstream(ctx, e);
            }
        };
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory((ChannelUpstreamHandler)connectionTracker){
            final /* synthetic */ ChannelUpstreamHandler val$connectionTracker;
            {
                this.val$connectionTracker = channelUpstreamHandler;
            }

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                if (NettyHttpService.this.isSSLEnabled()) {
                    pipeline.addLast("ssl", (ChannelHandler)NettyHttpService.this.sslHandlerFactory.create());
                }
                pipeline.addLast("tracker", (ChannelHandler)this.val$connectionTracker);
                pipeline.addLast("compressor", (ChannelHandler)new HttpContentCompressor());
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("router", (ChannelHandler)new RequestRouter(NettyHttpService.this.resourceHandler, NettyHttpService.this.httpChunkLimit, NettyHttpService.this.isSSLEnabled()));
                if (NettyHttpService.this.executionHandler != null) {
                    pipeline.addLast("executor", (ChannelHandler)NettyHttpService.this.executionHandler);
                }
                pipeline.addLast("dispatcher", (ChannelHandler)new HttpDispatcher());
                if (NettyHttpService.this.pipelineModifier != null) {
                    pipeline = (ChannelPipeline)NettyHttpService.this.pipelineModifier.apply((Object)pipeline);
                }
                return pipeline;
            }
        });
    }

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String serviceName) {
        return new Builder(serviceName);
    }

    protected void startUp() throws Exception {
        LOG.info("Starting {} http service on address {}...", (Object)this.serviceName, (Object)this.bindAddress);
        this.bootStrap(this.execThreadPoolSize, this.execThreadKeepAliveSecs);
        Channel channel = this.bootstrap.bind((SocketAddress)this.bindAddress);
        this.channelGroup.add((Object)channel);
        this.bindAddress = (InetSocketAddress)channel.getLocalAddress();
        LOG.info("Started {} http service on address {}", (Object)this.serviceName, (Object)this.bindAddress);
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() throws Exception {
        LOG.info("Stopping {} http service on address {}...", (Object)this.serviceName, (Object)this.bindAddress);
        try {
            this.bootstrap.shutdown();
            if (!this.channelGroup.close().await(5L, TimeUnit.SECONDS)) {
                LOG.warn("Timeout when closing all channels.");
            }
            this.resourceHandler.destroy(this.handlerContext);
        }
        catch (Throwable throwable) {
            this.resourceHandler.destroy(this.handlerContext);
            this.bootstrap.releaseExternalResources();
            if (this.executionHandler != null) {
                this.executionHandler.releaseExternalResources();
                ExecutorUtil.terminate((Executor[])new Executor[]{this.executionHandler.getExecutor()});
            }
            throw throwable;
        }
        this.bootstrap.releaseExternalResources();
        if (this.executionHandler != null) {
            this.executionHandler.releaseExternalResources();
            ExecutorUtil.terminate((Executor[])new Executor[]{this.executionHandler.getExecutor()});
        }
        LOG.info("Stopped {} http service on address {}", (Object)this.serviceName, (Object)this.bindAddress);
    }

    public static class Builder {
        private static final int DEFAULT_BOSS_THREAD_POOL_SIZE = 1;
        private static final int DEFAULT_WORKER_THREAD_POOL_SIZE = 10;
        private static final int DEFAULT_CONNECTION_BACKLOG = 1000;
        private static final int DEFAULT_EXEC_HANDLER_THREAD_POOL_SIZE = 60;
        private static final long DEFAULT_EXEC_HANDLER_THREAD_KEEP_ALIVE_TIME_SECS = 60L;
        private static final RejectedExecutionHandler DEFAULT_REJECTED_EXECUTION_HANDLER = new ThreadPoolExecutor.CallerRunsPolicy();
        private static final int DEFAULT_HTTP_CHUNK_LIMIT = 0x9600000;
        private final String serviceName;
        private final Map<String, Object> channelConfigs;
        private Iterable<? extends HttpHandler> handlers;
        private Iterable<? extends HandlerHook> handlerHooks = ImmutableList.of();
        private URLRewriter urlRewriter = null;
        private int bossThreadPoolSize;
        private int workerThreadPoolSize;
        private int execThreadPoolSize;
        private String host;
        private int port;
        private long execThreadKeepAliveSecs;
        private RejectedExecutionHandler rejectedExecutionHandler;
        private int httpChunkLimit;
        private SSLHandlerFactory sslHandlerFactory;
        private Function<ChannelPipeline, ChannelPipeline> pipelineModifier;
        private ExceptionHandler exceptionHandler;

        @Deprecated
        protected Builder() {
            this(Builder.getCallerClassName());
        }

        protected Builder(String serviceName) {
            this.serviceName = serviceName;
            this.bossThreadPoolSize = 1;
            this.workerThreadPoolSize = 10;
            this.execThreadPoolSize = 60;
            this.execThreadKeepAliveSecs = 60L;
            this.rejectedExecutionHandler = DEFAULT_REJECTED_EXECUTION_HANDLER;
            this.httpChunkLimit = 0x9600000;
            this.port = 0;
            this.channelConfigs = Maps.newHashMap();
            this.channelConfigs.put("backlog", 1000);
            this.sslHandlerFactory = null;
            this.exceptionHandler = new ExceptionHandler();
        }

        private static String getCallerClassName() {
            for (StackTraceElement element : Iterables.skip(Arrays.asList(Thread.currentThread().getStackTrace()), (int)1)) {
                if (element.getClassName().startsWith(NettyHttpService.class.getName())) continue;
                String className = element.getClassName();
                int idx = className.lastIndexOf(46);
                return idx > 0 ? className.substring(idx + 1) : className;
            }
            return "netty-http";
        }

        public Builder modifyChannelPipeline(Function<ChannelPipeline, ChannelPipeline> function) {
            this.pipelineModifier = function;
            return this;
        }

        public Builder addHttpHandlers(Iterable<? extends HttpHandler> handlers) {
            this.handlers = handlers;
            return this;
        }

        public Builder setHandlerHooks(Iterable<? extends HandlerHook> handlerHooks) {
            this.handlerHooks = handlerHooks;
            return this;
        }

        public Builder setUrlRewriter(URLRewriter urlRewriter) {
            this.urlRewriter = urlRewriter;
            return this;
        }

        public Builder setBossThreadPoolSize(int bossThreadPoolSize) {
            this.bossThreadPoolSize = bossThreadPoolSize;
            return this;
        }

        public Builder setWorkerThreadPoolSize(int workerThreadPoolSize) {
            this.workerThreadPoolSize = workerThreadPoolSize;
            return this;
        }

        public Builder setConnectionBacklog(int connectionBacklog) {
            this.channelConfigs.put("backlog", connectionBacklog);
            return this;
        }

        public Builder setChannelConfig(String key, Object value) {
            this.channelConfigs.put(key, value);
            return this;
        }

        public Builder setExecThreadPoolSize(int execThreadPoolSize) {
            this.execThreadPoolSize = execThreadPoolSize;
            return this;
        }

        public Builder setExecThreadKeepAliveSeconds(long threadKeepAliveSecs) {
            this.execThreadKeepAliveSecs = threadKeepAliveSecs;
            return this;
        }

        public Builder setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
            this.rejectedExecutionHandler = rejectedExecutionHandler;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setHttpChunkLimit(int value) {
            this.httpChunkLimit = value;
            return this;
        }

        public Builder enableSSL(SSLConfig sslConfig) {
            this.sslHandlerFactory = new SSLHandlerFactory(sslConfig);
            return this;
        }

        public Builder setExceptionHandler(ExceptionHandler exceptionHandler) {
            Preconditions.checkNotNull((Object)exceptionHandler, (Object)"exceptionHandler cannot be null");
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public NettyHttpService build() {
            InetSocketAddress bindAddress = this.host == null ? new InetSocketAddress("localhost", this.port) : new InetSocketAddress(this.host, this.port);
            return new NettyHttpService(this.serviceName, bindAddress, this.bossThreadPoolSize, this.workerThreadPoolSize, this.execThreadPoolSize, this.execThreadKeepAliveSecs, this.channelConfigs, this.rejectedExecutionHandler, this.urlRewriter, this.handlers, this.handlerHooks, this.httpChunkLimit, this.pipelineModifier, this.sslHandlerFactory, this.exceptionHandler);
        }
    }
}

