/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import co.cask.http.ImmutablePair;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PatternPathRouterWithGroups<T> {
    public static final Pattern GROUP_PATTERN = Pattern.compile("\\{(.*?)\\}");
    private static final Pattern WILD_CARD_PATTERN = Pattern.compile("\\*\\*");
    private final int maxPathParts;
    private final List<ImmutablePair<Pattern, RouteDestinationWithGroups>> patternRouteList;

    public static <T> PatternPathRouterWithGroups<T> create(int maxPathParts) {
        return new PatternPathRouterWithGroups<T>(maxPathParts);
    }

    public PatternPathRouterWithGroups(int maxPathParts) {
        this.maxPathParts = maxPathParts;
        this.patternRouteList = Lists.newArrayList();
    }

    public void add(String source, T destination) {
        String path = source.replaceAll("/+", "/");
        path = path.endsWith("/") && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
        String[] parts = path.split("/");
        if (parts.length - 1 > this.maxPathParts) {
            throw new IllegalArgumentException(String.format("Number of parts of path %s exceeds allowed limit %s", source, this.maxPathParts));
        }
        StringBuilder sb = new StringBuilder();
        ArrayList groupNames = Lists.newArrayList();
        for (String part : parts) {
            Matcher groupMatcher = GROUP_PATTERN.matcher(part);
            if (groupMatcher.matches()) {
                groupNames.add(groupMatcher.group(1));
                sb.append("([^/]+?)");
            } else if (WILD_CARD_PATTERN.matcher(part).matches()) {
                sb.append(".*?");
            } else {
                sb.append(part);
            }
            sb.append("/");
        }
        sb.setLength(sb.length() - 1);
        Pattern pattern = Pattern.compile(sb.toString());
        this.patternRouteList.add(ImmutablePair.of(pattern, new RouteDestinationWithGroups(destination, groupNames)));
    }

    public List<RoutableDestination<T>> getDestinations(String path) {
        String cleanPath = path.endsWith("/") && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
        ArrayList result = Lists.newArrayList();
        for (ImmutablePair<Pattern, RouteDestinationWithGroups> patternRoute : this.patternRouteList) {
            ImmutableMap.Builder groupNameValuesBuilder = ImmutableMap.builder();
            Matcher matcher = patternRoute.getFirst().matcher(cleanPath);
            if (!matcher.matches()) continue;
            int matchIndex = 1;
            for (String name : patternRoute.getSecond().getGroupNames()) {
                String value = matcher.group(matchIndex);
                groupNameValuesBuilder.put((Object)name, (Object)value);
                ++matchIndex;
            }
            result.add(new RoutableDestination(patternRoute.getSecond().getDestination(), (Map<String, String>)groupNameValuesBuilder.build()));
        }
        return result;
    }

    public static final class RoutableDestination<T> {
        private final T destination;
        private final Map<String, String> groupNameValues;

        public RoutableDestination(T destination, Map<String, String> groupNameValues) {
            this.destination = destination;
            this.groupNameValues = groupNameValues;
        }

        public T getDestination() {
            return this.destination;
        }

        public Map<String, String> getGroupNameValues() {
            return this.groupNameValues;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("destination", this.destination).add("groupNameValues", this.groupNameValues).toString();
        }
    }

    private final class RouteDestinationWithGroups {
        private final T destination;
        private final List<String> groupNames;

        public RouteDestinationWithGroups(T destination, List<String> groupNames) {
            this.destination = destination;
            this.groupNames = groupNames;
        }

        public T getDestination() {
            return this.destination;
        }

        public List<String> getGroupNames() {
            return this.groupNames;
        }
    }
}

