/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import co.cask.http.BasicHttpResponder;
import co.cask.http.HandlerException;
import co.cask.http.HttpDispatcher;
import co.cask.http.HttpMethodInfo;
import co.cask.http.HttpResourceHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestRouter
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpDispatcher.class);
    private final int chunkMemoryLimit;
    private final HttpResourceHandler httpMethodHandler;
    private final AtomicBoolean exceptionRaised;
    private final boolean enableSSL;
    private HttpMethodInfo methodInfo;

    public RequestRouter(HttpResourceHandler methodHandler, int chunkMemoryLimit, boolean enableSSL) {
        this.httpMethodHandler = methodHandler;
        this.chunkMemoryLimit = chunkMemoryLimit;
        this.exceptionRaised = new AtomicBoolean(false);
        this.enableSSL = enableSSL;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.exceptionRaised.get()) {
            return;
        }
        Object message = e.getMessage();
        if (!(message instanceof HttpRequest)) {
            super.messageReceived(ctx, e);
            return;
        }
        HttpRequest request = (HttpRequest)message;
        if (this.handleRequest(request, ctx.getChannel(), ctx)) {
            ctx.sendUpstream((ChannelEvent)e);
        }
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.enableSSL) {
            SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
            ChannelFuture handshakeFuture = sslHandler.handshake();
            handshakeFuture.addListener((ChannelFutureListener)new SSLHandshakeListener());
        }
    }

    private boolean handleRequest(HttpRequest httpRequest, Channel channel, ChannelHandlerContext ctx) throws Exception {
        this.methodInfo = this.httpMethodHandler.getDestinationMethod(httpRequest, new BasicHttpResponder(channel, HttpHeaders.isKeepAlive((HttpMessage)httpRequest)));
        if (this.methodInfo == null) {
            return false;
        }
        ctx.setAttachment((Object)this.methodInfo);
        if (this.methodInfo.isStreaming()) {
            if (channel.getPipeline().get("aggregator") != null) {
                channel.getPipeline().remove("aggregator");
            }
        } else if (channel.getPipeline().get("aggregator") == null) {
            channel.getPipeline().addAfter("router", "aggregator", (ChannelHandler)new HttpChunkAggregator(this.chunkMemoryLimit));
        }
        return true;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        String exceptionMessage = "Exception caught in channel processing.";
        Throwable cause = e.getCause();
        if (this.exceptionRaised.compareAndSet(false, true)) {
            if (this.methodInfo != null) {
                LOG.error(exceptionMessage, cause);
                this.methodInfo.sendError(HttpResponseStatus.INTERNAL_SERVER_ERROR, cause);
                this.methodInfo = null;
            } else {
                ChannelFuture future = Channels.future((Channel)ctx.getChannel());
                future.addListener(ChannelFutureListener.CLOSE);
                if (cause instanceof HandlerException) {
                    HttpResponse response = ((HandlerException)cause).createFailureResponse();
                    if (this.isUserError(response)) {
                        LOG.trace(exceptionMessage, cause);
                    } else {
                        LOG.error(exceptionMessage, cause);
                    }
                    Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)response);
                } else {
                    LOG.error(exceptionMessage, cause);
                    DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)response);
                }
            }
        } else {
            LOG.trace(exceptionMessage, cause);
        }
    }

    private boolean isUserError(HttpResponse response) {
        int code = response.getStatus().getCode();
        return code == HttpResponseStatus.BAD_REQUEST.getCode() || code == HttpResponseStatus.NOT_FOUND.getCode() || code == HttpResponseStatus.METHOD_NOT_ALLOWED.getCode();
    }

    private class SSLHandshakeListener
    implements ChannelFutureListener {
        private SSLHandshakeListener() {
        }

        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            if (!channelFuture.isSuccess()) {
                channelFuture.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }
}

