/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import java.io.File;

public class SSLConfig {
    private final File keyStore;
    private final String keyStorePassword;
    private final String certificatePassword;
    private final File trustKeyStore;
    private final String trustKeyStorePassword;

    private SSLConfig(File keyStore, String keyStorePassword, String certificatePassword, File trustKeyStore, String trustKeyStorePassword) {
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.certificatePassword = certificatePassword;
        this.trustKeyStore = trustKeyStore;
        this.trustKeyStorePassword = trustKeyStorePassword;
    }

    public File getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    public File getTrustKeyStore() {
        return this.trustKeyStore;
    }

    public String getTrustKeyStorePassword() {
        return this.trustKeyStorePassword;
    }

    public static Builder builder(File keyStore, String keyStorePassword) {
        return new Builder(keyStore, keyStorePassword);
    }

    public static class Builder {
        private final File keyStore;
        private final String keyStorePassword;
        private String certificatePassword;
        private File trustKeyStore;
        private String trustKeyStorePassword;

        private Builder(File keyStore, String keyStorePassword) {
            this.keyStore = keyStore;
            this.keyStorePassword = keyStorePassword;
        }

        public Builder setCertificatePassword(String certificatePassword) {
            this.certificatePassword = certificatePassword;
            return this;
        }

        public Builder setTrustKeyStore(File trustKeyStore) {
            this.trustKeyStore = trustKeyStore;
            return this;
        }

        public Builder setTrustKeyStorePassword(String trustKeyStorePassword) {
            if (trustKeyStorePassword == null) {
                throw new IllegalArgumentException("KeyStore Password Not Configured");
            }
            this.trustKeyStorePassword = trustKeyStorePassword;
            return this;
        }

        public SSLConfig build() {
            if (this.keyStore == null) {
                throw new IllegalArgumentException("Certificate File Not Configured");
            }
            if (this.keyStorePassword == null) {
                throw new IllegalArgumentException("KeyStore Password Not Configured");
            }
            return new SSLConfig(this.keyStore, this.keyStorePassword, this.certificatePassword, this.trustKeyStore, this.trustKeyStorePassword);
        }
    }
}

