/*
 * Decompiled with CFR 0.152.
 */
package co.cask.http;

import co.cask.http.BodyProducer;
import co.cask.http.ChunkResponder;
import co.cask.http.HandlerHook;
import co.cask.http.HandlerInfo;
import co.cask.http.HttpResponder;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WrappedHttpResponder
implements HttpResponder {
    private static final Logger LOG = LoggerFactory.getLogger(WrappedHttpResponder.class);
    private final HttpResponder delegate;
    private final Iterable<? extends HandlerHook> handlerHooks;
    private final HttpRequest httpRequest;
    private final HandlerInfo handlerInfo;

    public WrappedHttpResponder(HttpResponder delegate, Iterable<? extends HandlerHook> handlerHooks, HttpRequest httpRequest, HandlerInfo handlerInfo) {
        this.delegate = delegate;
        this.handlerHooks = handlerHooks;
        this.httpRequest = httpRequest;
        this.handlerInfo = handlerInfo;
    }

    @Override
    public void sendJson(HttpResponseStatus status, Object object) {
        this.delegate.sendJson(status, object);
        this.runHook(status);
    }

    @Override
    public void sendJson(HttpResponseStatus status, Object object, Type type) {
        this.delegate.sendJson(status, object, type);
        this.runHook(status);
    }

    @Override
    public void sendJson(HttpResponseStatus status, Object object, Type type, Gson gson) {
        this.delegate.sendJson(status, object, type, gson);
        this.runHook(status);
    }

    @Override
    public void sendString(HttpResponseStatus status, String data) {
        this.delegate.sendString(status, data);
        this.runHook(status);
    }

    @Override
    public void sendString(HttpResponseStatus status, String data, @Nullable Multimap<String, String> headers) {
        this.delegate.sendString(status, data, headers);
        this.runHook(status);
    }

    @Override
    public void sendStatus(HttpResponseStatus status) {
        this.delegate.sendStatus(status);
        this.runHook(status);
    }

    @Override
    public void sendStatus(HttpResponseStatus status, Multimap<String, String> headers) {
        this.delegate.sendStatus(status, headers);
        this.runHook(status);
    }

    @Override
    public void sendByteArray(HttpResponseStatus status, byte[] bytes, Multimap<String, String> headers) {
        this.delegate.sendByteArray(status, bytes, headers);
        this.runHook(status);
    }

    @Override
    public void sendBytes(HttpResponseStatus status, ByteBuffer buffer, Multimap<String, String> headers) {
        this.delegate.sendBytes(status, buffer, headers);
        this.runHook(status);
    }

    @Override
    public ChunkResponder sendChunkStart(final HttpResponseStatus status, Multimap<String, String> headers) {
        final ChunkResponder chunkResponder = this.delegate.sendChunkStart(status, headers);
        return new ChunkResponder(){

            @Override
            public void sendChunk(ByteBuffer chunk) throws IOException {
                chunkResponder.sendChunk(chunk);
            }

            @Override
            public void sendChunk(ChannelBuffer chunk) throws IOException {
                chunkResponder.sendChunk(chunk);
            }

            @Override
            public void close() throws IOException {
                chunkResponder.close();
                WrappedHttpResponder.this.runHook(status);
            }
        };
    }

    @Override
    public void sendContent(HttpResponseStatus status, ChannelBuffer content, String contentType, Multimap<String, String> headers) {
        this.delegate.sendContent(status, content, contentType, headers);
        this.runHook(status);
    }

    @Override
    public void sendFile(File file, Multimap<String, String> headers) {
        this.delegate.sendFile(file, headers);
        this.runHook(HttpResponseStatus.OK);
    }

    @Override
    public void sendContent(HttpResponseStatus status, BodyProducer bodyProducer, @Nullable Multimap<String, String> headers) {
        this.delegate.sendContent(status, bodyProducer, headers);
        this.runHook(status);
    }

    private void runHook(HttpResponseStatus status) {
        for (HandlerHook handlerHook : this.handlerHooks) {
            try {
                handlerHook.postCall(this.httpRequest, status, this.handlerInfo);
            }
            catch (Throwable t) {
                LOG.error("Post handler hook threw exception: ", t);
            }
        }
    }
}

