/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import java.util.Objects;

class JvmInfo {
    final String pid;
    final String packageOrPathOrJvmProperties;

    JvmInfo(String pid, String packageOrPathOrJvmProperties) {
        this.pid = pid;
        this.packageOrPathOrJvmProperties = packageOrPathOrJvmProperties;
    }

    static JvmInfo parse(String jpsLine) {
        int firstSpace = jpsLine.indexOf(32);
        return new JvmInfo(jpsLine.substring(0, firstSpace), jpsLine.substring(firstSpace + 1));
    }

    public String toString() {
        return this.pid + ' ' + this.packageOrPathOrJvmProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JvmInfo jvmInfo = (JvmInfo)o;
        return this.pid.equals(jvmInfo.pid);
    }

    public int hashCode() {
        return Objects.hash(this.pid);
    }
}

