/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl.duration;

import com.adobe.agl.impl.duration.BasicDurationFormatter;
import com.adobe.agl.impl.duration.BasicPeriodFormatterService;
import com.adobe.agl.impl.duration.DateFormatter;
import com.adobe.agl.impl.duration.DurationFormatter;
import com.adobe.agl.impl.duration.DurationFormatterFactory;
import com.adobe.agl.impl.duration.PeriodBuilder;
import com.adobe.agl.impl.duration.PeriodFormatter;
import java.util.Locale;
import java.util.TimeZone;

class BasicDurationFormatterFactory
implements DurationFormatterFactory {
    private BasicPeriodFormatterService ps;
    private PeriodFormatter formatter;
    private PeriodBuilder builder;
    private DateFormatter fallback;
    private long fallbackLimit;
    private String localeName;
    private TimeZone timeZone;
    private BasicDurationFormatter f;

    BasicDurationFormatterFactory(BasicPeriodFormatterService ps) {
        this.ps = ps;
        this.localeName = Locale.getDefault().toString();
        this.timeZone = TimeZone.getDefault();
    }

    public DurationFormatterFactory setPeriodFormatter(PeriodFormatter formatter) {
        if (formatter != this.formatter) {
            this.formatter = formatter;
            this.reset();
        }
        return this;
    }

    public DurationFormatterFactory setPeriodBuilder(PeriodBuilder builder) {
        if (builder != this.builder) {
            this.builder = builder;
            this.reset();
        }
        return this;
    }

    public DurationFormatterFactory setFallback(DateFormatter fallback) {
        boolean doReset;
        boolean bl = fallback == null ? this.fallback != null : (doReset = !fallback.equals(this.fallback));
        if (doReset) {
            this.fallback = fallback;
            this.reset();
        }
        return this;
    }

    public DurationFormatterFactory setFallbackLimit(long fallbackLimit) {
        if (fallbackLimit < 0L) {
            fallbackLimit = 0L;
        }
        if (fallbackLimit != this.fallbackLimit) {
            this.fallbackLimit = fallbackLimit;
            this.reset();
        }
        return this;
    }

    public DurationFormatterFactory setLocale(String localeName) {
        if (!localeName.equals(this.localeName)) {
            this.localeName = localeName;
            this.reset();
        }
        return this;
    }

    public DurationFormatterFactory setTimeZone(TimeZone timeZone) {
        if (!timeZone.equals(this.timeZone)) {
            this.timeZone = timeZone;
            this.reset();
        }
        return this;
    }

    public DurationFormatter getFormatter() {
        if (this.f == null) {
            if (this.fallback != null) {
                this.fallback = this.fallback.withLocale(this.localeName).withTimeZone(this.timeZone);
            }
            this.formatter = this.getPeriodFormatter().withLocale(this.localeName);
            this.builder = this.getPeriodBuilder().withLocale(this.localeName).withTimeZone(this.timeZone);
            this.f = this.createFormatter();
        }
        return this.f;
    }

    public PeriodFormatter getPeriodFormatter() {
        if (this.formatter == null) {
            this.formatter = this.ps.newPeriodFormatterFactory().getFormatter();
        }
        return this.formatter;
    }

    public PeriodBuilder getPeriodBuilder() {
        if (this.builder == null) {
            this.builder = this.ps.newPeriodBuilderFactory().getSingleUnitBuilder();
        }
        return this.builder;
    }

    public DateFormatter getFallback() {
        return this.fallback;
    }

    public long getFallbackLimit() {
        return this.fallback == null ? 0L : this.fallbackLimit;
    }

    public String getLocaleName() {
        return this.localeName;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    protected BasicDurationFormatter createFormatter() {
        return new BasicDurationFormatter(this.formatter, this.builder, this.fallback, this.fallbackLimit, this.localeName, this.timeZone);
    }

    protected void reset() {
        this.f = null;
    }
}

