/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.text;

import com.adobe.agl.impl.ICUResourceBundle;
import com.adobe.agl.text.MeasureFormat;
import com.adobe.agl.text.MessageFormat;
import com.adobe.agl.text.NumberFormat;
import com.adobe.agl.text.PluralRules;
import com.adobe.agl.util.TimeUnit;
import com.adobe.agl.util.TimeUnitAmount;
import com.adobe.agl.util.ULocale;
import com.adobe.agl.util.UResourceBundle;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;

public class TimeUnitFormat
extends MeasureFormat {
    private static final long serialVersionUID = -3707773153184971529L;
    private static final String DEFAULT_PATTERN_FOR_SECOND = "{0} s";
    private static final String DEFAULT_PATTERN_FOR_MINUTE = "{0} min";
    private static final String DEFAULT_PATTERN_FOR_HOUR = "{0} h";
    private static final String DEFAULT_PATTERN_FOR_WEEK = "{0} w";
    private static final String DEFAULT_PATTERN_FOR_DAY = "{0} d";
    private static final String DEFAULT_PATTERN_FOR_MONTH = "{0} m";
    private static final String DEFAULT_PATTERN_FOR_YEAR = "{0} y";
    private NumberFormat format;
    private ULocale locale;
    private transient Map timeUnitToCountToPatterns;
    private transient PluralRules pluralRules;
    private transient boolean isReady;

    public TimeUnitFormat() {
    }

    public TimeUnitFormat(ULocale locale) {
        this.locale = locale;
        this.isReady = false;
    }

    public TimeUnitFormat(Locale locale) {
        this.locale = ULocale.forLocale(locale);
        this.isReady = false;
    }

    public TimeUnitFormat setLocale(ULocale locale) {
        this.locale = locale;
        this.isReady = false;
        return this;
    }

    public TimeUnitFormat setLocale(Locale locale) {
        this.locale = ULocale.forLocale(locale);
        this.isReady = false;
        return this;
    }

    public TimeUnitFormat setNumberFormat(NumberFormat format) {
        if (format == null) {
            if (this.locale == null) {
                this.isReady = false;
                return this;
            }
            this.format = NumberFormat.getNumberInstance(this.locale);
        } else {
            this.format = format;
        }
        Iterator it = this.timeUnitToCountToPatterns.keySet().iterator();
        while (it.hasNext()) {
            TimeUnit timeUnit = (TimeUnit)it.next();
            Map countToPattern = (Map)this.timeUnitToCountToPatterns.get(timeUnit);
            Iterator it2 = countToPattern.keySet().iterator();
            while (it2.hasNext()) {
                String count = (String)it2.next();
                MessageFormat pattern = (MessageFormat)countToPattern.get(count);
                pattern.setFormatByArgumentIndex(0, format);
            }
        }
        return this;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (!(obj instanceof TimeUnitAmount)) {
            throw new IllegalArgumentException("can not format non TimeUnitAmount object");
        }
        if (!this.isReady) {
            this.setup();
        }
        TimeUnitAmount amount = (TimeUnitAmount)obj;
        Map countToPattern = (Map)this.timeUnitToCountToPatterns.get(amount.getTimeUnit());
        double number = amount.getNumber().doubleValue();
        String count = this.pluralRules.select(number);
        MessageFormat pattern = (MessageFormat)countToPattern.get(count);
        return pattern.format(new Object[]{amount.getNumber()}, toAppendTo, pos);
    }

    public Object parseObject(String source, ParsePosition pos) {
        if (!this.isReady) {
            this.setup();
        }
        Number resultNumber = null;
        TimeUnit resultTimeUnit = null;
        int oldPos = pos.getIndex();
        int newPos = -1;
        int longestParseDistance = 0;
        String countOfLongestMatch = null;
        Iterator it = this.timeUnitToCountToPatterns.keySet().iterator();
        while (it.hasNext()) {
            TimeUnit timeUnit = (TimeUnit)it.next();
            Map countToPattern = (Map)this.timeUnitToCountToPatterns.get(timeUnit);
            Iterator it2 = countToPattern.keySet().iterator();
            while (it2.hasNext()) {
                int parseDistance;
                String select;
                String count = (String)it2.next();
                MessageFormat pattern = (MessageFormat)countToPattern.get(count);
                pos.setErrorIndex(-1);
                pos.setIndex(oldPos);
                Object parsed = pattern.parseObject(source, pos);
                if (pos.getErrorIndex() != -1 || pos.getIndex() == oldPos) continue;
                Number temp = null;
                if (((Object[])parsed).length != 0 && !count.equals(select = this.pluralRules.select((temp = (Number)((Object[])parsed)[0]).doubleValue())) || (parseDistance = pos.getIndex() - oldPos) <= longestParseDistance) continue;
                resultNumber = temp;
                resultTimeUnit = timeUnit;
                newPos = pos.getIndex();
                longestParseDistance = parseDistance;
                countOfLongestMatch = count;
            }
        }
        if (resultNumber == null && longestParseDistance != 0) {
            resultNumber = countOfLongestMatch.equals("zero") ? new Integer(0) : (countOfLongestMatch.equals("one") ? new Integer(1) : (countOfLongestMatch.equals("two") ? new Integer(2) : new Integer(3)));
        }
        pos.setIndex(newPos);
        pos.setErrorIndex(-1);
        return new TimeUnitAmount(resultNumber, resultTimeUnit);
    }

    private void setup() {
        if (this.locale == null) {
            this.locale = this.format != null ? this.format.getLocale(null) : ULocale.getDefault();
        }
        if (this.format == null) {
            this.format = NumberFormat.getNumberInstance(this.locale);
        }
        this.pluralRules = PluralRules.forLocale(this.locale);
        this.timeUnitToCountToPatterns = new HashMap();
        try {
            ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt40b", this.locale);
            ICUResourceBundle unitsRes = resource.getWithFallback("units");
            int size = unitsRes.getSize();
            for (int index = 0; index < size; ++index) {
                String timeUnitName = unitsRes.get(index).getKey();
                ICUResourceBundle oneUnitRes = unitsRes.getWithFallback(timeUnitName);
                int count = oneUnitRes.getSize();
                TreeMap<String, MessageFormat> countToPatterns = new TreeMap<String, MessageFormat>();
                for (int pluralIndex = 0; pluralIndex < count; ++pluralIndex) {
                    String pluralCount = oneUnitRes.get(pluralIndex).getKey();
                    String pattern = oneUnitRes.get(pluralIndex).getString();
                    MessageFormat messageFormat = new MessageFormat(pattern, this.locale);
                    if (this.format != null) {
                        messageFormat.setFormatByArgumentIndex(0, this.format);
                    }
                    countToPatterns.put(pluralCount, messageFormat);
                }
                if (timeUnitName.equals("year")) {
                    this.timeUnitToCountToPatterns.put(TimeUnit.YEAR, countToPatterns);
                    continue;
                }
                if (timeUnitName.equals("month")) {
                    this.timeUnitToCountToPatterns.put(TimeUnit.MONTH, countToPatterns);
                    continue;
                }
                if (timeUnitName.equals("day")) {
                    this.timeUnitToCountToPatterns.put(TimeUnit.DAY, countToPatterns);
                    continue;
                }
                if (timeUnitName.equals("hour")) {
                    this.timeUnitToCountToPatterns.put(TimeUnit.HOUR, countToPatterns);
                    continue;
                }
                if (timeUnitName.equals("minute")) {
                    this.timeUnitToCountToPatterns.put(TimeUnit.MINUTE, countToPatterns);
                    continue;
                }
                if (timeUnitName.equals("second")) {
                    this.timeUnitToCountToPatterns.put(TimeUnit.SECOND, countToPatterns);
                    continue;
                }
                if (!timeUnitName.equals("week")) continue;
                this.timeUnitToCountToPatterns.put(TimeUnit.WEEK, countToPatterns);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        TimeUnit[] timeUnits = TimeUnit.values();
        Set keywords = this.pluralRules.getKeywords();
        for (int i = 0; i < timeUnits.length; ++i) {
            TimeUnit timeUnit = timeUnits[i];
            TreeMap countToPatterns = (TreeMap)this.timeUnitToCountToPatterns.get(timeUnit);
            boolean previousEmpty = false;
            if (countToPatterns == null) {
                countToPatterns = new TreeMap();
                previousEmpty = true;
            }
            Iterator it = keywords.iterator();
            while (it.hasNext()) {
                String pluralCount = (String)it.next();
                if (countToPatterns.containsKey(pluralCount)) continue;
                this.searchInTree(timeUnit, pluralCount, pluralCount, countToPatterns);
            }
            if (!previousEmpty) continue;
            this.timeUnitToCountToPatterns.put(timeUnit, countToPatterns);
        }
        this.isReady = true;
    }

    private void searchInTree(TimeUnit timeUnit, String srcPluralCount, String searchPluralCount, Map countToPatterns) {
        String srcTimeUnitName = timeUnit.toString();
        boolean found = false;
        try {
            for (ULocale parentLocale = this.locale; parentLocale != null; parentLocale = parentLocale.getFallback()) {
                ICUResourceBundle unitsRes = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt40b", parentLocale);
                unitsRes = unitsRes.getWithFallback("units");
                int size = unitsRes.getSize();
                block3: for (int index = 0; index < size; ++index) {
                    String timeUnitName = unitsRes.get(index).getKey();
                    if (!timeUnitName.equalsIgnoreCase(srcTimeUnitName)) continue;
                    ICUResourceBundle oneUnitRes = unitsRes.getWithFallback(timeUnitName);
                    int count = oneUnitRes.getSize();
                    for (int pluralIndex = 0; pluralIndex < count; ++pluralIndex) {
                        String pluralCount = oneUnitRes.get(pluralIndex).getKey();
                        if (!pluralCount.equals(searchPluralCount)) continue;
                        String pattern = oneUnitRes.get(pluralIndex).getString();
                        MessageFormat messageFormat = new MessageFormat(pattern, this.locale);
                        if (this.format != null) {
                            messageFormat.setFormatByArgumentIndex(0, this.format);
                        }
                        countToPatterns.put(srcPluralCount, messageFormat);
                        found = true;
                        break block3;
                    }
                    break;
                }
                if (!found) {
                    continue;
                }
                break;
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (found) {
            return;
        }
        if (searchPluralCount.equals("other")) {
            MessageFormat messageFormat = null;
            if (timeUnit == TimeUnit.SECOND) {
                messageFormat = new MessageFormat(DEFAULT_PATTERN_FOR_SECOND, this.locale);
            } else if (timeUnit == TimeUnit.MINUTE) {
                messageFormat = new MessageFormat(DEFAULT_PATTERN_FOR_MINUTE, this.locale);
            } else if (timeUnit == TimeUnit.HOUR) {
                messageFormat = new MessageFormat(DEFAULT_PATTERN_FOR_HOUR, this.locale);
            } else if (timeUnit == TimeUnit.WEEK) {
                messageFormat = new MessageFormat(DEFAULT_PATTERN_FOR_WEEK, this.locale);
            } else if (timeUnit == TimeUnit.DAY) {
                messageFormat = new MessageFormat(DEFAULT_PATTERN_FOR_DAY, this.locale);
            } else if (timeUnit == TimeUnit.MONTH) {
                messageFormat = new MessageFormat(DEFAULT_PATTERN_FOR_MONTH, this.locale);
            } else if (timeUnit == TimeUnit.YEAR) {
                messageFormat = new MessageFormat(DEFAULT_PATTERN_FOR_YEAR, this.locale);
            }
            if (this.format != null && messageFormat != null) {
                messageFormat.setFormatByArgumentIndex(0, this.format);
            }
            countToPatterns.put(srcPluralCount, messageFormat);
        } else {
            this.searchInTree(timeUnit, srcPluralCount, "other", countToPatterns);
        }
    }
}

