/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DMessageCache;
import flash.tools.debugger.concrete.DMessageCounter;
import flash.tools.debugger.concrete.DProtocolNotifierIF;
import flash.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.EnumMap;

public class DProtocol
implements Runnable {
    public static final int DEBUG_PORT = 7935;
    private final BufferedInputStream m_in;
    private final BufferedOutputStream m_out;
    private final EnumMap<ListenerIndex, DProtocolNotifierIF> m_listeners;
    private long m_msgRx;
    private long m_msgTx;
    private volatile boolean m_stopRx;
    private volatile Thread m_rxThread;

    public DProtocol(BufferedInputStream in, BufferedOutputStream out) {
        this.m_in = in;
        this.m_out = out;
        this.m_listeners = new EnumMap(ListenerIndex.class);
        this.m_msgRx = 0L;
        this.m_msgTx = 0L;
        this.m_stopRx = false;
        this.m_rxThread = null;
        this.addListener(ListenerIndex.MessageCounter, new DMessageCounter());
    }

    static DProtocol createFromSocket(Socket s) throws IOException {
        s.setTcpNoDelay(true);
        BufferedInputStream in = new BufferedInputStream(s.getInputStream());
        BufferedOutputStream out = new BufferedOutputStream(s.getOutputStream());
        DProtocol dp = new DProtocol(in, out);
        return dp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(ListenerIndex index, DProtocolNotifierIF n) {
        EnumMap<ListenerIndex, DProtocolNotifierIF> enumMap = this.m_listeners;
        synchronized (enumMap) {
            this.m_listeners.put(index, n);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long messagesReceived() {
        DProtocol dProtocol = this;
        synchronized (dProtocol) {
            return this.m_msgRx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long messagesSent() {
        DProtocol dProtocol = this;
        synchronized (dProtocol) {
            return this.m_msgTx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DProtocolNotifierIF[] listeners;
        block8: {
            try {
                this.m_stopRx = false;
                this.listenForMessages();
            }
            catch (Exception ex) {
                if (!Trace.error || ex instanceof SocketException && ex.getMessage().equalsIgnoreCase("socket closed")) break block8;
                ex.printStackTrace();
            }
        }
        EnumMap<ListenerIndex, DProtocolNotifierIF> enumMap = this.m_listeners;
        synchronized (enumMap) {
            listeners = this.m_listeners.values().toArray(new DProtocolNotifierIF[this.m_listeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            DProtocolNotifierIF elem = listeners[i];
            try {
                elem.disconnected();
                continue;
            }
            catch (Exception exc) {
                if (!Trace.error) continue;
                exc.printStackTrace();
            }
        }
        this.m_rxThread = null;
    }

    public boolean bind() {
        boolean worked = true;
        if (this.m_rxThread == null) {
            this.getMessageCounter().clearInCounts();
            this.getMessageCounter().clearOutCounts();
            this.m_rxThread = new Thread((Runnable)this, "DJAPI message listener");
            this.m_rxThread.setDaemon(true);
            this.m_rxThread.start();
        } else {
            worked = false;
        }
        return worked;
    }

    public boolean unbind() {
        boolean worked = true;
        if (this.m_rxThread == null) {
            worked = false;
        } else {
            this.m_stopRx = true;
        }
        return worked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listenForMessages() throws IOException {
        DProtocolNotifierIF[] listeners = new DProtocolNotifierIF[]{};
        while (!this.m_stopRx) {
            try {
                DMessage msg = this.rxMessage();
                EnumMap<ListenerIndex, DProtocolNotifierIF> enumMap = this.m_listeners;
                synchronized (enumMap) {
                    listeners = this.m_listeners.values().toArray(listeners);
                }
                for (int i = 0; i < listeners.length; ++i) {
                    block9: {
                        DProtocolNotifierIF elem = listeners[i];
                        try {
                            elem.messageArrived(msg, this);
                        }
                        catch (Exception exc) {
                            if (!Trace.error) break block9;
                            System.err.println("Error in listener parsing incoming message :");
                            System.err.println(msg.inToString(16));
                            exc.printStackTrace();
                        }
                    }
                    msg.reset();
                }
                DMessageCache.free(msg);
            }
            catch (InterruptedIOException interruptedIOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void txMessage(DMessage message) throws IOException {
        int size = message.getSize();
        int command = message.getType();
        this.writeDWord(size);
        this.writeDWord(command);
        this.writeData(message.getData(), size);
        this.m_out.flush();
        DProtocol dProtocol = this;
        synchronized (dProtocol) {
            ++this.m_msgTx;
        }
        this.getMessageCounter().messageSent(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DMessage rxMessage() throws IOException {
        int size = (int)this.readDWord();
        int command = (int)this.readDWord();
        if (size < 0) {
            throw new IOException("socket closed");
        }
        DMessage message = DMessageCache.alloc(size);
        byte[] messageContent = message.getData();
        for (int offset = 0; offset < size; offset += this.m_in.read(messageContent, offset, size - offset)) {
        }
        message.setType(command);
        DProtocol dProtocol = this;
        synchronized (dProtocol) {
            ++this.m_msgRx;
        }
        return message;
    }

    void writeDWord(long dw) throws IOException {
        byte b0 = (byte)(dw & 0xFFL);
        byte b1 = (byte)(dw >> 8 & 0xFFL);
        byte b2 = (byte)(dw >> 16 & 0xFFL);
        byte b3 = (byte)(dw >> 24 & 0xFFL);
        this.m_out.write(b0);
        this.m_out.write(b1);
        this.m_out.write(b2);
        this.m_out.write(b3);
    }

    void writeData(byte[] data, long size) throws IOException {
        if (size > 0L) {
            this.m_out.write(data, 0, (int)size);
        }
    }

    long readDWord() throws IOException {
        int b0 = this.m_in.read();
        int b1 = this.m_in.read();
        int b2 = this.m_in.read();
        int b3 = this.m_in.read();
        long value = b3 << 24 & 0xFF000000 | b2 << 16 & 0xFF0000 | b1 << 8 & 0xFF00 | b0 & 0xFF;
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMessageCounter getMessageCounter() {
        EnumMap<ListenerIndex, DProtocolNotifierIF> enumMap = this.m_listeners;
        synchronized (enumMap) {
            return (DMessageCounter)this.m_listeners.get((Object)ListenerIndex.MessageCounter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ListenerIndex {
        PlayerSession,
        MessageCounter;

    }
}

