/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.threadsafe;

import flash.tools.debugger.Frame;
import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSupportedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceLocator;
import flash.tools.debugger.SuspendedException;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.VersionException;
import flash.tools.debugger.Watch;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.expression.PlayerFaultException;
import flash.tools.debugger.threadsafe.ThreadSafeDebuggerObject;
import flash.tools.debugger.threadsafe.ThreadSafeFrame;
import flash.tools.debugger.threadsafe.ThreadSafeLocation;
import flash.tools.debugger.threadsafe.ThreadSafeSourceLocator;
import flash.tools.debugger.threadsafe.ThreadSafeSwfInfo;
import flash.tools.debugger.threadsafe.ThreadSafeValue;
import flash.tools.debugger.threadsafe.ThreadSafeVariable;
import flash.tools.debugger.threadsafe.ThreadSafeWatch;

public class ThreadSafeSession
extends ThreadSafeDebuggerObject
implements Session {
    private Session fSession;

    private ThreadSafeSession(Object syncObj, Session session) {
        super(syncObj);
        this.fSession = session;
    }

    public static ThreadSafeSession wrap(Object syncObj, Session session) {
        if (session != null) {
            return new ThreadSafeSession(syncObj, session);
        }
        return null;
    }

    public static Session getRaw(Session s) {
        if (s instanceof ThreadSafeSession) {
            return ((ThreadSafeSession)s).fSession;
        }
        return s;
    }

    public static Object getSyncObject(Session s) {
        return ((ThreadSafeSession)s).getSyncObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind() throws VersionException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fSession.bind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location clearBreakpoint(Location location) throws NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeLocation.wrap(this.getSyncObject(), this.fSession.clearBreakpoint(ThreadSafeLocation.getRaw(location)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Watch clearWatch(Watch watch) throws NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeWatch.wrap(this.getSyncObject(), this.fSession.clearWatch(ThreadSafeWatch.getRaw(watch)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location[] getBreakpointList() throws NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeLocation.wrapArray(this.getSyncObject(), this.fSession.getBreakpointList());
        }
    }

    public int getEventCount() {
        return this.fSession.getEventCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame[] getFrames() throws NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeFrame.wrapArray(this.getSyncObject(), this.fSession.getFrames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process getLaunchProcess() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fSession.getLaunchProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreference(String pref) throws NullPointerException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fSession.getPreference(pref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwfInfo[] getSwfs() throws NoResponseException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeSwfInfo.wrapArray(this.getSyncObject(), this.fSession.getSwfs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURI() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fSession.getURI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getValue(long valueId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeValue.wrap(this.getSyncObject(), this.fSession.getValue(valueId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable[] getVariableList() throws NotSuspendedException, NoResponseException, NotConnectedException, VersionException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeVariable.wrapArray(this.getSyncObject(), this.fSession.getVariableList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Watch[] getWatchList() throws NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeWatch.wrapArray(this.getSyncObject(), this.fSession.getWatchList());
        }
    }

    public boolean isConnected() {
        return this.fSession.isConnected();
    }

    public boolean isSuspended() throws NotConnectedException {
        return this.fSession.isSuspended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugEvent nextEvent() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fSession.nextEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws NotSuspendedException, NotConnectedException, NoResponseException {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fSession.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location setBreakpoint(int fileId, int lineNum) throws NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeLocation.wrap(this.getSyncObject(), this.fSession.setBreakpoint(fileId, lineNum));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreference(String pref, int value) {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fSession.setPreference(pref, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Watch setWatch(Value v, String memberName, int kind) throws NoResponseException, NotConnectedException, NotSupportedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeWatch.wrap(this.getSyncObject(), this.fSession.setWatch(ThreadSafeValue.getRaw(v), memberName, kind));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Watch setWatch(Watch watch) throws NoResponseException, NotConnectedException, NotSupportedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeWatch.wrap(this.getSyncObject(), this.fSession.setWatch(ThreadSafeWatch.getRaw(watch)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepContinue() throws NotSuspendedException, NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fSession.stepContinue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepInto() throws NotSuspendedException, NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fSession.stepInto();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepOut() throws NotSuspendedException, NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fSession.stepOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepOver() throws NotSuspendedException, NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fSession.stepOver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws SuspendedException, NotConnectedException, NoResponseException {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fSession.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int suspendReason() throws NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fSession.suspendReason();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fSession.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fSession.unbind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEvent() throws NotConnectedException, InterruptedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fSession.waitForEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceLocator getSourceLocator() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeSourceLocator.wrap(this.getSyncObject(), this.fSession.getSourceLocator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceLocator(SourceLocator sourceLocator) {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fSession.setSourceLocator(sourceLocator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callConstructor(String classname, Value[] args) throws PlayerDebugException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeValue.wrap(this.getSyncObject(), this.fSession.callConstructor(classname, args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callFunction(Value thisObject, String functionName, Value[] args) throws PlayerDebugException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeValue.wrap(this.getSyncObject(), this.fSession.callFunction(thisObject, functionName, args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getGlobal(String name) throws NotSuspendedException, NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeValue.wrap(this.getSyncObject(), this.fSession.getGlobal(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakOnCaughtExceptions(boolean b) throws NotSupportedException, NoResponseException {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fSession.breakOnCaughtExceptions(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evalIs(Value value, Value type) throws PlayerDebugException, PlayerFaultException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fSession.evalIs(value, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evalIs(Value value, String type) throws PlayerDebugException, PlayerFaultException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fSession.evalIs(value, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evalInstanceof(Value value, Value type) throws PlayerDebugException, PlayerFaultException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fSession.evalInstanceof(value, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evalInstanceof(Value value, String type) throws PlayerDebugException, PlayerFaultException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fSession.evalInstanceof(value, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evalIn(Value property, Value object) throws PlayerDebugException, PlayerFaultException {
        Object object2 = this.getSyncObject();
        synchronized (object2) {
            return this.fSession.evalIn(property, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evalAs(Value value, Value type) throws PlayerDebugException, PlayerFaultException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeValue.wrap(this.getSyncObject(), this.fSession.evalAs(value, type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsWatchpoints() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fSession.supportsWatchpoints();
        }
    }
}

