/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.FXGVersion;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.AbstractFXGNode;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.DefinitionNode;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.GroupNode;
import com.adobe.internal.fxg.dom.LibraryNode;
import com.adobe.internal.fxg.dom.MaskPropertyNode;
import com.adobe.internal.fxg.dom.MaskableNode;
import com.adobe.internal.fxg.dom.MaskingNode;
import com.adobe.internal.fxg.dom.PlaceObjectNode;
import com.adobe.internal.fxg.dom.types.MaskType;
import com.adobe.internal.fxg.dom.types.ScalingGrid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicNode
extends AbstractFXGNode
implements MaskableNode {
    private FXGVersion compilerVersion = null;
    private String profile;
    private String documentName = null;
    private FXGVersion version = null;
    public Map<String, Class<? extends FXGNode>> reservedNodes;
    public double scaleGridLeft = 0.0;
    public double scaleGridTop = 0.0;
    public double scaleGridRight = 0.0;
    public double scaleGridBottom = 0.0;
    public double viewWidth = Double.NaN;
    public double viewHeight = Double.NaN;
    public MaskType maskType = MaskType.CLIP;
    protected boolean luminosityInvert = false;
    protected boolean luminosityClip = false;
    private boolean isVersionGreaterThanCompiler = false;
    public List<GraphicContentNode> children;
    public LibraryNode library;
    public MaskingNode mask;
    private boolean definesScaleGrid;

    @Override
    public FXGVersion getCompilerVersion() {
        return this.compilerVersion;
    }

    public void setCompilerVersion(FXGVersion version) {
        this.compilerVersion = version;
    }

    @Override
    public boolean isForMobile() {
        return this.profile.equals("mobile");
    }

    @Override
    public boolean isVersionGreaterThanCompiler() {
        return this.isVersionGreaterThanCompiler;
    }

    public void setVersionGreaterThanCompiler(boolean versionGreaterThanCompiler) {
        this.isVersionGreaterThanCompiler = versionGreaterThanCompiler;
    }

    @Override
    public String getDocumentName() {
        return this.documentName;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public FXGVersion getVersion() {
        return this.version;
    }

    public void setReservedNodes(Map<String, Class<? extends FXGNode>> reservedNodes) {
        this.reservedNodes = reservedNodes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addChild(FXGNode child) {
        if (child instanceof MaskPropertyNode) {
            if (this.children != null) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidMaskElement", new Object[0]);
            }
            if (this.mask != null) throw new FXGException(child.getStartLine(), child.getStartColumn(), "MultipleMaskElements", new Object[0]);
            this.mask = ((MaskPropertyNode)child).mask;
            return;
        } else if (child instanceof LibraryNode) {
            if (this.mask != null || this.children != null) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidLibraryElement", new Object[0]);
            }
            if (this.library != null) throw new FXGException(child.getStartLine(), child.getStartColumn(), "MultipleLibraryElements", new Object[0]);
            this.library = (LibraryNode)child;
            return;
        } else if (child instanceof GraphicContentNode) {
            if (this.children == null) {
                this.children = new ArrayList<GraphicContentNode>();
            }
            if (child instanceof GroupNode) {
                GroupNode group = (GroupNode)child;
                if (this.definesScaleGrid) {
                    group.setInsideScaleGrid(true);
                }
            }
            this.children.add((GraphicContentNode)child);
            return;
        } else {
            super.addChild(child);
        }
    }

    @Override
    public String getNodeName() {
        return "Graphic";
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("scaleGridLeft".equals(name)) {
            this.scaleGridLeft = DOMParserHelper.parseDouble(this, value, name);
            this.definesScaleGrid = true;
        } else if ("scaleGridTop".equals(name)) {
            this.scaleGridTop = DOMParserHelper.parseDouble(this, value, name);
            this.definesScaleGrid = true;
        } else if ("scaleGridRight".equals(name)) {
            this.scaleGridRight = DOMParserHelper.parseDouble(this, value, name);
            this.definesScaleGrid = true;
        } else if ("scaleGridBottom".equals(name)) {
            this.scaleGridBottom = DOMParserHelper.parseDouble(this, value, name);
            this.definesScaleGrid = true;
        } else if ("viewWidth".equals(name)) {
            this.viewWidth = DOMParserHelper.parseDouble(this, value, name);
        } else if ("viewHeight".equals(name)) {
            this.viewHeight = DOMParserHelper.parseDouble(this, value, name);
        } else if ("version".equals(name)) {
            try {
                this.version = FXGVersion.newInstance(DOMParserHelper.parseDouble(this, value, name));
            }
            catch (FXGException e) {
                throw new FXGException("InvalidVersionNumber", (Throwable)e, new Object[0]);
            }
        } else if ("maskType".equals(name)) {
            this.maskType = DOMParserHelper.parseMaskType(this, value, name, this.maskType);
        } else {
            if (this.version != null && this.version.equalTo(FXGVersion.v1_0)) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidNodeAttribute", name, this.getNodeName());
            }
            if ("luminosityInvert".equals(name)) {
                this.luminosityInvert = DOMParserHelper.parseBoolean(this, value, name);
            } else if ("luminosityClip".equals(name)) {
                this.luminosityClip = DOMParserHelper.parseBoolean(this, value, name);
            } else {
                super.setAttribute(name, value);
            }
        }
    }

    @Override
    public MaskingNode getMask() {
        return this.mask;
    }

    @Override
    public MaskType getMaskType() {
        return this.maskType;
    }

    @Override
    public boolean getLuminosityClip() {
        return this.luminosityClip;
    }

    @Override
    public boolean getLuminosityInvert() {
        return this.luminosityInvert;
    }

    public PlaceObjectNode getDefinitionInstance(String name) {
        DefinitionNode definition;
        PlaceObjectNode instance = null;
        if (this.library != null && (definition = this.library.getDefinition(name)) != null) {
            instance = new PlaceObjectNode();
            instance.definition = definition;
        }
        return instance;
    }

    public ScalingGrid getScalingGrid() {
        ScalingGrid scalingGrid = null;
        if (this.definesScaleGrid()) {
            scalingGrid = new ScalingGrid();
            scalingGrid.scaleGridLeft = this.scaleGridLeft;
            scalingGrid.scaleGridTop = this.scaleGridTop;
            scalingGrid.scaleGridRight = this.scaleGridRight;
            scalingGrid.scaleGridBottom = this.scaleGridBottom;
        }
        return scalingGrid;
    }

    public boolean definesScaleGrid() {
        return this.definesScaleGrid;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getProfile() {
        return this.profile;
    }
}

