/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerException;
import flex2.compiler.Source;
import flex2.compiler.SourcePathBase;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.ResourceFile;
import flex2.compiler.io.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ResourceBundlePath
extends SourcePathBase {
    private String[] locales;
    private Map rbDirectories = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ResourceBundlePath(CompilerConfiguration config, VirtualFile appPath) {
        super(I18nUtils.getTranslationFormat(config).getSupportedMimeTypes(), true);
        int size;
        this.locales = config.getLocales();
        int n = size = this.locales == null ? 0 : this.locales.length;
        for (int i = 0; i < size; ++i) {
            VirtualFile[] classPath = config.getResourceBundlePathForLocale(this.locales[i]);
            LinkedList directories = new LinkedList();
            ResourceBundlePath.addApplicationParentToSourcePath(appPath, classPath, directories);
            ResourceBundlePath.addPathElements(classPath, directories, this.allowSourcePathOverlap, this.warnings);
            this.rbDirectories.put(this.locales[i], directories);
        }
    }

    private Source newSource(String name, VirtualFile[] files, VirtualFile[] pathRoots, File pathRoot, String namespaceURI, String localPart) {
        return new Source(new ResourceFile(name, this.locales, files, pathRoots), new LocalFile(pathRoot), namespaceURI.replace('.', '/'), localPart, this, false, false, false);
    }

    boolean checkPreference(Source s) {
        int length;
        if (!$assertionsDisabled && s.getOwner() != this) {
            throw new AssertionError();
        }
        String relativePath = s.getRelativePath();
        String p = relativePath.length() == 0 ? s.getShortName() : (relativePath + "/" + s.getShortName()).replace('/', File.separatorChar);
        ResourceFile rf = (ResourceFile)s.getBackingFile();
        int n = length = this.locales == null ? 0 : this.locales.length;
        block2: for (int i = 0; i < length; ++i) {
            int size;
            rf.setLocale(this.locales[i]);
            VirtualFile resourceFile = rf.getResourceFile();
            List directories = (List)this.rbDirectories.get(this.locales[i]);
            int n2 = size = directories == null ? 0 : directories.size();
            for (int j = 0; j < size; ++j) {
                File d = (File)directories.get(j);
                try {
                    File f = this.findFile(d, p, this.mimeTypes);
                    if (f == null) continue;
                    if (resourceFile.getName().equals(FileUtil.getCanonicalPath(f))) continue block2;
                    this.removeSource(s);
                    return false;
                }
                catch (CompilerException ex) {
                    this.removeSource(s);
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean adjustDefinitionName(String namespaceURI, String localPart, Source s, CompilationUnit u) {
        return false;
    }

    protected Source findFile(String className, String namespaceURI, String localPart) throws CompilerException {
        int length;
        String p = className.replace(':', '.').replace('.', File.separatorChar);
        VirtualFile[] files = null;
        VirtualFile[] pathRoots = null;
        File pathRoot = null;
        String name = null;
        Source s = null;
        int n = length = this.locales == null ? 0 : this.locales.length;
        block0: for (int i = 0; i < length; ++i) {
            int size;
            List directories = (List)this.rbDirectories.get(this.locales[i]);
            int n2 = size = directories == null ? 0 : directories.size();
            for (int j = 0; j < size; ++j) {
                File d = (File)directories.get(j);
                File f = this.findFile(d, p, this.mimeTypes);
                if (f == null) continue;
                if (files == null) {
                    files = new VirtualFile[length];
                }
                if (pathRoots == null) {
                    pathRoots = new VirtualFile[length];
                }
                if (name == null) {
                    pathRoot = d;
                    name = FileUtil.getCanonicalPath(f);
                }
                files[i] = new LocalFile(f);
                pathRoots[i] = new LocalFile(d);
                continue block0;
            }
        }
        if (files != null) {
            s = this.newSource(name, files, pathRoots, pathRoot, namespaceURI, localPart);
            this.sources.put(className, s);
        }
        return s;
    }

    String[] getLocales() {
        return this.locales;
    }

    Map getResourceBundlePaths() {
        return this.rbDirectories;
    }

    public VirtualFile[] findVirtualFiles(String rbName) {
        int length;
        String p = rbName.replace(':', '.').replace('.', File.separatorChar);
        VirtualFile[] files = null;
        int n = length = this.locales == null ? 0 : this.locales.length;
        block2: for (int i = 0; i < length; ++i) {
            int size;
            List directories = (List)this.rbDirectories.get(this.locales[i]);
            int n2 = size = directories == null ? 0 : directories.size();
            for (int j = 0; j < size; ++j) {
                File d = (File)directories.get(j);
                try {
                    File f = this.findFile(d, p, this.mimeTypes);
                    if (f == null) continue;
                    if (files == null) {
                        files = new VirtualFile[length];
                    }
                    files[i] = new LocalFile(f);
                    continue block2;
                }
                catch (CompilerException ex) {
                    // empty catch block
                }
            }
        }
        return files;
    }

    static {
        $assertionsDisabled = !ResourceBundlePath.class.desiredAssertionStatus();
    }
}

