/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flash.swf.tools.as3.EvaluatorAdapter;
import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.as3.EmbedUtil;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

class EmbedEvaluator
extends EvaluatorAdapter {
    private CompilationUnit unit;
    private String generatedOutputDir;
    private boolean checkDeprecation;
    private Transcoder[] transcoders;
    private Stack embedDataStack;
    private Set evaluatedClasses;
    private SymbolTable symbolTable;

    EmbedEvaluator(CompilationUnit unit, SymbolTable symbolTable, Transcoder[] transcoders, String generatedOutputDir, boolean checkDeprecation) {
        this.unit = unit;
        this.symbolTable = symbolTable;
        this.generatedOutputDir = generatedOutputDir;
        this.transcoders = transcoders;
        this.checkDeprecation = checkDeprecation;
        this.embedDataStack = new Stack();
        this.evaluatedClasses = new HashSet();
    }

    private EmbedData getEmbedData() {
        EmbedData embedData = null;
        if (this.embedDataStack.size() != 0) {
            embedData = (EmbedData)this.embedDataStack.peek();
        }
        return embedData;
    }

    public Value evaluate(Context context, ClassDefinitionNode node) {
        if (!this.evaluatedClasses.contains(node)) {
            this.evaluatedClasses.add(node);
            String packageName = NodeMagic.getPackageName(node);
            String className = node.name.name;
            EmbedData embedData = this.getEmbedData();
            if (embedData == null || embedData.inUse) {
                embedData = new EmbedData();
                this.embedDataStack.push(embedData);
            }
            embedData.inUse = true;
            embedData.referenceClassName = className;
            if (node.statements != null) {
                node.statements.evaluate(context, (Evaluator)this);
            }
            if (embedData.hasData()) {
                this.unit.addGeneratedSources(this.generateSources(packageName, context, (Node)node));
                embedData.clear();
            }
            if (this.embedDataStack.size() > 0) {
                this.embedDataStack.pop();
            }
            embedData.inUse = false;
        }
        return null;
    }

    public Value evaluate(Context context, MetaDataNode node) {
        DefinitionNode def = node.def;
        if ("Embed".equals(node.id)) {
            if (def instanceof VariableDefinitionNode) {
                Object item;
                VariableDefinitionNode variableDefinition = (VariableDefinitionNode)def;
                if (variableDefinition.list != null && variableDefinition.list.items != null && variableDefinition.list.items.size() > 0 && (item = variableDefinition.list.items.get(0)) instanceof VariableBindingNode) {
                    VariableBindingNode variableBinding = (VariableBindingNode)item;
                    if (variableBinding.initializer == null) {
                        EmbedData embedData = this.getEmbedData();
                        if (embedData == null) {
                            context.localizedError2(node.pos(), (Object)new EmbedOnlyOnClassesAndVars());
                            return null;
                        }
                        String name = variableBinding.variable.identifier.name;
                        String className = embedData.referenceClassName + "_" + name;
                        this.unit.expressions.add(new MultiName(NameFormatter.toColon(className)));
                        Map values = this.getMetaDataValues(node, context);
                        if (!values.containsKey("_file")) {
                            if (context.input.origin.indexOf(92) != -1) {
                                values.put("_file", context.input.origin.replace('\\', '/'));
                                values.put("_pathsep", "true");
                            } else {
                                values.put("_file", context.input.origin);
                            }
                            values.put("_line", new Integer(context.input.getLnNum(node.pos())).toString());
                            values.put("_column", new Integer(context.input.getColPos(node.pos())).toString());
                        }
                        this.getEmbedData().class2params.put(className, values);
                        String type = NodeMagic.lookupType(variableBinding);
                        boolean correctType = false;
                        if (type != null) {
                            if (type.equals("Class")) {
                                correctType = true;
                                variableBinding.initializer = this.generateClassInitializer(className);
                            } else if (type.equals("String")) {
                                correctType = true;
                                variableBinding.initializer = this.generateStringInitializer(className);
                            }
                        }
                        if (!correctType) {
                            context.localizedError2(node.pos(), (Object)new UnsupportedTypeForEmbed());
                        }
                    } else {
                        context.localizedError2(node.pos(), (Object)new InvalidEmbedVariable());
                    }
                }
            } else if (def instanceof ClassDefinitionNode) {
                Transcoder.TranscodingResults asset;
                ClassDefinitionNode cdn = (ClassDefinitionNode)def;
                String pkg = NodeMagic.getPackageName(cdn);
                String cls = pkg == null || pkg.length() == 0 ? cdn.name.name : pkg + "." + cdn.name.name;
                Map values = this.getMetaDataValues(node, context);
                if (!values.containsKey("_file")) {
                    if (context.input.origin.indexOf(92) != -1) {
                        values.put("_file", context.input.origin.replace('\\', '/'));
                        values.put("_pathsep", "true");
                    } else {
                        values.put("_file", context.input.origin);
                    }
                    values.put("_line", new Integer(context.input.getLnNum(node.pos())));
                    values.put("_column", new Integer(context.input.getColPos(node.pos())));
                }
                if ((asset = EmbedUtil.transcode(this.transcoders, this.unit, this.symbolTable, cls, values, context.input.getLnNum(node.pos()), context.input.getColPos(node.pos()), false)) == null && values.containsKey("source")) {
                    context.localizedError2(node.pos(), (Object)new UnableToTranscode(values.get("source")));
                }
            } else {
                context.localizedError2(node.pos(), (Object)new EmbedOnlyOnClassesAndVars());
            }
        }
        return null;
    }

    private Map getMetaDataValues(MetaDataNode node, Context context) {
        MetaData metaData = new MetaData(node);
        int len = metaData.count();
        HashMap<String, String> values = new HashMap<String, String>();
        for (int i = 0; i < len; ++i) {
            String key = metaData.getKey(i);
            String value = metaData.getValue(i);
            if (key == null || key.equals("source")) {
                int octothorpe = value.indexOf("#");
                if (octothorpe != -1) {
                    values.put("source", value.substring(0, octothorpe));
                    values.put("symbol", value.substring(octothorpe + 1));
                    continue;
                }
                values.put("source", value);
                continue;
            }
            values.put(key, value);
        }
        if (this.checkDeprecation && (values.containsKey("flashType") || values.containsKey("flash-type"))) {
            String deprecated = values.containsKey("flashType") ? "flashType" : "flash-type";
            String replacement = values.containsKey("flashType") ? "advancedAntiAliasing" : "advanced-anti-aliasing";
            context.localizedError2(node.pos(), (Object)new DeprecatedAttribute(deprecated, replacement, "3.0"));
        }
        return values;
    }

    public Value evaluate(Context context, ProgramNode node) {
        this.embedDataStack = new Stack();
        super.evaluate(context, node);
        this.embedDataStack = null;
        return null;
    }

    private Source generateSource(String packageName, String className, Map embedMap, Context cx, Node node) {
        Source result;
        block11: {
            String pathSep;
            result = null;
            int line = embedMap.containsKey("_line") ? Integer.parseInt(embedMap.get("_line").toString()) : -1;
            int col = embedMap.containsKey("_column") ? Integer.parseInt(embedMap.get("_column").toString()) : -1;
            String path = embedMap.containsKey("_file") ? (String)embedMap.get("_file") : "";
            String string = pathSep = embedMap.containsKey("_pathsep") ? (String)embedMap.get("_pathsep") : null;
            if ("true".equals(pathSep)) {
                path = path.replace('/', '\\');
            }
            String packagePrefix = packageName == null || packageName.equals("") ? "" : packageName + ".";
            String nameForReporting = path != null ? path : this.unit.getSource().getNameForReporting();
            try {
                Transcoder.TranscodingResults asset = EmbedUtil.transcode(this.transcoders, this.unit, this.symbolTable, packagePrefix + className, embedMap, line, col, true);
                if (asset != null) {
                    String generatedName = (packagePrefix + className).replace('.', File.separatorChar) + ".as";
                    if (this.generatedOutputDir != null) {
                        try {
                            FileUtils.writeClassToFile((String)this.generatedOutputDir, (String)packagePrefix, (String)(className + ".as"), (String)asset.generatedCode);
                        }
                        catch (IOException ioe) {
                            if (Trace.error) {
                                ioe.printStackTrace();
                            }
                            cx.localizedError(nameForReporting, line, col, ioe.getLocalizedMessage(), "");
                        }
                    }
                    String relative = "";
                    if (packageName != null) {
                        relative = packageName.replace('.', '/');
                    }
                    result = new Source((VirtualFile)new TextFile(asset.generatedCode, generatedName, null, "text/as", asset.assetSource != null ? asset.assetSource.getLastModified() : -1L), relative, className, null, false, false, false);
                    result.setAssetInfo(this.unit.getAssets().get(className));
                    result.setPathResolver(this.unit.getSource().getPathResolver());
                    break block11;
                }
                if (embedMap.containsKey("source")) {
                    Object what = embedMap.get("source");
                    cx.localizedError2(nameForReporting, line, col, (Object)new UnableToTranscode(what), "");
                }
            }
            catch (Exception e) {
                if (Trace.error) {
                    e.printStackTrace();
                }
                cx.localizedError2(nameForReporting, line, col, (Object)new UnableToCreateSource(packagePrefix + className), null);
            }
        }
        return result;
    }

    private Map generateSources(String packageName, Context cx, Node node) {
        HashMap<QName, Source> sources = new HashMap<QName, Source>();
        EmbedData embedData = this.getEmbedData();
        Iterator iterator = embedData.class2params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map params;
            Map.Entry e = iterator.next();
            String className = (String)e.getKey();
            Source source = this.generateSource(packageName, className, params = (Map)e.getValue(), cx, node);
            if (source == null) continue;
            sources.put(new QName(packageName, className), source);
        }
        return sources;
    }

    private MemberExpressionNode generateClassInitializer(String name) {
        IdentifierNode identifier = new IdentifierNode(name, 0);
        GetExpressionNode getExpression = new GetExpressionNode(identifier);
        getExpression.pos(0);
        MemberExpressionNode result = new MemberExpressionNode(null, (SelectorNode)getExpression, 0);
        return result;
    }

    private LiteralStringNode generateStringInitializer(String name) {
        LiteralStringNode literalString = new LiteralStringNode(name);
        literalString.pos(0);
        return literalString;
    }

    public static class DeprecatedAttribute
    extends CompilerMessage.CompilerWarning {
        public final String deprecated;
        public final String replacement;
        public final String since;

        public DeprecatedAttribute(String deprecated, String replacement, String since) {
            this.deprecated = deprecated;
            this.replacement = replacement;
            this.since = since;
        }
    }

    public static class EmbedOnlyOnClassesAndVars
    extends CompilerMessage.CompilerError {
    }

    public static class InvalidEmbedVariable
    extends CompilerMessage.CompilerError {
    }

    public static class UnsupportedTypeForEmbed
    extends CompilerMessage.CompilerError {
    }

    public static class UnableToCreateSource
    extends CompilerMessage.CompilerError {
        public final String name;

        public UnableToCreateSource(String name) {
            this.name = name;
        }
    }

    public static class UnableToTranscode
    extends CompilerMessage.CompilerError {
        public final Object what;

        public UnableToTranscode(Object what) {
            this.what = what;
        }
    }

    class EmbedData {
        public String referenceClassName;
        public Map class2params = new HashMap();
        public boolean inUse;

        EmbedData() {
        }

        public void clear() {
            if (this.hasData()) {
                this.class2params = new HashMap();
            }
        }

        public boolean hasData() {
            return this.class2params.size() != 0;
        }
    }
}

