/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.as3.binding.Watcher;
import flex2.compiler.mxml.rep.BindingExpression;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PropertyWatcher
extends Watcher {
    private String property;
    private boolean suppressed;
    private boolean staticProperty;
    private Map bindingExpressions;

    public PropertyWatcher(int id, String property) {
        super(id);
        this.property = property;
        this.bindingExpressions = new HashMap();
        this.suppressed = false;
    }

    public void addBindingExpression(BindingExpression be) {
        this.bindingExpressions.put(new Integer(be.getId()), be);
    }

    public boolean shouldWriteSelf() {
        return !this.suppressed;
    }

    public Collection getBindingExpressions() {
        return this.bindingExpressions.values();
    }

    public String getPathToProperty() {
        String result;
        Watcher parent = this.getParent();
        if (parent instanceof PropertyWatcher) {
            PropertyWatcher parentPropertyWatcher = (PropertyWatcher)parent;
            result = parentPropertyWatcher.getPathToProperty() + "." + this.property;
        } else {
            result = this.property;
        }
        return result;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean getStaticProperty() {
        return this.staticProperty;
    }

    public void setStaticProperty(boolean staticProperty) {
        this.staticProperty = staticProperty;
    }

    public void suppress() {
        this.suppressed = true;
    }
}

