/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.i18n;

import flash.util.FileUtils;
import flash.util.StringJoiner;
import flash.util.StringUtils;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Context;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.as3.Configuration;
import flex2.compiler.as3.EmbedExtension;
import flex2.compiler.as3.Extension;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.i18n.ClassReference;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.i18n.TranslationException;
import flex2.compiler.i18n.TranslationFormat;
import flex2.compiler.i18n.TranslationInfo;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.TextFile;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.ObjectList;

public class Compiler
implements flex2.compiler.Compiler {
    private flex2.compiler.as3.Compiler asc;
    private TranslationFormat format;
    public String generatedDir;
    private String[] locales;
    private CompilerConfiguration configuration;

    public Compiler(final CompilerConfiguration compilerConfig, Transcoder[] transcoders) {
        this.configuration = compilerConfig;
        this.asc = new flex2.compiler.as3.Compiler(new Configuration(){

            public boolean debug() {
                return false;
            }

            public boolean profile() {
                return false;
            }

            public boolean strict() {
                return true;
            }

            public int dialect() {
                return compilerConfig.dialect();
            }

            public boolean adjustOpDebugLine() {
                return compilerConfig.adjustOpDebugLine();
            }

            public boolean warnings() {
                return false;
            }

            public boolean doc() {
                return false;
            }

            public String getEncoding() {
                return null;
            }

            public boolean metadataExport() {
                return false;
            }

            public boolean warn_array_tostring_changes() {
                return false;
            }

            public boolean warn_assignment_within_conditional() {
                return false;
            }

            public boolean warn_bad_array_cast() {
                return false;
            }

            public boolean warn_bad_bool_assignment() {
                return false;
            }

            public boolean warn_bad_date_cast() {
                return false;
            }

            public boolean warn_bad_es3_type_method() {
                return false;
            }

            public boolean warn_bad_es3_type_prop() {
                return false;
            }

            public boolean warn_bad_nan_comparison() {
                return false;
            }

            public boolean warn_bad_null_assignment() {
                return false;
            }

            public boolean warn_bad_null_comparison() {
                return false;
            }

            public boolean warn_bad_undefined_comparison() {
                return false;
            }

            public boolean warn_boolean_constructor_with_no_args() {
                return false;
            }

            public boolean warn_changes_in_resolve() {
                return false;
            }

            public boolean warn_class_is_sealed() {
                return false;
            }

            public boolean warn_const_not_initialized() {
                return false;
            }

            public boolean warn_constructor_returns_value() {
                return false;
            }

            public boolean warn_deprecated_event_handler_error() {
                return false;
            }

            public boolean warn_deprecated_function_error() {
                return false;
            }

            public boolean warn_deprecated_property_error() {
                return false;
            }

            public boolean warn_duplicate_argument_names() {
                return false;
            }

            public boolean warn_duplicate_variable_def() {
                return false;
            }

            public boolean warn_for_var_in_changes() {
                return false;
            }

            public boolean warn_import_hides_class() {
                return false;
            }

            public boolean warn_instance_of_changes() {
                return false;
            }

            public boolean warn_internal_error() {
                return false;
            }

            public boolean warn_level_not_supported() {
                return false;
            }

            public boolean warn_missing_namespace_decl() {
                return false;
            }

            public boolean warn_negative_uint_literal() {
                return false;
            }

            public boolean warn_no_constructor() {
                return false;
            }

            public boolean warn_no_explicit_super_call_in_constructor() {
                return false;
            }

            public boolean warn_no_type_decl() {
                return false;
            }

            public boolean warn_number_from_string_changes() {
                return false;
            }

            public boolean warn_scoping_change_in_this() {
                return false;
            }

            public boolean warn_slow_text_field_addition() {
                return false;
            }

            public boolean warn_unlikely_function_value() {
                return false;
            }

            public boolean warn_xml_class_has_changed() {
                return false;
            }

            public ObjectList getDefine() {
                return null;
            }
        });
        this.generatedDir = compilerConfig.keepGeneratedActionScript() ? compilerConfig.getGeneratedDirectory() : null;
        this.addCompilerExtension(new EmbedExtension(transcoders, this.generatedDir, compilerConfig.showDeprecationWarnings()));
        this.format = I18nUtils.getTranslationFormat(compilerConfig);
        this.locales = compilerConfig.getLocales();
    }

    public void addCompilerExtension(Extension ext) {
        this.asc.addCompilerExtension(ext);
    }

    public boolean isSupported(String mimeType) {
        return this.format.isSupported(mimeType);
    }

    public String[] getSupportedMimeTypes() {
        return this.format.getSupportedMimeTypes();
    }

    public Source preprocess(Source source) {
        return source;
    }

    public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
        TranslationInfo[] translations = new TranslationInfo[this.locales == null ? 0 : this.locales.length];
        int len = translations.length;
        for (int i = 0; i < len; ++i) {
            try {
                translations[i] = this.format.getTranslationSet(this.configuration, symbolTable, source, this.locales[i]);
                continue;
            }
            catch (TranslationException te) {
                ThreadLocalToolkit.logError(te.getMessage());
            }
        }
        if (ThreadLocalToolkit.errorCount() > 0) {
            return null;
        }
        Source transSource = this.transform(source, translations);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return null;
        }
        CompilationUnit ascUnit = this.asc.parse1(transSource, symbolTable);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return null;
        }
        Context context = new Context();
        context.setAttribute("ascUnit", ascUnit);
        context.setAttribute("L10NArchiveFiles", new HashMap());
        CompilationUnit unit = source.newCompilationUnit(null, context);
        int len2 = translations.length;
        for (int i = 0; i < len2; ++i) {
            TranslationInfo info;
            Set atEmbeds;
            if (translations[i] == null || (atEmbeds = (info = translations[i]).getEmeds()) == null || !this.configuration.archiveClassesAndAssets()) continue;
            Map archiveFiles = (Map)context.getAttribute("L10NArchiveFiles");
            Iterator j = atEmbeds.iterator();
            while (j.hasNext()) {
                AtEmbed e = (AtEmbed)j.next();
                String src = (String)e.getAttributes().get("source");
                String original = (String)e.getAttributes().get("original");
                if (src == null) continue;
                if (source.getRelativePath().length() == 0) {
                    archiveFiles.put("locale/" + this.locales[i] + "/" + original, new LocalFile(new File(src)));
                    continue;
                }
                archiveFiles.put("locale/" + this.locales[i] + "/" + source.getRelativePath() + "/" + original, new LocalFile(new File(src)));
            }
        }
        Source.transferMetaData(ascUnit, unit);
        Source.transferGeneratedSources(ascUnit, unit);
        Source.transferDefinitions(ascUnit, unit);
        Source.transferInheritance(ascUnit, unit);
        return unit;
    }

    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("ascUnit");
        Source.transferInheritance(unit, ascUnit);
        this.asc.parse2(ascUnit, symbolTable);
        Source.transferAssets(ascUnit, unit);
        Source.transferGeneratedSources(ascUnit, unit);
    }

    private String transform(Source source, TranslationInfo translations, String packageName, String className, String locale) {
        String lineSep = System.getProperty("line.separator");
        String bundleName = I18nUtils.bundleNameFromClassName(className);
        Object[] codePieces = new String[]{this.codegenImports(translations.getClassReferences()), "[ExcludeClass]", lineSep, lineSep, "public class ", className, " extends ResourceBundle", lineSep, "{", lineSep, this.codegenAtEmbeds(translations.getEmeds()), "    public function ", className, "()", lineSep, "    {", lineSep, this.codegenSuper(locale, bundleName), lineSep, "    }", lineSep, lineSep, "    override protected function getContent():Object", lineSep, "    {", lineSep, "        var content:Object =", lineSep, "        {", lineSep, this.codegenContent(translations.getTranslationSet()), "        };", lineSep, "        return content;", lineSep, "    }", lineSep, "}", lineSep, lineSep};
        return StringJoiner.join((Object[])codePieces, null);
    }

    private Source transform(Source source, TranslationInfo[] translations) {
        int len;
        String name = source.getName();
        String relativePath = source.getRelativePath();
        String shortName = source.getShortName();
        String lineSep = System.getProperty("line.separator");
        String packageName = relativePath.replace('/', '.');
        StringBuffer code = new StringBuffer();
        code.append("package ");
        code.append(packageName);
        code.append(lineSep);
        code.append("{");
        code.append(lineSep);
        code.append(lineSep);
        int n = len = translations == null ? 0 : translations.length;
        for (int i = 0; i < len; ++i) {
            String className = this.locales[i] + "$" + shortName + I18nUtils.CLASS_SUFFIX;
            code.append(this.transform(source, translations[i], packageName, className, this.locales[i]));
            code.append(lineSep);
            code.append(lineSep);
        }
        code.append("}");
        code.append(lineSep);
        if (this.generatedDir != null) {
            try {
                FileUtils.writeClassToFile((String)this.generatedDir, (String)packageName, (String)(shortName + I18nUtils.CLASS_SUFFIX + ".as"), (String)code.toString());
            }
            catch (IOException ioe) {
                ThreadLocalToolkit.logError(ioe.toString());
            }
        }
        return new Source(new TextFile(code.toString(), name, source.getParent(), "text/as", source.getLastModified()), source);
    }

    private String codegenImports(Set imports) {
        String lineSep = System.getProperty("line.separator");
        StringJoiner.ItemStringer itemStringer = new StringJoiner.ItemStringer(){

            public String itemToString(Object obj) {
                return "import " + (String)obj + ";";
            }
        };
        return StringJoiner.join((Collection)imports, (String)lineSep, (StringJoiner.ItemStringer)itemStringer) + lineSep + lineSep;
    }

    private String codegenAtEmbeds(Set atEmbeds) {
        if (this.configuration.archiveClassesAndAssets()) {
            return "";
        }
        String lineSep = System.getProperty("line.separator");
        StringJoiner.ItemStringer itemStringer = new StringJoiner.ItemStringer(){

            public String itemToString(Object obj) {
                AtEmbed atEmbed = (AtEmbed)obj;
                return Compiler.this.codegenEmbedMetadata(atEmbed) + Compiler.this.codegenEmbedVar(atEmbed);
            }
        };
        return StringJoiner.join((Collection)atEmbeds, (String)lineSep, (StringJoiner.ItemStringer)itemStringer) + lineSep;
    }

    private String codegenEmbedMetadata(AtEmbed atEmbed) {
        String lineSep = System.getProperty("line.separator");
        StringJoiner.MapEntryItemWithEquals itemStringer = new StringJoiner.MapEntryItemWithEquals();
        return "    [Embed(" + StringJoiner.join(atEmbed.getAttributes().entrySet(), (String)", ", (StringJoiner.ItemStringer)itemStringer) + ")]" + lineSep;
    }

    private String codegenEmbedVar(AtEmbed atEmbed) {
        String lineSep = System.getProperty("line.separator");
        return "    private static var " + atEmbed.getPropName() + ":" + atEmbed.getType() + ";" + lineSep;
    }

    private String codegenSuper(String locale, String bundleName) {
        return this.configuration.getResourceHack() ? "\t\t super();" : "\t\t super(\"" + locale + "\", \"" + bundleName + "\");";
    }

    private String codegenContent(Set resources) {
        String lineSep = System.getProperty("line.separator");
        int version = this.configuration.getCompatibilityVersion();
        final boolean flex2Compatible = version < 0x3000000;
        StringJoiner.ItemStringer itemStringer = new StringJoiner.ItemStringer(){

            public String itemToString(Object obj) {
                Object value;
                Map.Entry entry = (Map.Entry)obj;
                String key = (String)entry.getKey();
                if (!flex2Compatible) {
                    key = Compiler.this.escape(key);
                }
                if ((value = entry.getValue()) instanceof ClassReference) {
                    value = value.toString();
                } else if (value instanceof AtEmbed) {
                    value = Compiler.this.configuration.archiveClassesAndAssets() ? "\"\"" : ((AtEmbed)value).getPropName();
                } else {
                    if (!flex2Compatible) {
                        value = Compiler.this.escape((String)value);
                    }
                    value = "\"" + value + "\"";
                }
                return "            \"" + key + "\": " + value;
            }
        };
        return StringJoiner.join((Collection)resources, (String)("," + lineSep), (StringJoiner.ItemStringer)itemStringer) + lineSep;
    }

    private String escape(String s) {
        s = StringUtils.formatString((String)s);
        int n = s.length();
        return s.substring(1, n - 1);
    }

    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("ascUnit");
        this.asc.analyze1(ascUnit, symbolTable);
        Source.transferTypeInfo(ascUnit, unit);
        Source.transferNamespaces(ascUnit, unit);
    }

    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("ascUnit");
        Source.transferDependencies(unit, ascUnit);
        this.asc.analyze2(ascUnit, symbolTable);
        Source.transferDependencies(ascUnit, unit);
    }

    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("ascUnit");
        Source.transferDependencies(unit, ascUnit);
        this.asc.analyze3(ascUnit, symbolTable);
    }

    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("ascUnit");
        this.asc.analyze4(ascUnit, symbolTable);
        Source.transferExpressions(ascUnit, unit);
    }

    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("ascUnit");
        this.asc.generate(ascUnit, symbolTable);
        unit.bytes.clear();
        unit.bytes.addAll(ascUnit.bytes);
    }

    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
    }
}

