/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flash.util.FileUtils;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.as3.Extension;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.ImplementationCompiler;
import flex2.compiler.mxml.InterfaceCompiler;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.util.NameMappings;
import java.io.File;

public class Compiler
implements flex2.compiler.Compiler {
    private static final String ATTR_STATE = "MxmlState";
    private static final int STATE_INTERFACE_PARSED = 0;
    private static final int STATE_INTERFACE_GENERATED = 1;
    private static final int STATE_IMPLEMENTATION_PARSED = 2;
    private static final int STATE_IMPLEMENTATION_GENERATED = 3;
    static final String DOCUMENT_INFO = "DocumentInfo";
    static final String TYPE_TABLE;
    static final String LINE_NUMBER_MAP = "LineNumberMap";
    static final String DELEGATE_UNIT = "DelegateUnit";
    static final String CHECK_NODES = "CheckNodes";
    private InterfaceCompiler intfc;
    private ImplementationCompiler implc;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Compiler(Configuration mxmlConfiguration, flex2.compiler.as3.Configuration ascConfiguration, NameMappings mappings, Transcoder[] transcoders) {
        this.intfc = new InterfaceCompiler(mxmlConfiguration, ascConfiguration, mappings);
        this.implc = new ImplementationCompiler(mxmlConfiguration, ascConfiguration, mappings, transcoders);
    }

    public boolean isSupported(String mimeType) {
        return this.implc.isSupported(mimeType);
    }

    public String[] getSupportedMimeTypes() {
        return this.implc.getSupportedMimeTypes();
    }

    public void addInterfaceCompilerExtension(Extension ext) {
        this.intfc.getASCompiler().addCompilerExtension(ext);
    }

    public void addImplementationCompilerExtension(Extension ext) {
        this.implc.getASCompiler().addCompilerExtension(ext);
    }

    public Source preprocess(Source source) {
        if (source.getCompilationUnit() == null) {
            return this.intfc.preprocess(source);
        }
        return this.implc.preprocess(source);
    }

    public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
        CompilationUnit unit = source.getCompilationUnit();
        if (unit == null) {
            unit = this.intfc.parse1(source, symbolTable);
            if (unit != null) {
                this.setState(unit, 0);
            }
        } else if (this.getState(unit) == 1 && (unit = this.implc.parse1(source, symbolTable)) != null) {
            this.advanceState(unit);
        }
        return unit;
    }

    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        this.getSubCompiler(unit).parse2(unit, symbolTable);
    }

    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        this.getSubCompiler(unit).analyze1(unit, symbolTable);
    }

    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        this.getSubCompiler(unit).analyze2(unit, symbolTable);
    }

    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        this.getSubCompiler(unit).analyze3(unit, symbolTable);
    }

    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        this.getSubCompiler(unit).analyze4(unit, symbolTable);
    }

    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
        this.getSubCompiler(unit).generate(unit, symbolTable);
        this.advanceState(unit);
    }

    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
        this.getSubCompiler(unit).postprocess(unit, symbolTable);
    }

    private int getState(CompilationUnit unit) {
        if (!$assertionsDisabled && unit.getContext().getAttribute(ATTR_STATE) == null) {
            throw new AssertionError((Object)"unit lacks MxmlState attribute");
        }
        return (Integer)unit.getContext().getAttribute(ATTR_STATE);
    }

    private void setState(CompilationUnit unit, int state) {
        unit.getContext().setAttribute(ATTR_STATE, new Integer(state));
    }

    private void advanceState(CompilationUnit unit) {
        int state = this.getState(unit);
        if (!$assertionsDisabled && state >= 3) {
            throw new AssertionError((Object)("advanceState called with state == " + state));
        }
        this.setState(unit, state + 1);
    }

    private flex2.compiler.Compiler getSubCompiler(CompilationUnit unit) {
        return this.getState(unit) < 2 ? this.intfc : this.implc;
    }

    static String getGeneratedName(Configuration mxmlConfiguration, String packageName, String className, String suffix) {
        String dir = mxmlConfiguration.getGeneratedDirectory();
        if (packageName != null && packageName.length() > 0) {
            dir = FileUtils.addPathComponents((String)dir, (String)packageName.replace('.', File.separatorChar), (char)File.separatorChar);
        }
        return FileUtils.addPathComponents((String)dir, (String)(className + suffix), (char)File.separatorChar);
    }

    static {
        $assertionsDisabled = !Compiler.class.desiredAssertionStatus();
        TYPE_TABLE = TypeTable.class.getName();
    }
}

