/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.builder.AnonymousObjectGraphBuilder;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.AnonymousObjectGraph;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;

class ModelBuilder
extends AnonymousObjectGraphBuilder {
    ModelBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document) {
        super(unit, typeTable, configuration, document);
    }

    public void analyze(ModelNode node) {
        String classObjectProxy = NameFormatter.toDot(StandardDefs.CLASS_OBJECTPROXY);
        this.document.addImport(classObjectProxy, node.beginLine);
        Type bindingClass = this.typeTable.getType(StandardDefs.CLASS_OBJECTPROXY);
        if (bindingClass == null) {
            this.log(node, (CompilerMessage)new ClassNotFound(classObjectProxy));
        }
        this.graph = new AnonymousObjectGraph(this.document, bindingClass, node.beginLine);
        this.registerModel(node, (Model)this.graph, true);
        if (node.getChildCount() == 1 && node.getChildAt(0) instanceof CDATANode) {
            CDATANode cdata = (CDATANode)node.getChildAt(0);
            if (cdata.image.length() > 0) {
                String bindingExprString = TextParser.getBindingExpressionFromString(cdata.image);
                if (bindingExprString != null) {
                    BindingExpression bindingExpression = new BindingExpression(bindingExprString, cdata.beginLine, this.document);
                    bindingExpression.setDestination(this.graph);
                    bindingExpression.setDestinationObjectProxy(true);
                } else {
                    this.log(cdata, (CompilerMessage)new OnlyScalarError((String)node.getAttribute("id")));
                }
            }
        } else if (node.getChildCount() == 1) {
            this.processChildren((Node)node.getChildAt(0), this.graph);
        } else if (node.getChildCount() > 1) {
            this.log(node, (CompilerMessage)new OnlyOneRootTag());
        }
    }

    public static class OnlyOneRootTag
    extends CompilerMessage.CompilerError {
    }

    public static class OnlyScalarError
    extends CompilerMessage.CompilerError {
        public String id;

        public OnlyScalarError(String id) {
            this.id = id;
        }
    }

    public static class ClassNotFound
    extends CompilerMessage.CompilerError {
        public String className;

        public ClassNotFound(String className) {
            this.className = className;
        }
    }
}

