/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.analyzer.RemoteObjectAnalyzer;
import flex2.compiler.mxml.builder.ComponentBuilder;
import flex2.compiler.mxml.builder.ServiceRequestBuilder;
import flex2.compiler.mxml.dom.ArgumentsNode;
import flex2.compiler.mxml.dom.MethodNode;
import flex2.compiler.mxml.dom.RemoteObjectNode;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.AnonymousObjectGraph;
import flex2.compiler.mxml.rep.Array;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.Iterator;

class RemoteObjectBuilder
extends ComponentBuilder {
    private static final String OPERATIONS = "operations";
    private static final String NAME = "name";
    private static final String ARGUMENTS = "arguments";
    private static final String ARGUMENT_NAMES = "argumentNames";
    private Model ops;

    RemoteObjectBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document) {
        super(unit, typeTable, configuration, document, null, true, null);
        this.childNodeHandler = new RemoteObjectChildNodeHandler(typeTable);
    }

    public void analyze(RemoteObjectNode node) {
        new RemoteObjectAnalyzer(this.unit, this.configuration).analyze(node);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        Type type = this.typeTable.getType(node.getNamespace(), node.getLocalPart());
        this.component = new Model(this.document, type, node.beginLine);
        this.registerModel(node, this.component, true);
        this.processAttributes(node, type);
        this.ops = new Model(this.document, this.typeTable.objectType, this.component, this.component.getXmlLineNumber());
        this.ops.setParentIndex(OPERATIONS);
        this.component.setProperty(OPERATIONS, this.ops);
        this.processChildren(node, type);
    }

    public void addOperation(Model ops, MethodNode node) {
        Type type = this.typeTable.getType(node.getNamespace(), StandardDefs.getConvertedTagName(node));
        Model ro = this.component;
        ComponentBuilder.ComponentChildNodeHandler roChildNodeHandler = this.childNodeHandler;
        this.component = new Model(this.document, type, ops, node.beginLine);
        this.childNodeHandler = new MethodChildNodeHandler(this.typeTable);
        String name = (String)node.getAttribute(NAME);
        ops.setProperty(name, this.component);
        this.component.setParentIndex(name);
        this.processAttributes(node, type);
        this.processChildren(node, type);
        this.childNodeHandler = roChildNodeHandler;
        this.component = ro;
    }

    public void addArguments(Model op, ArgumentsNode node) {
        ServiceRequestBuilder builder = new ServiceRequestBuilder(this.unit, this.typeTable, this.configuration, this.document, ARGUMENTS);
        node.analyze(builder);
        AnonymousObjectGraph arguments = builder.graph;
        op.setProperty(ARGUMENTS, arguments);
        arguments.setParentIndex(ARGUMENTS);
        arguments.setParent(op);
        Array argNames = new Array(this.document, this.typeTable.objectType, op, node.beginLine);
        op.setProperty(ARGUMENT_NAMES, argNames);
        argNames.setParentIndex(ARGUMENT_NAMES);
        Iterator propNames = arguments.getProperties().keySet().iterator();
        while (propNames.hasNext()) {
            String s = (String)propNames.next();
            argNames.addEntry(s, op.getXmlLineNumber());
        }
    }

    protected class MethodChildNodeHandler
    extends ComponentBuilder.ComponentChildNodeHandler {
        int argumentsCount;

        public MethodChildNodeHandler(TypeTable typeTable) {
            super(typeTable);
            this.argumentsCount = 0;
        }

        protected void languageNode() {
            if (this.child instanceof ArgumentsNode && this.argumentsCount == 0) {
                this.argumentsCount = 1;
                RemoteObjectBuilder.this.addArguments(RemoteObjectBuilder.this.component, (ArgumentsNode)this.child);
            } else {
                super.languageNode();
            }
        }
    }

    protected class RemoteObjectChildNodeHandler
    extends ComponentBuilder.ComponentChildNodeHandler {
        public RemoteObjectChildNodeHandler(TypeTable typeTable) {
            super(typeTable);
        }

        protected void languageNode() {
            if (this.child instanceof MethodNode) {
                RemoteObjectBuilder.this.addOperation(RemoteObjectBuilder.this.ops, (MethodNode)this.child);
            } else {
                super.languageNode();
            }
        }
    }
}

