/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.swf.Frame;
import flash.swf.Movie;
import flash.swf.MovieDecoder;
import flash.swf.Tag;
import flash.swf.TagDecoder;
import flash.swf.TagHandler;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DoABC;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Digest;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.swc.catalog.CatalogReader;
import flex2.compiler.util.NameFormatter;
import flex2.linker.SimpleMovie;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SwcLibrary {
    protected final Swc swc;
    protected final String path;
    protected List scripts;
    protected Map name2script;
    protected Map def2symbol;
    protected boolean parsed;
    private Set externs;
    private String location = null;
    private Set metadata;
    protected Map digests = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public SwcLibrary(Swc swc, String path) {
        this.swc = swc;
        this.path = path;
        this.scripts = new LinkedList();
        this.parsed = false;
        this.name2script = new HashMap();
        this.externs = new HashSet();
        this.metadata = new HashSet();
    }

    public Swc getSwc() {
        return this.swc;
    }

    public String getPath() {
        return this.path;
    }

    public String getSwcLocation() {
        if (this.location != null) {
            return this.location;
        }
        return this.swc.getLocation();
    }

    public long getSwcCreationTime() {
        return this.swc.getLastModified();
    }

    public void clear() {
        this.scripts = null;
        this.def2symbol = null;
    }

    public Set getExterns() {
        return this.externs;
    }

    public SwcScript addScript(String name, Set defs, SwcDependencySet deps, long modtime, Long signatureChecksum) {
        SwcScript script = new SwcScript(this, name, defs, deps, modtime, signatureChecksum);
        this.scripts.add(script);
        this.name2script.put(script.getName(), script);
        if (!($assertionsDisabled || name != null && name.length() > 0)) {
            throw new AssertionError();
        }
        return script;
    }

    public Iterator getScriptIterator() {
        return this.scripts.iterator();
    }

    public DefineTag getSymbol(String name) {
        name = name.replace(':', '.');
        return (DefineTag)this.def2symbol.get(name);
    }

    protected SwcScript getScript(DoABC doABC) {
        if (!$assertionsDisabled && doABC.code != 82) {
            throw new AssertionError();
        }
        return (SwcScript)this.name2script.get(doABC.name);
    }

    protected void parse() {
        if (this.parsed) {
            return;
        }
        VirtualFile swcFile = this.swc.getArchive().getFile(this.path);
        if (swcFile == null) {
            throw new SwcException.CatalogNotFound();
        }
        Movie movie = new Movie();
        MovieDecoder movieDecoder = new MovieDecoder(movie);
        try {
            TagDecoder tagDecoder = new TagDecoder(swcFile.getInputStream());
            tagDecoder.parse((TagHandler)movieDecoder);
        }
        catch (IOException e) {
            // empty catch block
        }
        int c1 = 0;
        this.def2symbol = new HashMap();
        Iterator frames = movie.frames.iterator();
        while (frames.hasNext()) {
            int c2;
            Frame frame = (Frame)frames.next();
            Iterator abcit = frame.doABCs.iterator();
            while (abcit.hasNext()) {
                DoABC doABC = (DoABC)abcit.next();
                SwcScript script = this.getScript(doABC);
                script.setDoABC(doABC);
            }
            Iterator it = frame.symbolClass.class2tag.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String className = (String)e.getKey();
                DefineTag tag = (DefineTag)e.getValue();
                this.def2symbol.put(className, tag);
            }
            if (!Swc.FNORD) continue;
            if (frame.label != null) {
                try {
                    c1 = Integer.parseInt(frame.label.label);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (c1 == (c2 = SimpleMovie.getCodeHash(frame))) continue;
            this.location = " " + this.swc.getLocation();
        }
        this.parsed = true;
    }

    void getSymbolClasses(String def, Set symbolClasses) {
        DefineTag t = this.getSymbol(def);
        if (t != null) {
            Iterator i = t.getReferences();
            while (i != null && i.hasNext()) {
                Tag r = (Tag)i.next();
                if (r == null) continue;
                Iterator j = this.def2symbol.keySet().iterator();
                while (j.hasNext()) {
                    String className = (String)j.next();
                    if (this.def2symbol.get(className) != r) continue;
                    symbolClasses.add(NameFormatter.toColon(className));
                }
            }
        }
    }

    public Set getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Set metadata) {
        this.metadata = metadata;
    }

    public void addMetadata(Collection metadata) {
        this.metadata.addAll(metadata);
    }

    public Digest getDigest(String hashType, boolean isSigned) {
        if (hashType == null) {
            throw new NullPointerException("hashType may not be null");
        }
        return (Digest)this.digests.get(CatalogReader.createDigestHashValue(hashType, isSigned));
    }

    public void setDigest(Digest digest) {
        if (digest == null) {
            throw new NullPointerException("setDigest:  digest may not be null");
        }
        this.digests.put(CatalogReader.createDigestHashValue(digest.getType(), digest.isSigned()), digest);
    }

    public Map getDigests() {
        return this.digests;
    }

    public void setDigests(Map digests) {
        this.digests = digests;
    }

    static {
        $assertionsDisabled = !SwcLibrary.class.desiredAssertionStatus();
    }
}

