/*
 * Decompiled with CFR 0.152.
 */
package flash.css;

import flash.css.Descriptor;
import flash.css.MediaList;
import flash.css.StyleDeclarationBlock;
import flash.css.StyleSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.css.sac.LexicalUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleDeclaration {
    private int lineNumber;
    private String path;
    private String subject;
    private StyleSelector selector;
    private boolean hasMediaQuery;
    private Map<String, StyleDeclarationBlock> blockCache;
    private List<StyleDeclarationBlock> declarationBlocks;
    private Map<String, Descriptor> descriptors;

    public StyleDeclaration(String path, int lineNumber) {
        this.path = path;
        this.lineNumber = lineNumber;
        this.blockCache = new HashMap<String, StyleDeclarationBlock>(2);
        this.declarationBlocks = new ArrayList<StyleDeclarationBlock>(2);
        this.descriptors = new LinkedHashMap<String, Descriptor>();
    }

    public String getPath() {
        return this.path;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public StyleSelector getSelector() {
        return this.selector;
    }

    public void setSelector(StyleSelector selector) {
        this.selector = selector;
    }

    public boolean hasProperties() {
        for (StyleDeclarationBlock block : this.declarationBlocks) {
            if (block.getProperties().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasEffectStyles() {
        for (StyleDeclarationBlock block : this.declarationBlocks) {
            if (block.getEffectStyles().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public List<StyleDeclarationBlock> getDeclarationBlocks() {
        return this.declarationBlocks;
    }

    public StyleDeclarationBlock getDeclarationBlock(StyleSelector selector, MediaList mediaList) {
        StyleDeclarationBlock block;
        if (mediaList != null) {
            this.hasMediaQuery = true;
        }
        if (this.hasMediaQuery) {
            block = new StyleDeclarationBlock(mediaList);
            this.declarationBlocks.add(block);
        } else {
            String key = StyleDeclaration.getDeclarationBlockKey(selector, mediaList);
            block = this.blockCache.get(key);
            if (block == null) {
                block = new StyleDeclarationBlock(mediaList);
                this.blockCache.put(key, block);
                this.declarationBlocks.add(block);
            }
        }
        return block;
    }

    private static String getDeclarationBlockKey(StyleSelector selector, MediaList mediaList) {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(selector.toString()).append(')');
        sb.append('(');
        if (mediaList != null) {
            for (String query : mediaList.getQueries()) {
                sb.append(query);
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public Descriptor getDescriptorValue(String name) {
        return this.descriptors.get(name);
    }

    public void setDescriptor(String propertyName, LexicalUnit value, String priority) {
        this.descriptors.put(propertyName, new Descriptor(propertyName, value, this.path));
    }

    public Descriptor removeDescriptor(String name) {
        return this.descriptors.remove(name);
    }

    public Iterator<Map.Entry<String, Descriptor>> iterator() {
        return this.descriptors.entrySet().iterator();
    }

    public StyleDeclaration shallowCopy() {
        StyleDeclaration decl = new StyleDeclaration(this.path, this.lineNumber);
        decl.subject = this.subject;
        decl.selector = this.selector;
        decl.descriptors = this.descriptors;
        return decl;
    }
}

