/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flash.fonts.FontManager;
import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.localization.XLRLocalizer;
import flash.swf.Movie;
import flash.swf.MovieEncoder;
import flash.swf.TagEncoder;
import flash.swf.TagEncoderReporter;
import flash.swf.TagHandler;
import flash.util.FileUtils;
import flex.messaging.config.ServicesDependencies;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.Logger;
import flex2.compiler.PersistenceStore;
import flex2.compiler.PreLink;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SourcePathBase;
import flex2.compiler.SubCompiler;
import flex2.compiler.SymbolTable;
import flex2.compiler.as3.As3Compiler;
import flex2.compiler.as3.SignatureExtension;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.FramesConfiguration;
import flex2.compiler.common.LocalFilePathResolver;
import flex2.compiler.common.PathResolver;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.extensions.ExtensionManager;
import flex2.compiler.extensions.IPreCompileExtension;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.ResourceFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.Benchmark;
import flex2.compiler.util.CompilerControl;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ConsoleLogger;
import flex2.compiler.util.LocalLogger;
import flex2.compiler.util.ManifestParser;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.Name;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.URLPathResolver;
import flex2.compiler.util.graph.Algorithms;
import flex2.compiler.util.graph.DependencyGraph;
import flex2.compiler.util.graph.Vertex;
import flex2.compiler.util.graph.Visitor;
import flex2.linker.ConsoleApplication;
import flex2.linker.SimpleMovie;
import flex2.tools.CompcPreLink;
import flex2.tools.oem.ProgressMeter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.VariableSlot;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.ProfileController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompilerAPI {
    private static final int INHERITANCE = 1;
    private static final int NAMESPACES = 2;
    private static final int TYPES = 3;
    private static final int EXPRESSIONS = 4;
    private static final int preprocess = 2;
    private static final int parse1 = 4;
    private static final int parse2 = 8;
    private static final int analyze1 = 16;
    private static final int analyze2 = 32;
    private static final int analyze3 = 64;
    private static final int analyze4 = 128;
    private static final int resolveType = 1024;
    private static final int generate = 8192;
    private static final int resolveImportStatements = 16384;
    private static final int adjustQNames = 32768;
    private static final int extraSources = 65536;
    private static final MultiName[] multiNames = new MultiName[]{new MultiName("Object"), new MultiName("Class"), new MultiName("Function"), new MultiName("Boolean"), new MultiName("Number"), new MultiName("String"), new MultiName("Array"), new MultiName("int"), new MultiName("uint"), new MultiName("Namespace"), new MultiName("RegExp"), new MultiName("XML"), new MultiName("XMLList")};
    private static boolean skipTimestampCheck = false;

    public static void useAS3() {
        System.setProperty("AS3", "");
        System.setProperty("AVMPLUS", "");
    }

    public static void useConsoleLogger() {
        CompilerAPI.useConsoleLogger(true, true, true, true);
    }

    public static void useConsoleLogger(boolean isInfoEnabled, boolean isDebugEnabled, boolean isWarningEnabled, boolean isErrorEnabled) {
        ThreadLocalToolkit.setLogger(new ConsoleLogger(isInfoEnabled, isDebugEnabled, isWarningEnabled, isErrorEnabled));
    }

    public static Benchmark runBenchmark() {
        Benchmark b = ThreadLocalToolkit.getBenchmark();
        if (b == null) {
            block5: {
                try {
                    String className = System.getProperty("flex2.compiler.benchmark");
                    if (className != null) {
                        Class<?> benchmarkClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                        b = (Benchmark)benchmarkClass.newInstance();
                    }
                }
                catch (Exception e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)e.toString());
                }
            }
            if (b == null) {
                b = new Benchmark();
            }
            ThreadLocalToolkit.setBenchmark(b);
            ThreadLocalToolkit.resetBenchmark();
        }
        return b;
    }

    public static void disableBenchmark() {
        ThreadLocalToolkit.setBenchmark(null);
    }

    public static void usePathResolver() {
        CompilerAPI.usePathResolver(null);
    }

    public static void usePathResolver(SinglePathResolver resolver) {
        PathResolver pathResolver = new PathResolver();
        if (resolver != null) {
            pathResolver.addSinglePathResolver(resolver);
        }
        pathResolver.addSinglePathResolver(LocalFilePathResolver.getSingleton());
        pathResolver.addSinglePathResolver(URLPathResolver.getSingleton());
        ThreadLocalToolkit.setPathResolver(pathResolver);
    }

    public static void removePathResolver() {
        ThreadLocalToolkit.setPathResolver(null);
        ThreadLocalToolkit.resetResolvedPaths();
    }

    public static void setupHeadless(Configuration configuration) {
        if (configuration.getCompilerConfiguration().headlessServer()) {
            try {
                Properties systemProps = System.getProperties();
                systemProps.put("java.awt.headless", "true");
                System.setProperties(systemProps);
            }
            catch (SecurityException securityException) {
                ThreadLocalToolkit.log(new UnableToSetHeadless());
            }
        }
    }

    public static NameMappings getNameMappings(Configuration configuration) {
        NameMappings mappings = new NameMappings();
        Map<String, List<VirtualFile>> manifests = configuration.getCompilerConfiguration().getNamespacesConfiguration().getManifestMappings();
        if (manifests != null) {
            for (Map.Entry<String, List<VirtualFile>> entry : manifests.entrySet()) {
                String ns = entry.getKey();
                List<VirtualFile> files = entry.getValue();
                for (VirtualFile file : files) {
                    ManifestParser.parse(ns, file, mappings);
                }
            }
        }
        return mappings;
    }

    private static void batch1(List<Source> sources, List<CompilationUnit> units, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SymbolTable symbolTable, SubCompiler[] compilers, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        int start = 0;
        int end = sources.size();
        while (start < end && CompilerAPI.preprocess(sources, compilers, start, end, symbolTable.getSuppressWarningsIncremental()) && !CompilerAPI.tooManyErrors() && !CompilerAPI.forcedToStop() && CompilerAPI.parse1(sources, units, igraph, dgraph, compilers, symbolTable, start, end) && !CompilerAPI.tooManyErrors() && !CompilerAPI.forcedToStop()) {
            CompilerConfiguration config;
            CompilerAPI.resolveInheritance(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, start, end);
            CompilerAPI.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, start, end);
            start = end;
            if (start < (end = sources.size())) continue;
            if (!CompilerAPI.sortInheritance(sources, units, igraph) || !CompilerAPI.parse2(sources, compilers, symbolTable) || CompilerAPI.tooManyErrors() || CompilerAPI.forcedToStop() || !CompilerAPI.analyze(sources, compilers, symbolTable, 1) || CompilerAPI.tooManyErrors() || CompilerAPI.forcedToStop()) break;
            CompilerAPI.resolveNamespace(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, 0, end);
            CompilerAPI.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, 0, end);
            start = end;
            if (start < (end = sources.size())) continue;
            if (!CompilerAPI.analyze(sources, compilers, symbolTable, 2) || CompilerAPI.tooManyErrors() || CompilerAPI.forcedToStop()) break;
            CompilerAPI.resolveType(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext);
            CompilerConfiguration compilerConfiguration = config = configuration != null ? configuration.getCompilerConfiguration() : null;
            if (config != null && config.strict()) {
                CompilerAPI.resolveImportStatements(sources, units, sourcePath, swcContext);
            }
            if (config != null && (config.strict() || config.warnings())) {
                CompilerAPI.resolveExpression(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration);
            }
            if ((start = end) < (end = sources.size())) continue;
            if (!CompilerAPI.analyze(sources, compilers, symbolTable, 3) || CompilerAPI.tooManyErrors() || CompilerAPI.forcedToStop() || !CompilerAPI.analyze(sources, compilers, symbolTable, 4) || CompilerAPI.tooManyErrors() || CompilerAPI.forcedToStop() || !CompilerAPI.generate(sources, units, compilers, symbolTable) || CompilerAPI.tooManyErrors() || CompilerAPI.forcedToStop()) break;
            CompilerAPI.markDone(sources, units);
            if (!CompilerAPI.postprocess(sources, units, compilers, symbolTable) || CompilerAPI.tooManyErrors() || CompilerAPI.forcedToStop()) break;
            CompilerAPI.resolveExpression(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration);
            CompilerAPI.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, 0, end);
            start = end;
            end = sources.size();
        }
        CompilerAPI.adjustQNames(units, igraph, symbolTable);
    }

    private static void batch2(List<Source> sources, List<CompilationUnit> units, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SymbolTable symbolTable, SubCompiler[] compilers, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        int benchmarkCompilingDetails;
        Benchmark benchmark = ThreadLocalToolkit.getBenchmark();
        int n = benchmarkCompilingDetails = benchmark == null ? -1 : configuration.getBenchmarkCompilerDetails();
        if (benchmarkCompilingDetails > 4) {
            benchmark.benchmark2(ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new BatchTime("start", "")), true);
        }
        CompilerConfiguration config = configuration != null ? configuration.getCompilerConfiguration() : null;
        ArrayList<Source> targets = new ArrayList<Source>(sources.size());
        units.clear();
        int size = sources.size();
        for (int i = 0; i < size; ++i) {
            Source s = sources.get(i);
            if (s != null && s.isCompiled()) {
                units.add(s.getCompilationUnit());
                continue;
            }
            units.add(null);
        }
        if (benchmarkCompilingDetails > 4) {
            benchmark.benchmark2(ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new BatchTime("init units", "")));
        }
        while (CompilerAPI.nextSource(sources, igraph, dgraph, targets, symbolTable, configuration) > 0) {
            int postprocessCount = 0;
            int size2 = targets.size();
            for (int i = 0; i < size2; ++i) {
                Source s = (Source)targets.get(i);
                if (s == null) continue;
                int w = CompilerAPI.getCompilationUnitWorkflow(s);
                if ((w & 2) == 0) {
                    CompilerAPI.preprocess(sources, compilers, i, i + 1, symbolTable.getSuppressWarningsIncremental());
                    if (benchmarkCompilingDetails > 4) {
                        benchmark.benchmark2(ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new BatchTime("preprocess", s.getNameForReporting())));
                    }
                } else if ((w & 4) == 0) {
                    CompilerAPI.parse1(sources, units, igraph, dgraph, compilers, symbolTable, i, i + 1);
                    CompilerAPI.resolveInheritance(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, i, i + 1);
                    CompilerAPI.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, i, i + 1);
                    if (benchmarkCompilingDetails > 4) {
                        ThreadLocalToolkit.getBenchmark().benchmark2(ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new BatchTime("parse1", s.getNameForReporting())));
                    }
                } else if ((w & 8) == 0) {
                    CompilerAPI.parse2(sources, compilers, symbolTable, i, i + 1);
                    CompilerAPI.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, i, i + 1);
                    if (benchmarkCompilingDetails > 4) {
                        ThreadLocalToolkit.getBenchmark().benchmark2(ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new BatchTime("parse2", s.getNameForReporting())));
                    }
                } else if ((w & 0x10) == 0) {
                    CompilerAPI.analyze(sources, compilers, symbolTable, i, i + 1, 1);
                    CompilerAPI.resolveNamespace(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, i, i + 1);
                    CompilerAPI.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, i, i + 1);
                    if (benchmarkCompilingDetails > 4) {
                        ThreadLocalToolkit.getBenchmark().benchmark2(ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new BatchTime("analyze1", s.getNameForReporting())));
                    }
                } else if ((w & 0x20) == 0) {
                    CompilerAPI.analyze(sources, compilers, symbolTable, i, i + 1, 2);
                    CompilerAPI.resolveType(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, i, i + 1);
                    if (config.strict()) {
                        CompilerAPI.resolveImportStatements(sources, units, sourcePath, swcContext, i, i + 1);
                    }
                    CompilerAPI.resolveExpression(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration, i, i + 1);
                    if (benchmarkCompilingDetails > 4) {
                        ThreadLocalToolkit.getBenchmark().benchmark2(ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new BatchTime("analyze2", s.getNameForReporting())));
                    }
                } else if ((w & 0x40) == 0) {
                    CompilerAPI.analyze(sources, compilers, symbolTable, i, i + 1, 3);
                    if (benchmarkCompilingDetails > 4) {
                        ThreadLocalToolkit.getBenchmark().benchmark2(ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new BatchTime("analyze3", s.getNameForReporting())));
                    }
                } else if ((w & 0x80) == 0) {
                    CompilerAPI.analyze(sources, compilers, symbolTable, i, i + 1, 4);
                    if (benchmarkCompilingDetails > 4) {
                        ThreadLocalToolkit.getBenchmark().benchmark2(ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new BatchTime("analyze4", s.getNameForReporting())));
                    }
                } else if ((w & 0x2000) == 0) {
                    CompilerAPI.generate(sources, units, compilers, symbolTable, i, i + 1);
                    CompilerAPI.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, i, i + 1);
                    CompilerAPI.resolveExpression(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration, i, i + 1);
                    CompilerAPI.markDone(sources, units, i, i + 1);
                    if (benchmarkCompilingDetails > 4) {
                        ThreadLocalToolkit.getBenchmark().benchmark2(ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new BatchTime("generate", s.getNameForReporting())));
                    }
                }
                if (CompilerAPI.tooManyErrors() || CompilerAPI.forcedToStop()) break;
                if ((w & 0x2000) != 0) {
                    CompilerAPI.postprocess(sources, units, compilers, symbolTable, i, i + 1);
                    CompilerAPI.resolveExpression(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration, i, i + 1);
                    ++postprocessCount;
                    if (benchmarkCompilingDetails > 4) {
                        ThreadLocalToolkit.getBenchmark().benchmark2(ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)new BatchTime("postprocess", s.getNameForReporting())));
                    }
                }
                if (CompilerAPI.tooManyErrors() || CompilerAPI.forcedToStop()) break;
            }
            if ((postprocessCount != targets.size() || sources.size() != targets.size()) && !CompilerAPI.tooManyErrors() && !CompilerAPI.forcedToStop()) continue;
            break;
        }
        CompilerAPI.adjustQNames(units, igraph, symbolTable);
    }

    private static int nextSource(List<Source> sources, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, List<Source> targets, SymbolTable symbolTable, Configuration configuration) {
        int count = 0;
        int isDone = 0;
        boolean strict = configuration.getCompilerConfiguration().strict();
        boolean warnings = configuration.getCompilerConfiguration().warnings();
        int factor = configuration.getCompilerConfiguration().factor();
        targets.clear();
        int size = sources.size();
        for (int i = targets.size(); i < size; ++i) {
            targets.add(null);
        }
        HashSet<String> processed = new HashSet<String>();
        for (int i = sources.size() - 1; i >= 0; --i) {
            boolean okay;
            Source s = sources.get(i);
            CompilationUnit u = s != null ? s.getCompilationUnit() : null;
            int w = CompilerAPI.getCompilationUnitWorkflow(s);
            if (w == 0 || (w & 2) == 0 || (w & 4) == 0) {
                boolean bl = okay = s.getLogger() == null || s.getLogger().errorCount() == 0;
                if (!okay) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            if ((w & 8) == 0) {
                boolean bl = okay = (s.getLogger() == null || s.getLogger().errorCount() == 0) && CompilerAPI.check(u, 1, u.inheritance, symbolTable, 8);
                if (!okay) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            if ((w & 0x10) == 0) {
                boolean bl = okay = s.getLogger() == null || s.getLogger().errorCount() == 0;
                if (!okay) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            if ((w & 0x20) == 0) {
                okay = (s.getLogger() == null || s.getLogger().errorCount() == 0) && CompilerAPI.checkInheritance(u, u.inheritance, symbolTable, 32, processed) && CompilerAPI.check(u, 2, u.namespaces, symbolTable, 32);
                processed.clear();
                if (!okay) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            if ((w & 0x40) == 0) {
                okay = (s.getLogger() == null || s.getLogger().errorCount() == 0) && CompilerAPI.checkInheritance(u, u.inheritance, symbolTable, 64, processed) && CompilerAPI.check(u, 3, u.types, symbolTable, 32) && CompilerAPI.check(u, 2, u.namespaces, symbolTable, 64) && (!strict && !warnings || CompilerAPI.check(u, 4, u.expressions, symbolTable, 32));
                processed.clear();
                if (!okay) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            if ((w & 0x80) == 0) {
                okay = (s.getLogger() == null || s.getLogger().errorCount() == 0) && CompilerAPI.checkInheritance(u, u.inheritance, symbolTable, 128, processed) && CompilerAPI.check(u, 2, u.namespaces, symbolTable, 128) && CompilerAPI.checkDeep(u, 3, u.types, symbolTable, processed) && (!strict && !warnings || CompilerAPI.checkDeep(u, 4, u.expressions, symbolTable, processed));
                processed.clear();
                if (!okay) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            if ((w & 0x2000) == 0) {
                if (s.getLogger() != null && s.getLogger().errorCount() != 0) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            isDone = s.getLogger() == null || s.getLogger().errorCount() == 0 ? isDone + 1 : isDone;
        }
        if (count > 0) {
            int w;
            Source s;
            int i;
            boolean[] bits = new boolean[targets.size()];
            double maxBudget = 100.0;
            double budget = 0.0;
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = targets.get(i);
                if (s == null || (w = CompilerAPI.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) == 0 || (w & 0x10) == 0 || (w & 0x20) == 0 || (w & 0x40) == 0 || (w & 0x80) == 0 || (w & 0x2000) != 0) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = targets.get(i);
                if (s == null || (w = CompilerAPI.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) == 0 || (w & 0x10) == 0 || (w & 0x20) == 0 || (w & 0x40) != 0) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = targets.get(i);
                if (s == null || (w = CompilerAPI.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) == 0 || (w & 0x10) == 0 || (w & 0x20) == 0 || (w & 0x40) == 0 || (w & 0x80) != 0) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = targets.get(i);
                if (s == null || (w = CompilerAPI.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) == 0 || (w & 0x10) != 0) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = targets.get(i);
                if (s == null || (w = CompilerAPI.getCompilationUnitWorkflow(s)) != 0) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = targets.get(i);
                if (s == null || (w = CompilerAPI.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) == 0 || (w & 0x10) == 0 || (w & 0x20) != 0 || !"application/x-actionscript-bytecode".equals(s.getMimeType())) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = targets.get(i);
                if (s == null || (w = CompilerAPI.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) != 0 || !"application/x-actionscript-bytecode".equals(s.getMimeType())) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = targets.get(i);
                if (s == null || (w = CompilerAPI.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) != 0 || !"application/x-actionscript-bytecode".equals(s.getMimeType())) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = targets.get(i);
                if (s == null || (w = CompilerAPI.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) == 0 || (w & 0x10) == 0 || (w & 0x20) != 0 || "application/x-actionscript-bytecode".equals(s.getMimeType())) continue;
                budget += CompilerAPI.calculateBudget(s, factor);
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = targets.get(i);
                if (s == null || (w = CompilerAPI.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) != 0 || "application/x-actionscript-bytecode".equals(s.getMimeType())) continue;
                budget += CompilerAPI.calculateBudget(s, factor);
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = targets.get(i);
                if (s == null || (w = CompilerAPI.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) != 0 || "application/x-actionscript-bytecode".equals(s.getMimeType())) continue;
                budget += CompilerAPI.calculateBudget(s, factor);
                bits[i] = true;
            }
            count = 0;
            int size2 = bits.length;
            for (i = 0; i < size2; ++i) {
                if (!bits[i]) {
                    targets.set(i, null);
                    continue;
                }
                ++count;
            }
        } else if (count == 0 && isDone == sources.size()) {
            targets.clear();
            targets.addAll(sources);
            count = targets.size();
        } else if (count == 0 && isDone != sources.size()) {
            CompilerAPI.detectCycles(sources, igraph);
            assert (ThreadLocalToolkit.errorCount() > 0) : "There is a problem in one of the compiler algorithms. Please use --conservative=true to compile. Also, please file a bug report.";
        }
        return count;
    }

    private static double calculateBudget(Source s, int factor) {
        String mimeType = s.getMimeType();
        if ("text/mxml".equals(mimeType)) {
            return (double)s.size() * 4.5 / (double)factor;
        }
        if ("text/as".equals(mimeType)) {
            return s.size() / (long)factor;
        }
        return 0.0;
    }

    private static int calculateCheckBitsMask(int type_class, int workflow) {
        assert (1 == type_class || 2 == type_class || 3 == type_class || 4 == type_class);
        int type_class_base_shift = (type_class - 1) * 4;
        int workflow_offset = 0;
        switch (workflow) {
            case 8: {
                workflow_offset = 0;
                break;
            }
            case 32: {
                workflow_offset = 1;
                break;
            }
            case 64: {
                workflow_offset = 2;
                break;
            }
            case 128: {
                workflow_offset = 3;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return 1 << type_class_base_shift + workflow_offset;
    }

    private static boolean check(CompilationUnit unit, int typesId, Set<Name> types, SymbolTable symbolTable, int workflow) {
        int mask = CompilerAPI.calculateCheckBitsMask(typesId, workflow);
        if ((unit.checkBits & mask) > 0) {
            return true;
        }
        for (Name name : types) {
            QName qName;
            Source s;
            CompilationUnit u;
            if (!(name instanceof QName) || unit == (u = (s = symbolTable.findSourceByQName(qName = (QName)name)) != null ? s.getCompilationUnit() : null)) continue;
            if (u == null || (u.getWorkflow() & workflow) == 0) {
                return false;
            }
            if (u == null || u.typeInfo == null) {
                return false;
            }
            if (s.getLogger() == null || s.getLogger().errorCount() <= 0) continue;
            return false;
        }
        unit.checkBits |= mask;
        return true;
    }

    private static boolean checkInheritance(CompilationUnit unit, Set<Name> types, SymbolTable symbolTable, int workflow, Set<String> processed) {
        processed.add(unit.getSource().getName());
        if (!CompilerAPI.check(unit, 1, types, symbolTable, workflow)) {
            return false;
        }
        for (Name name : types) {
            CompilationUnit u;
            if (!(name instanceof QName)) continue;
            QName qName = (QName)name;
            Source s = symbolTable.findSourceByQName(qName);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
            if (u == null) {
                return false;
            }
            if (unit == u || processed.contains(s.getName()) || CompilerAPI.checkInheritance(u, u.inheritance, symbolTable, workflow, processed)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkDeep(CompilationUnit unit, int typesId, Set<Name> types, SymbolTable symbolTable, Set<String> processed) {
        int mask = CompilerAPI.calculateCheckBitsMask(typesId, 64);
        if ((unit.checkBits & mask) > 0) {
            return true;
        }
        processed.add(unit.getSource().getName());
        if (!CompilerAPI.check(unit, typesId, types, symbolTable, 64)) {
            return false;
        }
        for (Name name : types) {
            CompilationUnit u;
            if (!(name instanceof QName)) continue;
            QName qName = (QName)name;
            Source s = symbolTable.findSourceByQName(qName);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
            if (u == null) {
                return false;
            }
            if (unit == u || processed.contains(s.getName())) continue;
            if (!CompilerAPI.checkDeep(u, 1, u.inheritance, symbolTable, processed)) {
                return false;
            }
            if (!CompilerAPI.checkDeep(u, 3, u.types, symbolTable, processed)) {
                return false;
            }
            if (CompilerAPI.checkDeep(u, 4, u.expressions, symbolTable, processed)) continue;
            return false;
        }
        unit.checkBits |= mask;
        return true;
    }

    private static int getCompilationUnitWorkflow(Source s) {
        if (!s.isPreprocessed()) {
            return 0;
        }
        if (s.getCompilationUnit() == null || (s.getCompilationUnit().getWorkflow() & 4) == 0) {
            return 2;
        }
        return s.getCompilationUnit().getWorkflow();
    }

    private static void batch(List<Source> sources, List<CompilationUnit> units, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SymbolTable symbolTable, SubCompiler[] compilers, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration, boolean useFileSpec) throws CompilerException {
        do {
            units.clear();
            if (useFileSpec || configuration.getCompilerConfiguration().useConservativeAlgorithm()) {
                CompilerAPI.batch1(sources, units, igraph, dgraph, symbolTable, compilers, sourceList, sourcePath, resources, swcContext, configuration);
            } else {
                CompilerAPI.batch2(sources, units, igraph, dgraph, symbolTable, compilers, sourceList, sourcePath, resources, swcContext, configuration);
            }
            symbolTable.perCompileData.reuse();
            if (swcContext.errorLocations().size() > 0) {
                Iterator<String> it = swcContext.errorLocations().iterator();
                while (it.hasNext()) {
                    ThreadLocalToolkit.log(new IncompatibleSWCArchive(it.next()));
                }
            }
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            throw new CompilerException();
        } while (!CompilerAPI.forcedToStop() && CompilerAPI.unitsReset(units) > 0);
    }

    public static List<CompilationUnit> compileSwc(FileSpec fileSpec, Collection<Source> classes, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, CompilerSwcContext swcContext, SymbolTable symbolTable, NameMappings nameMappings, Configuration configuration, SubCompiler[] compilers, PreLink preLink, Map licenseMap) throws CompilerException {
        return CompilerAPI.compile(fileSpec, null, classes, sourcePath, resources, bundlePath, swcContext, symbolTable, nameMappings, configuration, compilers, preLink, licenseMap, new ArrayList<Source>());
    }

    public static List<CompilationUnit> compile(FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, CompilerSwcContext swcContext, SymbolTable symbolTable, NameMappings nameMappings, Configuration configuration, SubCompiler[] compilers, PreLink preLink, Map licenseMap) throws CompilerException {
        return CompilerAPI.compile(fileSpec, sourceList, null, sourcePath, resources, bundlePath, swcContext, symbolTable, nameMappings, configuration, compilers, preLink, licenseMap, new ArrayList<Source>());
    }

    public static List<CompilationUnit> compile(FileSpec fileSpec, SourceList sourceList, Collection<Source> classes, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, CompilerSwcContext swcContext, NameMappings nameMappings, Configuration configuration, SubCompiler[] compilers, PreLink preLink, Map licenseMap, List<Source> sources) throws CompilerException {
        return CompilerAPI.compile(fileSpec, sourceList, classes, sourcePath, resources, bundlePath, swcContext, new SymbolTable(configuration), nameMappings, configuration, compilers, preLink, licenseMap, sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CompilationUnit> compile(FileSpec fileSpec, SourceList sourceList, Collection<Source> classes, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, CompilerSwcContext swcContext, SymbolTable symbolTable, NameMappings nameMappings, Configuration configuration, SubCompiler[] compilers, PreLink preLink, Map licenseMap, List<Source> sources) throws CompilerException {
        ProgressMeter meter;
        Set<IPreCompileExtension> extensions = ExtensionManager.getPreCompileExtensions(configuration.getCompilerConfiguration().getExtensionsConfiguration().getExtensionMappings());
        for (IPreCompileExtension extension : extensions) {
            extension.run(fileSpec, sourceList, classes, sourcePath, resources, bundlePath, swcContext, new SymbolTable(configuration), configuration, compilers, preLink, licenseMap, sources);
        }
        if (configuration.getCompilerConfiguration().getJavaProfilerClass() != null) {
            ProfileController.setProfiler((String)configuration.getCompilerConfiguration().getJavaProfilerClass());
            ProfileController.startAllocationRecording();
            ProfileController.startCPUProfiling((boolean)true);
        }
        if (sourcePath != null) {
            ThreadLocalToolkit.getPathResolver().addSinglePathResolver(sourcePath);
            sourcePath.displayWarnings();
        }
        ThreadLocalToolkit.setCompatibilityVersion(configuration.getCompatibilityVersion());
        StandardDefs standardDefs = StandardDefs.getStandardDefs(configuration.getFramework());
        ThreadLocalToolkit.setStandardDefs(standardDefs);
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().benchmark2(l10n.getLocalizedTextString((Object)new CompileTime("Start")), true);
        }
        if ((meter = ThreadLocalToolkit.getProgressMeter()) != null) {
            meter.start();
        }
        ArrayList<CompilationUnit> units = new ArrayList<CompilationUnit>();
        DependencyGraph<CompilationUnit> igraph = new DependencyGraph<CompilationUnit>();
        DependencyGraph<Source> dgraph = null;
        boolean useFileSpec = false;
        if (fileSpec != null) {
            sources.addAll(fileSpec.retrieveSources());
            boolean bl = useFileSpec = sources.size() > 0;
        }
        if (sourceList != null) {
            sources.addAll(sourceList.retrieveSources());
        }
        if (classes != null) {
            for (Source source : classes) {
                if (sources.contains(source)) continue;
                sources.add(source);
            }
            useFileSpec = useFileSpec || classes.size() > 0;
        }
        CompilerAPI.addVerticesToGraphs(sources, igraph, dgraph);
        if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().benchmark2(l10n.getLocalizedTextString((Object)new CompileTime("addVerticesToGraphs")), true);
        }
        try {
            ArrayList<CompilationUnit> i$;
            CompilerAPI.getCommonBuiltinClasses(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext);
            if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark2(l10n.getLocalizedTextString((Object)new CompileTime("GetCommonBuiltInClassesTime")), true);
            }
            CompilerAPI.batch(sources, units, igraph, dgraph, symbolTable, compilers, sourceList, sourcePath, resources, swcContext, configuration, useFileSpec);
            if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark2(l10n.getLocalizedTextString((Object)new CompileTime("batch")));
            }
            CompilerAPI.getMessagingClasses(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration);
            if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark2(l10n.getLocalizedTextString((Object)new CompileTime("getMessagingClasses")), true);
            }
            CompilerAPI.getIncludeClasses(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration);
            if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark2(l10n.getLocalizedTextString((Object)new CompileTime("GetIncludeClassesTime")), true);
            }
            CompilerAPI.getIncludeResources(sources, igraph, dgraph, bundlePath, symbolTable, swcContext, configuration);
            if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark2(l10n.getLocalizedTextString((Object)new CompileTime("GetIncludeResourcesTime")), true);
            }
            if (ThreadLocalToolkit.errorCount() > 0) {
                throw new CompilerException();
            }
            if (CompilerAPI.forcedToStop()) {
                i$ = units;
                return i$;
            }
            CompilerAPI.batch(sources, units, igraph, dgraph, symbolTable, compilers, sourceList, sourcePath, resources, swcContext, configuration, useFileSpec);
            if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark2(l10n.getLocalizedTextString((Object)new CompileTime("batch")), true);
            }
            if (CompilerAPI.forcedToStop()) {
                i$ = units;
                return i$;
            }
            int count = 0;
            if (preLink != null) {
                boolean runPrelink = true;
                while (runPrelink && count++ < 1000) {
                    int sourceCount = sources.size();
                    preLink.run(sources, units, fileSpec, sourceList, sourcePath, bundlePath, resources, symbolTable, swcContext, nameMappings, configuration);
                    if (preLink instanceof CompcPreLink || sources.size() <= sourceCount) {
                        runPrelink = false;
                        preLink.postRun(sources, units, resources, symbolTable, swcContext, nameMappings, configuration);
                    }
                    if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
                        ThreadLocalToolkit.getBenchmark().benchmark2(l10n.getLocalizedTextString((Object)new CompileTime("PreLinkTime")), true);
                    }
                    if (ThreadLocalToolkit.errorCount() > 0) {
                        throw new CompilerException();
                    }
                    CompilerAPI.batch(sources, units, igraph, dgraph, symbolTable, compilers, sourceList, sourcePath, resources, swcContext, configuration, useFileSpec);
                    if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
                        ThreadLocalToolkit.getBenchmark().benchmark2(l10n.getLocalizedTextString((Object)new CompileTime("batch")), true);
                    }
                    if (!CompilerAPI.forcedToStop()) continue;
                    ArrayList<CompilationUnit> arrayList = units;
                    return arrayList;
                }
            }
            count = 0;
            while (++count < 1000) {
                int numSources = sources.size();
                CompilerAPI.getExtraSources(sources, igraph, dgraph, sourceList, sourcePath, resources, bundlePath, symbolTable, swcContext, configuration, licenseMap);
                if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
                    ThreadLocalToolkit.getBenchmark().benchmark2(l10n.getLocalizedTextString((Object)new CompileTime("GetExtraSourcesTime")), true);
                }
                if (ThreadLocalToolkit.errorCount() > 0) {
                    throw new CompilerException();
                }
                CompilerAPI.batch(sources, units, igraph, dgraph, symbolTable, compilers, sourceList, sourcePath, resources, swcContext, configuration, useFileSpec);
                if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
                    ThreadLocalToolkit.getBenchmark().benchmark2(l10n.getLocalizedTextString((Object)new CompileTime("batch")), true);
                }
                if (sources.size() == numSources) break;
                if (!CompilerAPI.forcedToStop()) continue;
                ArrayList<CompilationUnit> arrayList = units;
                return arrayList;
            }
            CompilerAPI.checkResourceBundles(sources, symbolTable);
            assert (count < 1000);
        }
        finally {
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new OutputTime(sources.size())));
            }
            swcContext.close();
            symbolTable.cleanClassTable();
            symbolTable.adjustProgress();
            if (meter != null) {
                meter.end();
            }
        }
        return units;
    }

    private static void getCommonBuiltinClasses(List<Source> sources, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext) {
        int size = multiNames.length;
        for (int i = 0; i < size; ++i) {
            QName qName = CompilerAPI.resolveMultiName("builtin", multiNames[i], sources, sourceList, sourcePath, resources, swcContext, symbolTable);
            if (qName == null) continue;
            Source tailSource = symbolTable.findSourceByQName(qName);
            CompilerAPI.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
        }
    }

    private static void getMessagingClasses(List<Source> sources, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        ServicesDependencies services = configuration.getCompilerConfiguration().getServicesDependencies();
        if (services != null) {
            for (String clientType : services.getChannelClasses()) {
                if (clientType == null) continue;
                QName qName = CompilerAPI.resolveMultiName("messaging", new MultiName(NameFormatter.toColon(clientType)), sources, sourceList, sourcePath, resources, swcContext, symbolTable);
                if (qName == null) {
                    ThreadLocalToolkit.log((CompilerMessage)new ChannelDefinitionNotFound(clientType), configuration.getCompilerConfiguration().getServices().getNameForReporting());
                    continue;
                }
                Source s = symbolTable.findSourceByQName(qName);
                CompilerAPI.addVertexToGraphs(s, s.getCompilationUnit(), igraph, dgraph);
            }
        }
    }

    private static int unitsReset(List<CompilationUnit> units) {
        int resetCount = 0;
        int n = units.size();
        for (int i = 0; i < n; ++i) {
            CompilationUnit unit = units.get(i);
            Source source = unit.getSource();
            if (!source.isInternal() && !source.isCompiled()) {
                unit.reset();
                ++resetCount;
                continue;
            }
            if (source.isInternal()) continue;
            unit.checkBits = 0;
        }
        return resetCount;
    }

    private static void reportObsoletedSwcSources(CompilerSwcContext swcContext, LocalizationManager l10n, Logger logger) {
        for (Map.Entry<Source, String> entry : swcContext.getObsoletedSources().entrySet()) {
            Source obsoletedSource = entry.getKey();
            String obsoletedSourceName = obsoletedSource.getName();
            String newLocation = entry.getValue();
            String message = l10n.getLocalizedTextString((Object)new SwcDefinitionObsoleted(newLocation));
            logger.needsCompilation(obsoletedSourceName, message);
        }
    }

    private static void reportShadowedSwcSources(Set<Source> swcSources, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, LocalizationManager l10n, Logger logger, Set<Source> sources) {
        for (Source source : swcSources) {
            CompilationUnit compilationUnit = source.getCompilationUnit();
            for (QName qName : compilationUnit.topLevelDefinitions) {
                Source newSource = null;
                if (sourceList != null) {
                    newSource = sourceList.findSource(qName.getNamespace(), qName.getLocalPart());
                }
                if (newSource == null && sourcePath != null) {
                    try {
                        newSource = sourcePath.findSource(qName.getNamespace(), qName.getLocalPart());
                    }
                    catch (CompilerException compilerException) {
                        // empty catch block
                    }
                }
                if (newSource == null && resources != null) {
                    newSource = resources.findSource(qName.getNamespace(), qName.getLocalPart());
                }
                if (newSource == null || newSource == source || newSource.getLastModified() == source.getLastModified()) continue;
                String message = l10n.getLocalizedTextString((Object)new SwcDefinitionObsoleted(newSource.getName()));
                logger.needsCompilation(source.getName(), message);
                sources.remove(source);
            }
        }
    }

    public static int validateCompilationUnits(FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceBundlePath bundlePath, ResourceContainer resources, CompilerSwcContext swcContext, ContextStatics perCompileData, Configuration configuration) {
        return CompilerAPI.validateCompilationUnits(fileSpec, sourceList, sourcePath, bundlePath, resources, swcContext, null, perCompileData, configuration);
    }

    public static int validateCompilationUnits(FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceBundlePath bundlePath, ResourceContainer resources, CompilerSwcContext swcContext, Map<String, Source> includedClasses, ContextStatics perCompileData, Configuration configuration) {
        int updateCount;
        QName qName;
        SourcePathBase sp;
        Source s;
        CompilationUnit u;
        CompilationUnit u2;
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        boolean strict = configuration.getCompilerConfiguration().strict();
        HashMap<String, Source> updated = new HashMap<String, Source>();
        HashMap<String, Source> updatedWithStableSignature = new HashMap<String, Source>();
        HashMap<String, Source> affected = new HashMap<String, Source>();
        HashMap<QName, Source> deleted = new HashMap<QName, Source>();
        HashMap<String, String> reasons = new HashMap<String, String>();
        HashMap<QName, Source> qNames = new HashMap<QName, Source>();
        HashSet<String> includeUpdated = new HashSet<String>();
        HashSet<String> resourceDelegates = new HashSet<String>();
        HashSet<String> namespaces = new HashSet<String>();
        HashMap<QName, Map<String, Source>> dependents = new HashMap<QName, Map<String, Source>>();
        Set<Source> swcSources = swcContext.cachedSources();
        Context ascContext = null;
        if (perCompileData != null) {
            ascContext = new Context(perCompileData);
        }
        HashSet<Source> sources = new HashSet<Source>();
        sources.addAll(swcSources);
        if (fileSpec != null) {
            sources.addAll(fileSpec.sources());
        }
        if (sourceList != null) {
            sources.addAll(sourceList.sources().values());
        }
        if (sourcePath != null) {
            sources.addAll(sourcePath.sources().values());
        }
        if (bundlePath != null) {
            sources.addAll(bundlePath.sources().values());
        }
        if (includedClasses != null) {
            sources.addAll(includedClasses.values());
        }
        for (Source source : sources) {
            if (source.getName() == null || (u2 = source.getCompilationUnit()) == null) continue;
            Iterator<VirtualFile> j = source.getUpdatedFileIncludes();
            while (j != null && j.hasNext()) {
                VirtualFile f = j.next();
                includeUpdated.add(f.getNameForReporting());
            }
            for (QName qName2 : u2.topLevelDefinitions) {
                qNames.put(qName2, source);
                dependents.put(qName2, new HashMap());
            }
        }
        for (Source source : resources.sources().values()) {
            if (source.getName() == null || (u2 = source.getCompilationUnit()) == null) continue;
            for (QName qName2 : u2.topLevelDefinitions) {
                qNames.put(qName2, source);
            }
        }
        for (Source source : sources) {
            if (source == null || (u2 = source.getCompilationUnit()) == null) continue;
            CompilerAPI.addDependents(source, u2.inheritance, dependents);
            CompilerAPI.addDependents(source, u2.namespaces, dependents);
            CompilerAPI.addDependents(source, u2.types, dependents);
            CompilerAPI.addDependents(source, u2.expressions, dependents);
        }
        Logger logger = ThreadLocalToolkit.getLogger();
        for (Source source : resources.sources().values()) {
            u = source.getCompilationUnit();
            if (!source.hasError() && (u == null || u.isDone() || u.hasTypeInfo) && !source.isUpdated() && (u == null || !u.hasAssets() || !u.getAssets().isUpdated())) continue;
            resourceDelegates.add(source.getNameForReporting());
            source.removeCompilationUnit();
        }
        CompilerAPI.reportObsoletedSwcSources(swcContext, l10n, logger);
        CompilerAPI.reportShadowedSwcSources(swcSources, sourceList, sourcePath, resources, l10n, logger, sources);
        Iterator iterator = sources.iterator();
        while (iterator.hasNext()) {
            s = (Source)iterator.next();
            u = s.getCompilationUnit();
            if (s.hasError() || !s.isInternal() && u != null && !u.isDone() && !u.hasTypeInfo || resourceDelegates.contains(s.getName())) {
                affected.put(s.getName(), s);
                reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new NotFullyCompiled()));
                iterator.remove();
                continue;
            }
            if (!s.exists()) {
                updated.put(s.getName(), s);
                reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new SourceNoLongerExists()));
                if (u != null) {
                    for (QName qName3 : u.topLevelDefinitions) {
                        namespaces.add(qName3.toString());
                        deleted.put(qName3, s);
                    }
                }
                iterator.remove();
                continue;
            }
            if (s.isUpdated()) {
                Long persistedCRC;
                boolean signatureIsStable = false;
                if (u != null && !configuration.getCompilerConfiguration().getDisableIncrementalOptimizations() && !s.getMimeType().equals("text/mxml") && (persistedCRC = u.getSignatureChecksum()) != null) {
                    assert (s.getMimeType().equals("application/x-actionscript-bytecode") || s.getMimeType().equals("text/as"));
                    Long currentCRC = CompilerAPI.computeSignatureChecksum(configuration, s);
                    boolean bl = signatureIsStable = currentCRC != null && persistedCRC.compareTo(currentCRC) == 0;
                }
                if (signatureIsStable) {
                    updatedWithStableSignature.put(s.getName(), s);
                } else {
                    updated.put(s.getName(), s);
                }
                reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new SourceFileUpdated()));
                iterator.remove();
                continue;
            }
            if (u == null || !u.hasAssets() || !u.getAssets().isUpdated()) continue;
            updated.put(s.getName(), s);
            reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new AssetUpdated()));
            iterator.remove();
        }
        for (Source source : deleted.values()) {
            CompilationUnit u3;
            if (!source.isSourcePathOwner()) continue;
            sp = (SourcePath)source.getOwner();
            sp.removeSource(source);
            if (ascContext == null || (u3 = source.getCompilationUnit()) == null) continue;
            for (QName defName : u3.topLevelDefinitions) {
                ascContext.removeUserDefined(defName.toString());
            }
        }
        iterator = sources.iterator();
        while (iterator.hasNext()) {
            s = (Source)iterator.next();
            if (!s.isSourcePathOwner() && !s.isResourceBundlePathOwner() || (sp = (SourcePathBase)s.getOwner()).checkPreference(s)) continue;
            affected.put(s.getName(), s);
            reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new NotSourcePathFirstPreference()));
            iterator.remove();
        }
        iterator = sources.iterator();
        block14: while (iterator.hasNext()) {
            s = (Source)iterator.next();
            u = s.getCompilationUnit();
            if (u == null) continue;
            HashSet<Name> dependencies = new HashSet<Name>();
            dependencies.addAll(u.inheritance);
            dependencies.addAll(u.namespaces);
            dependencies.addAll(u.expressions);
            dependencies.addAll(u.types);
            dependencies.add(new QName("", "Namespace"));
            boolean valid = true;
            for (Name dependentName : dependencies) {
                qName = CompilerAPI.toQName(dependentName);
                if (qName != null) {
                    Source dependentSource = (Source)qNames.get(qName);
                    if (dependentSource != null) {
                        CompilationUnit dependentCompilationUnit = dependentSource.getCompilationUnit();
                        if (u.hasTypeInfo && !dependentCompilationUnit.hasTypeInfo && !dependentSource.isInternal()) {
                            reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new DependencyNotCached(dependentName.toString())));
                            valid = false;
                        } else if (!updatedWithStableSignature.containsKey(dependentSource.getName()) && ascContext != null && u.hasTypeInfo && dependentCompilationUnit.hasTypeInfo && CompilerAPI.referencesDifferentSlots(ascContext, u.typeInfo, qName, dependentCompilationUnit.typeInfo)) {
                            reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new DependencyUpdated(dependentName.toString())));
                            valid = false;
                        }
                    } else if (u.hasTypeInfo) {
                        reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new DependencyNotCached(dependentName.toString())));
                        valid = false;
                    }
                }
                if (valid) continue;
                affected.put(s.getName(), s);
                iterator.remove();
                break;
            }
            if (swcSources.contains(s)) continue;
            valid = valid && strict;
            Iterator<String> k = u.importPackageStatements.iterator();
            while (valid && k.hasNext()) {
                String packageName = k.next();
                if (CompilerAPI.hasPackage(sourcePath, swcContext, packageName)) continue;
                affected.put(s.getName(), s);
                reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new InvalidImportStatement(packageName)));
                iterator.remove();
                namespaces.add(packageName);
                valid = false;
                break;
            }
            k = u.importDefinitionStatements.iterator();
            while (valid && k.hasNext()) {
                QName defName = (QName)((Object)k.next());
                if (CompilerAPI.hasDefinition(sourcePath, swcContext, defName)) continue;
                affected.put(s.getName(), s);
                reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new InvalidImportStatement(defName.toString())));
                iterator.remove();
                namespaces.add(defName.toString());
                valid = false;
                continue block14;
            }
        }
        if (strict) {
            HashMap<String, Source> updatedAndAffected = new HashMap<String, Source>(updated);
            updatedAndAffected.putAll(affected);
            for (Source source : updatedAndAffected.values()) {
                CompilerAPI.dependentFileModified(source, dependents, updated, affected, reasons, sources);
            }
        }
        Iterator i = includeUpdated.iterator();
        while (i.hasNext()) {
            ThreadLocalToolkit.getLogger().includedFileUpdated((String)i.next());
        }
        int affectedCount = affected.size();
        CompilerAPI.logReasonAndRemoveCompilationUnit(affected, reasons, includeUpdated, swcContext);
        CompilerAPI.logReasonAndRemoveCompilationUnit(updated, reasons, includeUpdated, swcContext);
        CompilerAPI.logReasonAndRemoveCompilationUnit(updatedWithStableSignature, reasons, includeUpdated, swcContext);
        for (Source s2 : resources.sources().values()) {
            String name;
            if (s2 == null || !affected.containsKey(name = s2.getNameForReporting()) && !updated.containsKey(name)) continue;
            s2.removeCompilationUnit();
        }
        affected.clear();
        Iterator iterator2 = sources.iterator();
        while (iterator2.hasNext()) {
            Source s2;
            s2 = (Source)iterator2.next();
            CompilationUnit u4 = s2.getCompilationUnit();
            if (u4 == null) continue;
            for (Map.Entry<MultiName, QName> entry : u4.inheritanceHistory.entrySet()) {
                MultiName multiName = entry.getKey();
                qName = entry.getValue();
                try {
                    if (CompilerAPI.validateMultiName(multiName, qName, sourcePath)) continue;
                    affected.put(s2.getName(), s2);
                    reasons.put(s2.getName(), l10n.getLocalizedTextString((Object)new MultiNameMeaningChanged(multiName, qName)));
                    iterator2.remove();
                }
                catch (CompilerException ex) {
                    affected.put(s2.getName(), s2);
                    reasons.put(s2.getName(), ex.getMessage());
                    iterator2.remove();
                }
            }
        }
        affectedCount += affected.size();
        CompilerAPI.logReasonAndRemoveCompilationUnit(affected, reasons, includeUpdated, swcContext);
        for (Source s2 : resources.sources().values()) {
            String name;
            if (s2 == null || !affected.containsKey(name = s2.getNameForReporting())) continue;
            s2.removeCompilationUnit();
        }
        resources.refresh();
        if (perCompileData != null) {
            for (String ns : namespaces) {
                perCompileData.removeNamespace(ns);
            }
        }
        if ((updateCount = updated.size() + updatedWithStableSignature.size()) + affectedCount > 0) {
            ThreadLocalToolkit.log(new FilesChangedAffected(updateCount, affectedCount));
        }
        CompilerAPI.seedUserDefined(sources, ascContext, perCompileData);
        if (configuration.getBenchmarkCompilerDetails() > 0 && ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().benchmark2("validateCompilationUnits");
        }
        int count = updateCount + affectedCount;
        return count;
    }

    private static void addDependents(Source source, Set<Name> dependencies, Map<QName, Map<String, Source>> dependents) {
        for (Name name : dependencies) {
            Map<String, Source> sourceMap;
            QName qName = CompilerAPI.toQName(name);
            if (qName == null || (sourceMap = dependents.get(qName)) == null) continue;
            sourceMap.put(source.getName(), source);
        }
    }

    private static QName toQName(Name name) {
        MultiName multiName;
        QName result = null;
        if (name instanceof QName) {
            result = (QName)name;
        } else if (name instanceof MultiName && (multiName = (MultiName)name).getNumQNames() == 1) {
            result = multiName.getQName(0);
        }
        return result;
    }

    private static void dependentFileModified(Source affectedSource, Map<QName, Map<String, Source>> dependents, Map<String, Source> updated, Map<String, Source> affected, Map<String, String> reasons, Set<Source> sources) {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        CompilationUnit compilationUnit = affectedSource.getCompilationUnit();
        if (compilationUnit != null) {
            for (QName qName : compilationUnit.topLevelDefinitions) {
                if (!dependents.containsKey(qName)) continue;
                for (Map.Entry<String, Source> dependentEntry : dependents.get(qName).entrySet()) {
                    if (updated.containsKey(dependentEntry.getKey()) || affected.containsKey(dependentEntry.getKey())) continue;
                    affected.put(dependentEntry.getKey(), dependentEntry.getValue());
                    reasons.put(dependentEntry.getKey(), l10n.getLocalizedTextString((Object)new DependentFileModified(affectedSource.getName())));
                    sources.remove(dependentEntry.getValue());
                    CompilerAPI.dependentFileModified(dependentEntry.getValue(), dependents, updated, affected, reasons, sources);
                }
            }
        }
    }

    private static void logReasonAndRemoveCompilationUnit(Map<String, Source> map, Map<String, String> reasons, Set<String> includeUpdated, CompilerSwcContext compilerSwcContext) {
        Logger logger = ThreadLocalToolkit.getLogger();
        for (Map.Entry<String, Source> entry : map.entrySet()) {
            String name = entry.getKey();
            Source s = entry.getValue();
            Iterator<VirtualFile> j = s.getFileIncludes();
            while (j.hasNext()) {
                VirtualFile f = j.next();
                if (includeUpdated.contains(f.getNameForReporting())) continue;
                ThreadLocalToolkit.getLogger().includedFileAffected(f.getNameForReporting());
            }
            CompilationUnit compilationUnit = s.getCompilationUnit();
            if (compilationUnit != null) {
                for (QName topLevelDefinition : compilationUnit.topLevelDefinitions) {
                    CompilationUnit swcScriptCompilationUnit;
                    SwcScript swcScript = compilerSwcContext.getCachedScript(topLevelDefinition);
                    if (swcScript == null || (swcScriptCompilationUnit = swcScript.getCompilationUnit()) == null) continue;
                    swcScriptCompilationUnit.getSource().removeCompilationUnit();
                    swcScript.setCompilationUnit(null);
                }
            }
            s.removeCompilationUnit();
            logger.needsCompilation(s.getName(), reasons.get(s.getName()));
        }
    }

    private static boolean referencesDifferentSlots(Context ascContext, ObjectValue referencingTypeInfo, QName qName, ObjectValue referencedTypeInfo) {
        int referencedIndex;
        int referencingIndex;
        ObjectValue namespace;
        boolean result = false;
        int kind = -79;
        String localPart = qName.getLocalPart().intern();
        if (referencingTypeInfo.hasName(ascContext, kind, localPart, namespace = ascContext.getNamespace(qName.getNamespace().intern())) && referencedTypeInfo.hasName(ascContext, kind, localPart, namespace) && (referencingIndex = referencingTypeInfo.getSlotIndex(ascContext, kind, localPart, namespace)) != (referencedIndex = referencedTypeInfo.getSlotIndex(ascContext, kind, localPart, namespace))) {
            Slot referencingSlot = referencingTypeInfo.getSlot(ascContext, referencingIndex);
            Slot referencedSlot = referencedTypeInfo.getSlot(ascContext, referencedIndex);
            if (referencingSlot instanceof VariableSlot && referencedSlot instanceof VariableSlot && referencingSlot.getValue() != referencedSlot.getValue()) {
                result = true;
            }
        }
        return result;
    }

    private static void seedUserDefined(Set<Source> sources, Context ascContext, ContextStatics perCompileData) {
        for (Source s : sources) {
            CompilationUnit u = s.getCompilationUnit();
            if (u == null || !u.hasTypeInfo) continue;
            ObjectValue frame = u.typeInfo;
            for (QName topLevelDefinition : u.topLevelDefinitions) {
                int implicitId;
                int slotId;
                Slot slot;
                ObjectValue namespace;
                String name = topLevelDefinition.getLocalPart().intern();
                if (!frame.hasName(ascContext, -79, name, namespace = ascContext.getNamespace(topLevelDefinition.getNamespace().intern())) || (slot = frame.getSlot(ascContext, slotId = frame.getSlotIndex(ascContext, -79, name, namespace))) == null || slotId == (implicitId = frame.getImplicitIndex(ascContext, slotId, -133)) || !(slot instanceof VariableSlot)) continue;
                Slot implicitSlot = frame.getSlot(ascContext, implicitId);
                TypeValue typeValue = implicitSlot.getType().getTypeValue();
                assert (topLevelDefinition.toString().equals(typeValue.name.toString())) : "topLevelDefinition = " + topLevelDefinition + ", typeValue = " + typeValue.name.toString();
                perCompileData.userDefined.put(typeValue.name.toString(), typeValue);
            }
        }
    }

    private static Long computeSignatureChecksum(Configuration configuration, Source source) {
        assert (configuration != null);
        As3Compiler asc = new As3Compiler(configuration.getCompilerConfiguration());
        asc.addCompilerExtension(SignatureExtension.getInstance());
        CompilationUnit u = null;
        ThreadLocalToolkit.setCompatibilityVersion(configuration.getCompatibilityVersion());
        Logger original = ThreadLocalToolkit.getLogger();
        ThreadLocalToolkit.setLogger(new LocalLogger(null));
        Source tmpSource = asc.preprocess(Source.newSource(source.getBackingFile(), source.getFileTime(), source.getPathRoot(), source.getRelativePath(), source.getShortName(), source.getOwner(), source.isInternal(), source.isRoot(), source.isDebuggable(), source.getFileIncludesSet(), source.getFileIncludeTimes(), source.getLogger()));
        String tmp = SignatureExtension.signatureDirectory;
        SignatureExtension.signatureDirectory = null;
        u = asc.parse1(tmpSource, new SymbolTable(configuration));
        SignatureExtension.signatureDirectory = tmp;
        ThreadLocalToolkit.setLogger(original);
        return u != null ? u.getSignatureChecksum() : null;
    }

    private static boolean validateMultiName(MultiName multiName, QName qName, SourcePath sourcePath) throws CompilerException {
        for (String ns : multiName.namespaceURI) {
            CompilationUnit u;
            String name = multiName.localPart;
            Source s = sourcePath != null ? sourcePath.findSource(ns, name) : null;
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
            if (u != null) {
                ns = u.topLevelDefinitions.first().getNamespace();
            }
            if (s == null || qName.getNamespace().equals(ns) && qName.getLocalPart().equals(name)) continue;
            return false;
        }
        return true;
    }

    private static void addVerticesToGraphs(List<Source> sources, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph) {
        int size = sources.size();
        for (int i = 0; i < size; ++i) {
            Source s = sources.get(i);
            if (s == null) continue;
            CompilerAPI.addVertexToGraphs(s, s.getCompilationUnit(), igraph, dgraph);
        }
    }

    private static void addVertexToGraphs(Source s, CompilationUnit u, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph) {
        String name = s.getName();
        if (u != null || igraph.get(name) == null) {
            igraph.put(name, u);
        }
        if (!igraph.containsVertex(name)) {
            igraph.addVertex(new Vertex(name));
        }
        if (dgraph != null) {
            dgraph.put(name, s);
            if (!dgraph.containsVertex(name)) {
                dgraph.addVertex(new Vertex(name));
            }
        }
    }

    private static boolean preprocess(List<Source> sources, SubCompiler[] compilers, int start, int end, boolean suppressWarnings) {
        boolean result = true;
        for (int i = start; i < end; ++i) {
            Source s = sources.get(i);
            if (s.isPreprocessed()) continue;
            if ((s = CompilerAPI.preprocess(s, compilers, suppressWarnings)) == null) {
                result = false;
            } else {
                sources.set(i, s);
            }
            if (CompilerAPI.tooManyErrors()) {
                ThreadLocalToolkit.log(new TooManyErrors());
                break;
            }
            if (!CompilerAPI.forcedToStop()) continue;
            ThreadLocalToolkit.log(new ForcedToStop());
            break;
        }
        return result;
    }

    public static void displayWarnings(List units) {
        int size;
        int n = size = units == null ? 0 : units.size();
        for (int i = 0; i < size; ++i) {
            Source s;
            CompilationUnit u = (CompilationUnit)units.get(i);
            Source source = s = u != null ? u.getSource() : null;
            if (s == null || s.getLogger() == null || s.getLogger().warningCount() <= 0 || s.getLogger().isConnected()) continue;
            s.getLogger().displayWarnings(ThreadLocalToolkit.getLogger());
        }
    }

    static Source preprocess(Source s, SubCompiler[] compilers, boolean suppressWarnings) {
        if (!s.isCompiled()) {
            SubCompiler c;
            if (s.getLogger() != null && s.getLogger().warningCount() > 0 && !s.getLogger().isConnected() && !suppressWarnings) {
                s.getLogger().displayWarnings(ThreadLocalToolkit.getLogger());
            }
            if ((c = CompilerAPI.getCompiler(s, compilers)) != null) {
                Logger original = ThreadLocalToolkit.getLogger();
                LocalLogger local = new LocalLogger(original, s);
                local.setLocalizationManager(ThreadLocalToolkit.getLocalizationManager());
                s.setLogger(local);
                ThreadLocalToolkit.setLogger(local);
                s = c.preprocess(s);
                ThreadLocalToolkit.setLogger(original);
                if (local.errorCount() > 0) {
                    if (s != null) {
                        s.disconnectLogger();
                    }
                    s = null;
                } else {
                    s.setPreprocessed();
                }
            } else {
                s = null;
            }
        }
        return s;
    }

    private static boolean parse1(List<Source> sources, List<CompilationUnit> units, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SubCompiler[] compilers, SymbolTable symbolTable, int start, int end) {
        boolean result = true;
        for (int i = start; i < end; ++i) {
            Source s = sources.get(i);
            CompilationUnit u = CompilerAPI.parse1(s, compilers, symbolTable);
            if (u == null) {
                result = false;
                s.disconnectLogger();
            }
            for (int j = units.size(); j < i + 1; ++j) {
                units.add(null);
            }
            units.set(i, u);
            CompilerAPI.addVertexToGraphs(s, u, igraph, dgraph);
            CompilerAPI.calculateProgress(sources, symbolTable);
            if (CompilerAPI.tooManyErrors()) {
                ThreadLocalToolkit.log(new TooManyErrors());
                break;
            }
            if (!CompilerAPI.forcedToStop()) continue;
            ThreadLocalToolkit.log(new ForcedToStop());
            break;
        }
        return result;
    }

    private static CompilationUnit parse1(Source s, SubCompiler[] compilers, SymbolTable symbolTable) {
        if (s.isCompiled()) {
            return s.getCompilationUnit();
        }
        CompilationUnit u = null;
        SubCompiler c = CompilerAPI.getCompiler(s, compilers);
        if (c != null) {
            Logger original = ThreadLocalToolkit.getLogger();
            LocalLogger local = s.getLogger();
            ThreadLocalToolkit.setLogger(local);
            u = c.parse1(s, symbolTable);
            ThreadLocalToolkit.setLogger(original);
            if (local.errorCount() == 0) {
                symbolTable.registerQNames(u.topLevelDefinitions, u.getSource());
                u.setState(1);
                u.setWorkflow(2);
                u.setWorkflow(4);
            }
        }
        return u;
    }

    private static boolean parse2(List<Source> sources, SubCompiler[] compilers, SymbolTable symbolTable, int start, int end) {
        boolean result = true;
        for (int i = start; i < end; ++i) {
            Source source = sources.get(i);
            CompilationUnit u = source.getCompilationUnit();
            if ((u.getWorkflow() & 8) != 0) continue;
            if (!CompilerAPI.parse2(u, compilers, symbolTable)) {
                result = false;
                u.getSource().disconnectLogger();
            }
            CompilerAPI.calculateProgress(sources, symbolTable);
            if (CompilerAPI.tooManyErrors()) {
                ThreadLocalToolkit.log(new TooManyErrors());
                break;
            }
            if (!CompilerAPI.forcedToStop()) continue;
            ThreadLocalToolkit.log(new ForcedToStop());
            break;
        }
        return result;
    }

    private static boolean parse2(List<Source> sources, SubCompiler[] compilers, SymbolTable symbolTable) {
        return CompilerAPI.parse2(sources, compilers, symbolTable, 0, sources.size());
    }

    private static boolean parse2(CompilationUnit u, SubCompiler[] compilers, SymbolTable symbolTable) {
        Source s = u.getSource();
        if (!s.isCompiled()) {
            SubCompiler c = CompilerAPI.getCompiler(s, compilers);
            if (c != null) {
                Logger original = ThreadLocalToolkit.getLogger();
                LocalLogger local = s.getLogger();
                ThreadLocalToolkit.setLogger(local);
                c.parse2(u, symbolTable);
                u.setWorkflow(8);
                ThreadLocalToolkit.setLogger(original);
                if (local.errorCount() > 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean analyze(List<Source> sources, SubCompiler[] compilers, SymbolTable symbolTable, int phase) {
        return CompilerAPI.analyze(sources, compilers, symbolTable, 0, sources.size(), phase);
    }

    private static boolean analyze(List<Source> sources, SubCompiler[] compilers, SymbolTable symbolTable, int start, int end, int phase) {
        boolean result = true;
        for (int i = start; i < end; ++i) {
            Source source = sources.get(i);
            CompilationUnit u = source.getCompilationUnit();
            if (phase == 1 && (u.getWorkflow() & 0x10) != 0 || phase == 2 && (u.getWorkflow() & 0x20) != 0 || phase == 3 && (u.getWorkflow() & 0x40) != 0 || phase == 4 && (u.getWorkflow() & 0x80) != 0) continue;
            if (!CompilerAPI.analyze(u, compilers, symbolTable, phase)) {
                result = false;
                u.getSource().disconnectLogger();
            }
            CompilerAPI.calculateProgress(sources, symbolTable);
            assert (u.getSource().getCompilationUnit() == u);
            if (CompilerAPI.tooManyErrors()) {
                ThreadLocalToolkit.log(new TooManyErrors());
                break;
            }
            if (!CompilerAPI.forcedToStop()) continue;
            ThreadLocalToolkit.log(new ForcedToStop());
            break;
        }
        return result;
    }

    private static boolean analyze(CompilationUnit u, SubCompiler[] compilers, SymbolTable symbolTable, int phase) {
        Source s = u.getSource();
        if (!s.isCompiled()) {
            SubCompiler c = CompilerAPI.getCompiler(s, compilers);
            if (c != null) {
                Logger original = ThreadLocalToolkit.getLogger();
                LocalLogger local = s.getLogger();
                ThreadLocalToolkit.setLogger(local);
                if (phase == 1) {
                    c.analyze1(u, symbolTable);
                    if (local.errorCount() == 0 && (s.isSourcePathOwner() || s.isSourceListOwner())) {
                        int size = u.topLevelDefinitions.size();
                        if (size > 1) {
                            ThreadLocalToolkit.log((CompilerMessage)new MoreThanOneDefinition(u.topLevelDefinitions), s);
                        } else if (size < 1) {
                            ThreadLocalToolkit.log((CompilerMessage)new MustHaveOneDefinition(), s);
                        } else if (s.isSourcePathOwner()) {
                            String[] classes;
                            SourcePath owner = (SourcePath)s.getOwner();
                            String[] packages = owner.checkPackageNameDirectoryName(s);
                            if (packages != null) {
                                ThreadLocalToolkit.log((CompilerMessage)new WrongPackageName(packages[0], packages[1]), s);
                            }
                            if ((classes = owner.checkClassNameFileName(s)) != null) {
                                ThreadLocalToolkit.log((CompilerMessage)new WrongDefinitionName(classes[0], classes[1]), s);
                            }
                        } else if (s.isSourceListOwner()) {
                            String[] classes;
                            SourceList owner = (SourceList)s.getOwner();
                            String[] packages = owner.checkPackageNameDirectoryName(s);
                            if (packages != null) {
                                ThreadLocalToolkit.log((CompilerMessage)new WrongPackageName(packages[0], packages[1]), s);
                            }
                            if ((classes = owner.checkClassNameFileName(s)) != null) {
                                ThreadLocalToolkit.log((CompilerMessage)new WrongDefinitionName(classes[0], classes[1]), s);
                            }
                        }
                    }
                    u.setWorkflow(16);
                } else if (phase == 2) {
                    c.analyze2(u, symbolTable);
                    u.setWorkflow(32);
                } else if (phase == 3) {
                    c.analyze3(u, symbolTable);
                    u.setWorkflow(64);
                } else {
                    c.analyze4(u, symbolTable);
                    u.setWorkflow(128);
                }
                ThreadLocalToolkit.setLogger(original);
                if (local.errorCount() > 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static void resolveInheritance(List<Source> sources, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, int start, int end) {
        HashSet<QName> qNames = new HashSet<QName>();
        for (int i = start; i < end; ++i) {
            Source source = sources.get(i);
            CompilationUnit u = source.getCompilationUnit();
            if (u == null || u.inheritance.size() == 0) continue;
            qNames.clear();
            String head = source.getName();
            String name = source.getNameForReporting();
            Iterator<Name> iterator = u.inheritance.iterator();
            while (iterator.hasNext()) {
                MultiName mName;
                QName qName;
                Name unresolved = iterator.next();
                if (!(unresolved instanceof MultiName) || (qName = CompilerAPI.resolveMultiName(name, mName = (MultiName)unresolved, sources, sourceList, sourcePath, resources, swcContext, symbolTable)) == null) continue;
                Source tailSource = symbolTable.findSourceByQName(qName);
                String tail = tailSource.getName();
                CompilerAPI.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                CompilerAPI.addEdgeToGraphs(igraph, dgraph, head, tail);
                qNames.add(qName);
                u.inheritanceHistory.put(mName, qName);
                iterator.remove();
            }
            if (qNames.size() <= 0) continue;
            u.inheritance.addAll(qNames);
        }
    }

    private static void resolveNamespace(List<Source> sources, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, int start, int end) {
        HashSet<QName> qNames = new HashSet<QName>();
        for (int i = start; i < end; ++i) {
            Source source = sources.get(i);
            CompilationUnit u = source.getCompilationUnit();
            if (u.namespaces.size() == 0) continue;
            qNames.clear();
            String head = source.getName();
            String name = u.getSource().getNameForReporting();
            Iterator<Name> iterator = u.namespaces.iterator();
            while (iterator.hasNext()) {
                MultiName mName;
                QName qName;
                Name unresolved = iterator.next();
                if (!(unresolved instanceof MultiName) || (qName = CompilerAPI.resolveMultiName(name, mName = (MultiName)unresolved, sources, sourceList, sourcePath, resources, swcContext, symbolTable)) == null) continue;
                Source tailSource = symbolTable.findSourceByQName(qName);
                String tail = tailSource.getName();
                CompilerAPI.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                CompilerAPI.addEdgeToGraphs(null, dgraph, head, tail);
                qNames.add(qName);
                u.namespaceHistory.put(mName, qName);
                iterator.remove();
            }
            if (qNames.size() <= 0) continue;
            u.namespaces.addAll(qNames);
        }
    }

    private static int findDefinition(List<Source> sources, SourceList sourceList, SourcePathBase sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, String namespaceURI, String localPart) throws CompilerException {
        Source swcSource;
        Source s;
        Source source = s = sourceList != null ? sourceList.findSource(namespaceURI, localPart) : null;
        if (s == null) {
            Source source2 = s = sourcePath != null ? sourcePath.findSource(namespaceURI, localPart) : null;
        }
        if (s == null) {
            s = resources != null ? resources.findSource(namespaceURI, localPart) : null;
        }
        Source source3 = swcSource = swcContext != null ? swcContext.getSource(namespaceURI, localPart) : null;
        if (!(swcSource == null || s != null && (s.getLastModified() != swcSource.getLastModified() || skipTimestampCheck || s.getCompilationUnit() != null && s.getCompilationUnit().hasTypeInfo))) {
            s = swcSource;
        }
        if (s != null) {
            int where = sources.indexOf(s);
            if (where == -1) {
                sources.add(s);
                return sources.size() - 1;
            }
            return where;
        }
        return -1;
    }

    private static int findResourceBundle(List<Source> sources, SourceList sourceList, SourcePathBase sourcePath, CompilerSwcContext swcContext, String[] locales, String namespaceURI, String localPart) throws CompilerException {
        VirtualFile o3;
        VirtualFile o2;
        VirtualFile o1;
        Source s1 = sourceList != null ? sourceList.findSource(namespaceURI, localPart) : null;
        VirtualFile virtualFile = o1 = s1 != null ? s1.getBackingFile() : null;
        if (o1 instanceof InMemoryFile) {
            return CompilerAPI.findResourceBundleHelper(sources, s1);
        }
        ResourceFile rf1 = (ResourceFile)o1;
        if (rf1 != null && rf1.complete()) {
            return CompilerAPI.findResourceBundleHelper(sources, s1);
        }
        Source s2 = sourcePath != null ? sourcePath.findSource(namespaceURI, localPart) : null;
        VirtualFile virtualFile2 = o2 = s2 != null ? s2.getBackingFile() : null;
        if (rf1 == null && o2 instanceof InMemoryFile) {
            return CompilerAPI.findResourceBundleHelper(sources, s2);
        }
        if (o2 instanceof InMemoryFile) {
            o2 = null;
        }
        ResourceFile rf2 = (ResourceFile)o2;
        if (rf1 != null) {
            rf1.merge(rf2);
        } else {
            rf1 = rf2;
            s1 = s2;
        }
        if (rf1 != null && rf1.complete()) {
            return CompilerAPI.findResourceBundleHelper(sources, s1);
        }
        Source s3 = swcContext != null ? swcContext.getResourceBundle(locales, namespaceURI, localPart) : null;
        VirtualFile virtualFile3 = o3 = s3 != null ? s3.getBackingFile() : null;
        if (rf1 == null && o3 instanceof InMemoryFile) {
            return CompilerAPI.findResourceBundleHelper(sources, s3);
        }
        if (o3 instanceof InMemoryFile) {
            o3 = null;
        }
        ResourceFile rf3 = (ResourceFile)o3;
        if (rf1 != null) {
            rf1.merge(rf3);
        } else {
            rf1 = rf3;
            s1 = s3;
        }
        return CompilerAPI.findResourceBundleHelper(sources, s1);
    }

    private static int findResourceBundleHelper(List<Source> sources, Source s) {
        if (s != null) {
            int where = sources.indexOf(s);
            if (where == -1) {
                sources.add(s);
                return sources.size() - 1;
            }
            return where;
        }
        return -1;
    }

    private static boolean hasPackage(SourcePath sourcePath, CompilerSwcContext swcContext, String packageName) {
        boolean hasPackage;
        boolean bl = hasPackage = sourcePath != null && sourcePath.hasPackage(packageName);
        if (!hasPackage && swcContext != null) {
            hasPackage = swcContext.hasPackage(packageName);
        }
        return hasPackage;
    }

    private static boolean hasDefinition(SourcePath sourcePath, CompilerSwcContext swcContext, QName defName) {
        boolean hasDefinition;
        boolean bl = hasDefinition = sourcePath != null && sourcePath.hasDefinition(defName);
        if (!hasDefinition && swcContext != null) {
            hasDefinition = swcContext.hasDefinition(defName);
        }
        return hasDefinition;
    }

    private static boolean sortInheritance(List<Source> sources, List<CompilationUnit> units, final DependencyGraph<CompilationUnit> graph) {
        assert (sources.size() == units.size());
        boolean success = true;
        final ArrayList tsort = new ArrayList(units.size());
        Algorithms.topologicalSort(graph, new Visitor<Vertex<String, CompilationUnit>>(){

            @Override
            public void visit(Vertex<String, CompilationUnit> v) {
                String name = v.getWeight();
                CompilationUnit u = (CompilationUnit)graph.get(name);
                assert (u != null) : name;
                tsort.add(u);
            }
        });
        if (units.size() > tsort.size()) {
            int size = units.size();
            for (int i = 0; i < size; ++i) {
                CompilationUnit u = units.get(i);
                if (tsort.contains(u)) continue;
                ThreadLocalToolkit.log((CompilerMessage)new CircularInheritance(), u.getSource());
                success = false;
            }
            assert (!success);
        } else {
            sources.clear();
            units.clear();
            int size = tsort.size();
            for (int i = 0; i < size; ++i) {
                CompilationUnit u = (CompilationUnit)tsort.get(i);
                sources.add(u.getSource());
                units.add(u);
            }
        }
        return success;
    }

    private static boolean detectCycles(List<Source> sources, DependencyGraph<CompilationUnit> graph) {
        Source s;
        final HashMap<String, Source> tsort = new HashMap<String, Source>(sources.size());
        int size = sources.size();
        for (int i = 0; i < size; ++i) {
            s = sources.get(i);
            tsort.put(s.getName(), s);
        }
        Algorithms.topologicalSort(graph, new Visitor<Vertex<String, CompilationUnit>>(){

            @Override
            public void visit(Vertex<String, CompilationUnit> v) {
                String name = v.getWeight();
                tsort.remove(name);
            }
        });
        if (tsort.size() > 0) {
            for (String name : tsort.keySet()) {
                s = (Source)tsort.get(name);
                if (s.hasError()) continue;
                ThreadLocalToolkit.log((CompilerMessage)new CircularInheritance(), name);
            }
            return true;
        }
        return false;
    }

    private static void addGeneratedSources(List<Source> sources, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, ResourceContainer resources, SymbolTable symbolTable, Configuration configuration, int start, int end) {
        for (int i = start; i < end; ++i) {
            Map l10nArchiveFiles;
            Map cssArchiveFiles;
            Source source = sources.get(i);
            CompilationUnit u = source.getCompilationUnit();
            if (u == null) continue;
            Map<QName, Source> generatedSources = u.getGeneratedSources();
            if (generatedSources != null) {
                for (Map.Entry<QName, Source> entry : generatedSources.entrySet()) {
                    QName qName = entry.getKey();
                    MultiName mN = new MultiName(qName.getNamespace(), qName.getLocalPart());
                    Source gSource = entry.getValue();
                    String gName = gSource.getName();
                    if (!igraph.containsVertex(gName)) {
                        gSource = resources.addResource(gSource);
                        CompilerAPI.addVertexToGraphs(gSource, gSource.getCompilationUnit(), igraph, dgraph);
                        sources.add(gSource);
                        symbolTable.registerMultiName(mN, qName);
                        symbolTable.registerQName(qName, gSource);
                    }
                    u.expressions.add(mN);
                }
                u.clearGeneratedSources();
            }
            if ((cssArchiveFiles = (Map)u.getContext().getAttribute("CSSArchiveFiles")) != null && cssArchiveFiles.size() > 0) {
                configuration.addCSSArchiveFiles(cssArchiveFiles);
            }
            if ((l10nArchiveFiles = (Map)u.getContext().getAttribute("L10NArchiveFiles")) == null || l10nArchiveFiles.size() <= 0) continue;
            configuration.addL10nArchiveFiles(l10nArchiveFiles);
        }
    }

    private static void resolveType(List<Source> sources, List<CompilationUnit> units, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext) {
        CompilerAPI.resolveType(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, 0, units.size());
    }

    private static void resolveType(List<Source> sources, List<CompilationUnit> units, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, int start, int end) {
        String tail;
        Source tailSource;
        MultiName mName;
        QName qName;
        Name unresolved;
        Iterator<Name> iterator;
        String name;
        String head;
        CompilationUnit u;
        Source s;
        int i;
        HashSet<QName> qNames = new HashSet<QName>();
        for (i = start; i < end; ++i) {
            s = sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : units.get(i);
            if ((u.getWorkflow() & 0x400) != 0 || u.types.size() == 0) continue;
            qNames.clear();
            head = u.getSource().getName();
            name = u.getSource().getNameForReporting();
            iterator = u.types.iterator();
            while (iterator.hasNext()) {
                unresolved = iterator.next();
                if (!(unresolved instanceof MultiName) || (qName = CompilerAPI.resolveMultiName(name, mName = (MultiName)unresolved, sources, sourceList, sourcePath, resources, swcContext, symbolTable)) == null) continue;
                tailSource = symbolTable.findSourceByQName(qName);
                tail = tailSource.getName();
                CompilerAPI.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                CompilerAPI.addEdgeToGraphs(null, dgraph, head, tail);
                qNames.add(qName);
                u.typeHistory.put(mName, qName);
                iterator.remove();
            }
            if (qNames.size() <= 0) continue;
            u.types.addAll(qNames);
        }
        for (i = start; i < end; ++i) {
            s = sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : units.get(i);
            if ((u.getWorkflow() & 0x400) != 0) continue;
            u.setWorkflow(1024);
            if (u.namespaces.size() == 0) continue;
            qNames.clear();
            head = u.getSource().getName();
            name = u.getSource().getNameForReporting();
            iterator = u.namespaces.iterator();
            while (iterator.hasNext()) {
                unresolved = iterator.next();
                if (!(unresolved instanceof MultiName) || (qName = CompilerAPI.resolveMultiName(name, mName = (MultiName)unresolved, sources, sourceList, sourcePath, resources, swcContext, symbolTable)) == null) continue;
                tailSource = symbolTable.findSourceByQName(qName);
                tail = tailSource.getName();
                CompilerAPI.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                CompilerAPI.addEdgeToGraphs(null, dgraph, head, tail);
                qNames.add(qName);
                u.namespaceHistory.put(mName, qName);
                iterator.remove();
            }
            if (qNames.size() <= 0) continue;
            u.namespaces.addAll(qNames);
        }
    }

    private static void resolveImportStatements(List<Source> sources, List<CompilationUnit> units, SourcePath sourcePath, CompilerSwcContext swcContext) {
        CompilerAPI.resolveImportStatements(sources, units, sourcePath, swcContext, 0, units.size());
    }

    private static void resolveImportStatements(List<Source> sources, List<CompilationUnit> units, SourcePath sourcePath, CompilerSwcContext swcContext, int start, int end) {
        for (int i = start; i < end; ++i) {
            CompilationUnit u;
            Source s = sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : units.get(i);
            if ((u.getWorkflow() & 0x4000) != 0) continue;
            u.setWorkflow(16384);
            Iterator<String> k = u.importPackageStatements.iterator();
            while (k.hasNext()) {
                String packageName = k.next();
                if (CompilerAPI.hasPackage(sourcePath, swcContext, packageName)) continue;
                k.remove();
            }
            k = u.importDefinitionStatements.iterator();
            while (k.hasNext()) {
                QName defName = (QName)((Object)k.next());
                if (CompilerAPI.hasDefinition(sourcePath, swcContext, defName)) continue;
                k.remove();
            }
        }
    }

    private static void resolveExpression(List<Source> sources, List<CompilationUnit> units, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        CompilerAPI.resolveExpression(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration, 0, units.size());
    }

    private static void resolveExpression(List<Source> sources, List<CompilationUnit> units, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration, int start, int end) {
        HashSet<QName> qNames = new HashSet<QName>();
        for (int i = start; i < end; ++i) {
            CompilationUnit u;
            Source s = sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : units.get(i);
            if (u.expressions.size() == 0) continue;
            qNames.clear();
            String head = u.getSource().getName();
            String name = u.getSource().getNameForReporting();
            Iterator<Name> iterator = u.expressions.iterator();
            while (iterator.hasNext()) {
                Name unresolved = iterator.next();
                if (!(unresolved instanceof MultiName)) continue;
                MultiName mName = (MultiName)unresolved;
                QName qName = CompilerAPI.resolveMultiName(name, mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
                if (qName != null) {
                    Source tailSource = symbolTable.findSourceByQName(qName);
                    String tail = tailSource.getName();
                    CompilerAPI.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                    CompilerAPI.addEdgeToGraphs(null, dgraph, head, tail);
                    qNames.add(qName);
                    u.expressionHistory.put(mName, qName);
                } else if (configuration.getCompilerConfiguration().showDependencyWarnings()) {
                    ThreadLocalToolkit.log((CompilerMessage)new UnableToResolveDependency(mName.getLocalPart()), u.getSource());
                }
                iterator.remove();
            }
            if (qNames.size() <= 0) continue;
            u.expressions.addAll(qNames);
        }
    }

    private static void addEdgeToGraphs(DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, String head, String tail) {
        if (igraph != null && !head.equals(tail) && !igraph.dependencyExists(head, tail)) {
            igraph.addDependency(head, tail);
        }
        if (dgraph != null && !head.equals(tail) && !dgraph.dependencyExists(head, tail)) {
            dgraph.addDependency(head, tail);
        }
    }

    private static void adjustQNames(List<CompilationUnit> units, DependencyGraph<CompilationUnit> igraph, SymbolTable symbolTable) {
        int size = units.size();
        for (int i = 0; i < size; ++i) {
            QName qName;
            CompilationUnit u = units.get(i);
            if (u == null || !u.isDone() || (u.getWorkflow() & 0x8000) != 0) continue;
            for (Name name : u.inheritance) {
                if (!(name instanceof QName)) continue;
                qName = (QName)name;
                CompilerAPI.adjustQName(qName, igraph, symbolTable);
            }
            for (Name name : u.namespaces) {
                if (!(name instanceof QName)) continue;
                qName = (QName)name;
                CompilerAPI.adjustQName(qName, igraph, symbolTable);
            }
            for (Name name : u.types) {
                if (!(name instanceof QName)) continue;
                qName = (QName)name;
                CompilerAPI.adjustQName(qName, igraph, symbolTable);
            }
            for (Name name : u.expressions) {
                if (!(name instanceof QName)) continue;
                qName = (QName)name;
                CompilerAPI.adjustQName(qName, igraph, symbolTable);
            }
            u.setWorkflow(32768);
        }
    }

    private static void adjustQName(QName qName, DependencyGraph<CompilationUnit> igraph, SymbolTable symbolTable) {
        Source s = symbolTable.findSourceByQName(qName);
        CompilationUnit u = igraph.get(s == null ? null : s.getName());
        if (u != null && (u.getSource().isSourcePathOwner() || u.getSource().isSourceListOwner()) && u.topLevelDefinitions.size() == 1) {
            QName def = u.topLevelDefinitions.last();
            if (qName.getLocalPart().equals(def.getLocalPart()) && !qName.getNamespace().equals(def.getNamespace())) {
                qName.setNamespace(def.getNamespace());
            }
        }
    }

    public static QName resolveMultiName(MultiName multiName, List<Source> sources, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, SymbolTable symbolTable) {
        return CompilerAPI.resolveMultiName(null, multiName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
    }

    private static QName resolveMultiName(String nameForReporting, MultiName multiName, List<Source> sources, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, SymbolTable symbolTable) {
        QName qName = symbolTable.isMultiNameResolved(multiName);
        QName qName2 = null;
        Source source = null;
        Source source2 = null;
        boolean hasAmbiguity = false;
        if (qName != null) {
            return qName;
        }
        String[] namespaceURI = multiName.getNamespace();
        String localPart = multiName.getLocalPart();
        int length = namespaceURI.length;
        for (int j = 0; j < length; ++j) {
            Source s = symbolTable.findSourceByQName(namespaceURI[j], localPart);
            int where = -1;
            if (s == null) {
                try {
                    where = CompilerAPI.findDefinition(sources, sourceList, sourcePath, resources, swcContext, namespaceURI[j], localPart);
                }
                catch (CompilerException ex) {
                    ThreadLocalToolkit.logError(ex.getMessage());
                }
                if (where != -1) {
                    s = sources.get(where);
                }
            }
            if (s == null) continue;
            if (qName == null) {
                qName = new QName(namespaceURI[j], localPart);
                source = s;
                continue;
            }
            if (qName.equals(namespaceURI[j], localPart)) continue;
            hasAmbiguity = true;
            qName2 = new QName(namespaceURI[j], localPart);
            source2 = s;
            break;
        }
        if (hasAmbiguity) {
            AmbiguousMultiname msg = new AmbiguousMultiname(qName, source.getName(), qName2, source2.getName());
            if (nameForReporting != null) {
                ThreadLocalToolkit.log((CompilerMessage)msg, nameForReporting);
            } else {
                ThreadLocalToolkit.log(msg);
            }
            return null;
        }
        if (source != null) {
            symbolTable.registerMultiName(multiName, qName);
            symbolTable.registerQName(qName, source);
        }
        return qName;
    }

    public static QName[] resolveResourceBundleName(String rbName, List<Source> sources, SourceList sourceList, SourcePathBase sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, SymbolTable symbolTable, String[] locales) {
        QName[] qNames = symbolTable.isResourceBundleResolved(rbName);
        if (qNames != null) {
            return qNames;
        }
        Source source = symbolTable.findSourceByResourceBundleName(rbName);
        if (source == null) {
            int where = -1;
            QName bundleName = new QName(rbName);
            String namespaceURI = bundleName.getNamespace();
            String localPart = bundleName.getLocalPart();
            try {
                where = CompilerAPI.findResourceBundle(sources, sourceList, sourcePath, swcContext, locales, namespaceURI, localPart);
            }
            catch (CompilerException ex) {
                ThreadLocalToolkit.logError(ex.getMessage());
            }
            if (where != -1) {
                source = sources.get(where);
                qNames = new QName[locales == null ? 0 : locales.length];
                int length = qNames.length;
                for (int i = 0; i < length; ++i) {
                    qNames[i] = new QName(namespaceURI, locales[i] + "$" + localPart + I18nUtils.CLASS_SUFFIX);
                }
            }
        }
        symbolTable.register(rbName, qNames, source);
        return qNames;
    }

    private static boolean generate(List<Source> sources, List<CompilationUnit> units, SubCompiler[] compilers, SymbolTable symbolTable) {
        return CompilerAPI.generate(sources, units, compilers, symbolTable, 0, units.size());
    }

    private static boolean generate(List<Source> sources, List<CompilationUnit> units, SubCompiler[] compilers, SymbolTable symbolTable, int start, int end) {
        boolean result = true;
        for (int i = start; i < end; ++i) {
            CompilationUnit u;
            Source s = sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : units.get(i);
            if ((u.getWorkflow() & 0x2000) != 0) continue;
            u.setWorkflow(8192);
            if (!u.isBytecodeAvailable() && !CompilerAPI.generate(u, compilers, symbolTable)) {
                result = false;
                u.getSource().disconnectLogger();
            }
            CompilerAPI.calculateProgress(sources, symbolTable);
            if (CompilerAPI.tooManyErrors()) {
                ThreadLocalToolkit.log(new TooManyErrors());
                break;
            }
            if (!CompilerAPI.forcedToStop()) continue;
            ThreadLocalToolkit.log(new ForcedToStop());
            break;
        }
        return result;
    }

    private static boolean generate(CompilationUnit u, SubCompiler[] compilers, SymbolTable symbolTable) {
        Source s = u.getSource();
        if (!s.isCompiled()) {
            SubCompiler c = CompilerAPI.getCompiler(s, compilers);
            if (c != null) {
                Logger original = ThreadLocalToolkit.getLogger();
                LocalLogger local = s.getLogger();
                ThreadLocalToolkit.setLogger(local);
                c.generate(u, symbolTable);
                if (u.bytes.size() > 0) {
                    u.setState(2);
                }
                ThreadLocalToolkit.setLogger(original);
                if (local.errorCount() > 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean postprocess(List<Source> sources, List<CompilationUnit> units, SubCompiler[] compilers, SymbolTable symbolTable) {
        return CompilerAPI.postprocess(sources, units, compilers, symbolTable, 0, units.size());
    }

    private static boolean postprocess(List<Source> sources, List<CompilationUnit> units, SubCompiler[] compilers, SymbolTable symbolTable, int start, int end) {
        boolean result = true;
        for (int i = start; i < end; ++i) {
            CompilationUnit u;
            Source s = sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : units.get(i);
            if (!CompilerAPI.postprocess(u, compilers, symbolTable)) {
                result = false;
                u.getSource().disconnectLogger();
            }
            if (CompilerAPI.tooManyErrors()) {
                ThreadLocalToolkit.log(new TooManyErrors());
                break;
            }
            if (!CompilerAPI.forcedToStop()) continue;
            ThreadLocalToolkit.log(new ForcedToStop());
            break;
        }
        return result;
    }

    private static boolean postprocess(CompilationUnit u, SubCompiler[] compilers, SymbolTable symbolTable) {
        Source s = u.getSource();
        if (!s.isCompiled()) {
            SubCompiler c = CompilerAPI.getCompiler(s, compilers);
            if (c != null) {
                Logger original = ThreadLocalToolkit.getLogger();
                LocalLogger local = s.getLogger();
                ThreadLocalToolkit.setLogger(local);
                c.postprocess(u, symbolTable);
                ThreadLocalToolkit.setLogger(original);
                if (local.errorCount() > 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static void getIncludeClasses(List<Source> sources, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        LinkedHashSet<String> includes = new LinkedHashSet<String>();
        includes.addAll(configuration.getIncludes());
        for (FramesConfiguration.FrameInfo f : configuration.getFrameList()) {
            includes.addAll(f.frameClasses);
        }
        for (String className : includes) {
            MultiName mName = new MultiName(className);
            QName qName = CompilerAPI.resolveMultiName("configuration", mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
            if (qName != null) {
                Source tailSource = symbolTable.findSourceByQName(qName);
                CompilerAPI.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                continue;
            }
            ThreadLocalToolkit.log(new UnableToResolveClass("include", className));
        }
    }

    private static void getIncludeResources(List<Source> sources, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, ResourceBundlePath bundlePath, SymbolTable symbolTable, CompilerSwcContext swcContext, Configuration configuration) {
        Map<String, VirtualFile> resourceIncludes = swcContext.getResourceIncludes();
        String[] locales = configuration.getCompilerConfiguration().getLocales();
        Iterator<String> it = resourceIncludes.keySet().iterator();
        while (it.hasNext()) {
            String rbName = NameFormatter.toColon(it.next());
            QName[] qNames = CompilerAPI.resolveResourceBundleName(rbName, sources, null, bundlePath, null, swcContext, symbolTable, locales);
            if (qNames == null) continue;
            Source source = symbolTable.findSourceByResourceBundleName(rbName);
            CompilerAPI.addVertexToGraphs(source, source.getCompilationUnit(), igraph, dgraph);
            for (int i = 0; i < qNames.length; ++i) {
                configuration.getIncludes().add(qNames[i].toString());
            }
        }
    }

    private static void getExtraSources(List<Source> sources, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, SymbolTable symbolTable, CompilerSwcContext swcContext, Configuration configuration, Map licenseMap) {
        CompilerAPI.getExtraSources(sources, igraph, dgraph, sourceList, sourcePath, resources, bundlePath, symbolTable, swcContext, 0, sources.size(), configuration, licenseMap);
    }

    private static void getExtraSources(List<Source> sources, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, SymbolTable symbolTable, CompilerSwcContext swcContext, int start, int end, Configuration configuration, Map licenseMap) {
        for (int i = start; i < end; ++i) {
            CompilationUnit u;
            Source s = sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
            if (u == null) continue;
            CompilerAPI.getExtraSources(u, sources, igraph, dgraph, sourceList, sourcePath, resources, bundlePath, symbolTable, swcContext, configuration, licenseMap);
        }
    }

    private static void getExtraSources(CompilationUnit u, List<Source> sources, DependencyGraph<CompilationUnit> igraph, DependencyGraph<Source> dgraph, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, SymbolTable symbolTable, CompilerSwcContext swcContext, Configuration configuration, Map licenseMap) {
        boolean processResourceBundles;
        if ((u.getWorkflow() & 0x10000) != 0) {
            return;
        }
        if (u.loaderClass != null) {
            String className = u.loaderClass;
            MultiName mName = new MultiName(className);
            QName qName = CompilerAPI.resolveMultiName(u.getSource().getNameForReporting(), mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
            if (qName != null) {
                Source tailSource = symbolTable.findSourceByQName(qName);
                CompilerAPI.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
            } else {
                ThreadLocalToolkit.log(new UnableToResolveClass("factoryClass", className));
            }
        }
        configuration.getResourceBundles().addAll(u.resourceBundleHistory);
        boolean bl = processResourceBundles = configuration.getCompilerConfiguration().useResourceBundleMetadata() && u.resourceBundleHistory.size() > 0;
        if (processResourceBundles) {
            String[] locales = configuration.getCompilerConfiguration().getLocales();
            Iterator<String> iterator = u.resourceBundleHistory.iterator();
            while (iterator.hasNext()) {
                String rbName = NameFormatter.toColon(iterator.next());
                Source source = null;
                QName[] qNames = CompilerAPI.resolveResourceBundleName(rbName, sources, null, bundlePath, null, swcContext, symbolTable, locales);
                if (qNames != null) {
                    source = symbolTable.findSourceByResourceBundleName(rbName);
                    CompilerAPI.addVertexToGraphs(source, source.getCompilationUnit(), igraph, dgraph);
                    continue;
                }
                MultiName mName = new MultiName(rbName);
                QName qName = CompilerAPI.resolveMultiName(u.getSource().getNameForReporting(), mName, sources, null, sourcePath, null, null, symbolTable);
                if (qName != null) {
                    source = symbolTable.findSourceByQName(qName);
                    CompilerAPI.addVertexToGraphs(source, source.getCompilationUnit(), igraph, dgraph);
                    symbolTable.register(rbName, qNames, source);
                    continue;
                }
                mName = new MultiName(rbName + I18nUtils.CLASS_SUFFIX);
                qName = CompilerAPI.resolveMultiName(u.getSource().getNameForReporting(), mName, sources, null, null, null, swcContext, symbolTable);
                if (qName != null) {
                    source = symbolTable.findSourceByQName(qName);
                    CompilerAPI.addVertexToGraphs(source, source.getCompilationUnit(), igraph, dgraph);
                    symbolTable.register(rbName, qNames, source);
                    continue;
                }
                if (locales.length == 1) {
                    ThreadLocalToolkit.log(new UnableToResolveResourceBundleForLocale(rbName, locales[0]));
                    continue;
                }
                if (locales.length <= 1) continue;
                ThreadLocalToolkit.log(new UnableToResolveResourceBundle(rbName));
            }
        }
        if (u.licensedClassReqs != null && u.licensedClassReqs.size() > 0) {
            for (Map.Entry entry : u.licensedClassReqs.entrySet()) {
                String id = (String)entry.getKey();
                String handler = (String)entry.getValue();
                if (!CompilerAPI.hasValidLicense(licenseMap, id)) {
                    MultiName mName = new MultiName(handler);
                    QName qName = CompilerAPI.resolveMultiName(u.getSource().getNameForReporting(), mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
                    configuration.getIncludes().add(handler);
                    configuration.getExterns().remove(handler);
                    if (qName != null) {
                        Source tailSource = symbolTable.findSourceByQName(qName);
                        CompilerAPI.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                        continue;
                    }
                    ThreadLocalToolkit.log(new UnableToResolveClass("RequiresLicense handler", handler));
                    continue;
                }
                configuration.getIncludes().remove(handler);
                configuration.getExterns().add(handler);
            }
        }
        if (u.extraClasses != null && u.extraClasses.size() > 0) {
            for (String string : u.extraClasses) {
                MultiName mName = new MultiName(string);
                QName qName = CompilerAPI.resolveMultiName(u.getSource().getNameForReporting(), mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
                if (qName != null) {
                    Source tailSource = symbolTable.findSourceByQName(qName);
                    CompilerAPI.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                    continue;
                }
                ThreadLocalToolkit.log(new UnableToResolveNeededClass(string));
            }
        }
        u.setWorkflow(65536);
    }

    private static void checkResourceBundles(List<Source> sources, SymbolTable symbolTable) throws CompilerException {
        for (Source s : sources) {
            CompilationUnit u = s != null ? s.getCompilationUnit() : null;
            if (u == null || u.resourceBundleHistory.size() <= 0) continue;
            for (String rbName : u.resourceBundleHistory) {
                int size;
                Source rbSource = symbolTable.findSourceByResourceBundleName(rbName);
                if (rbSource == null) continue;
                CompilationUnit rbUnit = rbSource.getCompilationUnit();
                int n = size = rbUnit == null ? 0 : rbUnit.topLevelDefinitions.size();
                for (int j = 0; j < size; ++j) {
                    u.resourceBundles.add(((QName)rbUnit.topLevelDefinitions.get(j)).toString());
                }
            }
        }
        if (ThreadLocalToolkit.errorCount() > 0) {
            throw new CompilerException();
        }
    }

    private static boolean hasValidLicense(Map licenseMap, String id) {
        boolean result = false;
        if (id.equals("mx.fbpro") && licenseMap != null) {
            try {
                Class<?> licenseClass = Class.forName("flex.license.License");
                Constructor<?> ctor = licenseClass.getConstructor(Map.class);
                Object instance = ctor.newInstance(licenseMap);
                Method method = licenseClass.getMethod("isFlashBuilderPremiumValid", null);
                result = (Boolean)method.invoke(instance, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static void markDone(List<Source> sources, List<CompilationUnit> units) {
        CompilerAPI.markDone(sources, units, 0, units.size());
    }

    private static void markDone(List<Source> sources, List<CompilationUnit> units, int start, int end) {
        for (int i = start; i < end; ++i) {
            CompilationUnit u;
            Source s = sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : units.get(i);
            if (!u.getSource().isCompiled()) continue;
            u.setState(4);
        }
    }

    private static SubCompiler getCompiler(Source source, SubCompiler[] compilers) {
        int length;
        int n = length = source == null || compilers == null ? 0 : compilers.length;
        for (int i = 0; i < length; ++i) {
            if (!compilers[i].isSupported(source.getMimeType())) continue;
            return compilers[i];
        }
        return null;
    }

    public static List<VirtualFile> getVirtualFileList(List<? extends Object> files) throws ConfigurationException {
        return new ArrayList<VirtualFile>(CompilerAPI.fileSetFromPaths(files, false, null, null));
    }

    public static List<VirtualFile> getVirtualFileList(Collection<? extends Object> paths, Set mimeTypes) throws ConfigurationException {
        return new ArrayList<VirtualFile>(CompilerAPI.fileSetFromPaths(paths, true, mimeTypes, null));
    }

    public static List<VirtualFile>[] getVirtualFileList(Collection<? extends Object> paths, Collection<VirtualFile> stylesheets, Set mimeTypes, List<File> directories) throws ConfigurationException {
        return CompilerAPI.getVirtualFileList(paths, stylesheets, mimeTypes, directories, null);
    }

    public static List<VirtualFile>[] getVirtualFileList(Collection<? extends Object> paths, Collection<VirtualFile> stylesheets, Set mimeTypes, List<File> directories, Collection<? extends Object> excludedPaths) throws ConfigurationException {
        int n;
        List[] array = new List[]{new ArrayList(), new ArrayList()};
        if (excludedPaths != null) {
            LinkedList<? extends Object> tempExcludedPaths = new LinkedList<Object>();
            for (String string : excludedPaths) {
                VirtualFile file = CompilerAPI.getVirtualFile(string);
                tempExcludedPaths.add(file);
            }
            excludedPaths = tempExcludedPaths;
        }
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>(CompilerAPI.fileSetFromPaths(paths, true, mimeTypes, null, excludedPaths));
        int n2 = n = list == null ? 0 : list.size();
        for (int i = 0; i < n; ++i) {
            VirtualFile f = (VirtualFile)list.get(i);
            array[SourceList.calculatePathRoot(f, directories) == null ? 0 : 1].add(f);
        }
        for (VirtualFile virtualFile : stylesheets) {
            array[SourceList.calculatePathRoot(virtualFile, directories) == null ? 0 : 1].add(virtualFile);
        }
        return array;
    }

    public static List<VirtualFile>[] getVirtualFileList(Set<VirtualFile> fileSet, List<File> directories) {
        List[] array = new List[]{new ArrayList(), new ArrayList()};
        for (VirtualFile f : fileSet) {
            array[SourceList.calculatePathRoot(f, directories) == null ? 0 : 1].add(f);
        }
        return array;
    }

    private static Set<VirtualFile> fileSetFromPaths(Collection<? extends Object> paths, boolean recurse, Set mimeTypes, Set<VirtualFile> fileSet) throws ConfigurationException {
        return CompilerAPI.fileSetFromPaths(paths, recurse, mimeTypes, fileSet, null);
    }

    private static Set<VirtualFile> fileSetFromPaths(Collection<? extends Object> paths, boolean recurse, Set mimeTypes, Set<VirtualFile> fileSet, Collection<? extends Object> excludedPaths) throws ConfigurationException {
        boolean topLevel = fileSet == null;
        if (topLevel) {
            fileSet = new HashSet<VirtualFile>(paths.size());
        }
        for (Object object : paths) {
            VirtualFile file;
            if (object instanceof VirtualFile) {
                file = (VirtualFile)object;
            } else {
                String path = object instanceof File ? ((File)object).getAbsolutePath() : (String)object;
                file = CompilerAPI.getVirtualFile(path);
                if (excludedPaths != null && excludedPaths.contains(file)) {
                    excludedPaths.remove(file);
                    file = null;
                }
            }
            if (file == null) continue;
            if (recurse && file.isDirectory()) {
                File dir = FileUtil.openFile(file.getName());
                if (dir == null) {
                    throw new ConfigurationException.IOError(file.getName());
                }
                CompilerAPI.fileSetFromPaths(Arrays.asList(dir.listFiles()), true, mimeTypes, fileSet, excludedPaths);
                continue;
            }
            if (!topLevel && mimeTypes != null && !mimeTypes.contains(file.getMimeType())) continue;
            fileSet.add(file);
        }
        return fileSet;
    }

    public static VirtualFile getVirtualFile(String path) throws ConfigurationException {
        return CompilerAPI.getVirtualFile(path, true);
    }

    public static VirtualFile getVirtualFile(String path, boolean reportError) throws ConfigurationException {
        VirtualFile result;
        File file = FileUtil.openFile(path);
        if (file != null && FileUtils.exists((File)file)) {
            result = new LocalFile(FileUtil.getCanonicalFile(file));
        } else {
            PathResolver resolver = ThreadLocalToolkit.getPathResolver();
            result = resolver.resolve(path);
            if (result == null && reportError) {
                throw new ConfigurationException.IOError(path);
            }
        }
        return result;
    }

    public static void encode(Configuration configuration, Movie movie, OutputStream out) throws IOException {
        LocalizationManager l10n;
        boolean useCompression = configuration.getCompilerConfiguration().useCompression();
        TagEncoderReporter encoder = configuration.generateSizeReport() ? new TagEncoderReporter() : new TagEncoder();
        new MovieEncoder((TagHandler)encoder).export(movie, useCompression);
        encoder.writeTo(out);
        CompilerAPI.generateSizeReport(configuration, movie, (TagEncoder)encoder);
        if (ThreadLocalToolkit.getBenchmark() != null && (l10n = ThreadLocalToolkit.getLocalizationManager()) != null) {
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new SWFEncoding()));
        }
    }

    public static void encode(ConsoleApplication app, OutputStream out) throws IOException {
        LocalizationManager l10n;
        List<byte[]> abcList = app.getABCs();
        int size = abcList.size();
        for (int i = 0; i < size; ++i) {
            out.write(abcList.get(i));
        }
        if (ThreadLocalToolkit.getBenchmark() != null && (l10n = ThreadLocalToolkit.getLocalizationManager()) != null) {
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new SWFEncoding()));
        }
    }

    private static void generateSizeReport(Configuration config, Movie movie, TagEncoder encoder) {
        if (config.generateSizeReport() && movie instanceof SimpleMovie && encoder instanceof TagEncoderReporter) {
            String report = ((TagEncoderReporter)encoder).getSizeReport();
            ((SimpleMovie)movie).setSizeReport(report);
            String fileName = config.getSizeReportFileName();
            if (fileName != null) {
                try {
                    FileUtil.writeFile(fileName, report);
                }
                catch (Exception ex) {
                    ThreadLocalToolkit.log(new UnableToWriteSizeReport(fileName));
                }
            }
        }
    }

    public static void persistCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, int checksum, String description, RandomAccessFile f) throws IOException {
        CompilerAPI.persistCompilationUnits(configuration, fileSpec, sourceList, sourcePath, resources, bundlePath, null, null, checksum, checksum, checksum, checksum, null, null, description, f);
    }

    public static void persistCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List units, int[] checksums, Map<QName, Long> swcDefSignatureChecksums, Map<String, Long> swcFileChecksums, Map<String, Long> archiveFileChecksums, String description, RandomAccessFile f) throws IOException {
        CompilerAPI.persistCompilationUnits(configuration, fileSpec, sourceList, sourcePath, resources, bundlePath, sources, units, checksums[0], checksums[1], checksums[2], checksums[3], swcDefSignatureChecksums, swcFileChecksums, archiveFileChecksums, description, f);
    }

    public static void persistCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List units, int checksum, int cmd_checksum, int linker_checksum, int swc_checksum, Map<QName, Long> swcDefSignatureChecksums, Map<String, Long> swcFileChecksums, String description, RandomAccessFile f) throws IOException {
        CompilerAPI.persistCompilationUnits(configuration, fileSpec, sourceList, sourcePath, resources, bundlePath, sources, units, checksum, cmd_checksum, linker_checksum, swc_checksum, swcDefSignatureChecksums, swcFileChecksums, null, description, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List units, int checksum, int cmd_checksum, int linker_checksum, int swc_checksum, Map<QName, Long> swcDefSignatureChecksums, Map<String, Long> swcFileChecksums, Map<String, Long> archiveFileChecksums, String description, RandomAccessFile f) throws IOException {
        PersistenceStore store = new PersistenceStore(configuration, f);
        int count = -1;
        try {
            count = store.write(fileSpec, sourceList, sourcePath, resources, bundlePath, sources, units, checksum, cmd_checksum, linker_checksum, swc_checksum, swcDefSignatureChecksums, swcFileChecksums, archiveFileChecksums, description);
            Object var20_19 = null;
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            if (count != -1 && ThreadLocalToolkit.getBenchmark() != null) {
                LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
                if (l10n == null) {
                    l10n = new LocalizationManager();
                    l10n.addLocalizer((ILocalizer)new XLRLocalizer());
                    l10n.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
                    ThreadLocalToolkit.setLocalizationManager(l10n);
                }
                if (ThreadLocalToolkit.getLogger() == null) {
                    CompilerAPI.useConsoleLogger();
                }
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new PersistingCompilationUnits(count)));
            }
            throw throwable;
        }
        if (count != -1 && ThreadLocalToolkit.getBenchmark() != null) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            if (l10n == null) {
                l10n = new LocalizationManager();
                l10n.addLocalizer((ILocalizer)new XLRLocalizer());
                l10n.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
                ThreadLocalToolkit.setLocalizationManager(l10n);
            }
            if (ThreadLocalToolkit.getLogger() == null) {
                CompilerAPI.useConsoleLogger();
            }
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new PersistingCompilationUnits(count)));
        }
    }

    public static void loadCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List<CompilationUnit> units, int[] checksums, Map<QName, Long> swcDefSignatureChecksums, Map<String, Long> swcFileChecksums, RandomAccessFile f, String cacheName) throws IOException {
        CompilerAPI.loadCompilationUnits(configuration, fileSpec, sourceList, sourcePath, resources, bundlePath, sources, units, checksums, swcDefSignatureChecksums, swcFileChecksums, null, f, cacheName, null);
    }

    public static void loadCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, int checksum, RandomAccessFile f, String cacheName) throws IOException {
        CompilerAPI.loadCompilationUnits(configuration, fileSpec, sourceList, sourcePath, resources, bundlePath, null, null, new int[]{checksum, checksum, checksum, checksum}, null, null, null, f, cacheName, null);
    }

    public static void loadCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List units, int[] checksums, Map<QName, Long> swcDefSignatureChecksums, Map swcFileChecksums, RandomAccessFile f, String cacheName, FontManager fontManager) throws IOException {
        CompilerAPI.loadCompilationUnits(configuration, fileSpec, sourceList, sourcePath, resources, bundlePath, sources, units, checksums, swcDefSignatureChecksums, swcFileChecksums, null, f, cacheName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List units, int[] checksums, Map<QName, Long> swcDefSignatureChecksums, Map swcFileChecksums, Map<String, Long> archiveFileChecksums, RandomAccessFile f, String cacheName, FontManager fontManager) throws IOException {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        PersistenceStore store = new PersistenceStore(configuration, f, fontManager);
        int count = -1;
        try {
            count = store.read(fileSpec, sourceList, sourcePath, resources, bundlePath, sources, units, checksums, swcDefSignatureChecksums, swcFileChecksums, archiveFileChecksums);
            if (count < 0) {
                throw new IOException(l10n.getLocalizedTextString((Object)new FailedToMatchCacheFile(cacheName)));
            }
            Object var19_18 = null;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            if (count >= 0 && ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new LoadingCompilationUnits(count)));
            }
            throw throwable;
        }
        if (count >= 0 && ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new LoadingCompilationUnits(count)));
        }
    }

    private static boolean tooManyErrors() {
        return ThreadLocalToolkit.errorCount() > 100;
    }

    public static boolean forcedToStop() {
        CompilerControl cc = ThreadLocalToolkit.getCompilerControl();
        return cc != null && cc.getStatus() == 4;
    }

    private static void calculateProgress(List<Source> sources, SymbolTable symbolTable) {
        ++symbolTable.tick;
        int total = sources.size() * 12;
        double p = (double)symbolTable.tick / (double)total;
        int percent = (int)(p * 100.0);
        if (percent > 100) {
            percent = 100;
        }
        if (percent > symbolTable.currentPercentage) {
            symbolTable.currentPercentage = percent;
            ProgressMeter meter = ThreadLocalToolkit.getProgressMeter();
            if (meter != null) {
                meter.percentDone(percent);
            }
        }
    }

    private static String workflowToString(int workflow) {
        String result = (workflow & 0x10000) >= 1 ? "extraSources" : ((workflow & 0x8000) >= 1 ? "adjustQNames" : ((workflow & 0x4000) >= 1 ? "resolveImportStatements" : ((workflow & 0x2000) >= 1 ? "generate" : ((workflow & 0x400) >= 1 ? "resolveType" : ((workflow & 0x80) >= 1 ? "analyze4" : ((workflow & 0x40) >= 1 ? "analyze3" : ((workflow & 0x20) >= 1 ? "analyze2" : ((workflow & 0x10) >= 1 ? "analyze1" : ((workflow & 8) >= 1 ? "parse2" : ((workflow & 4) >= 1 ? "parse1" : ((workflow & 2) >= 1 ? "preprocess" : "before preprocessed")))))))))));
        return result;
    }

    static String constructClassName(String namespaceURI, String localPart) {
        return namespaceURI.length() == 0 ? localPart : new StringBuilder(namespaceURI.length() + localPart.length() + 1).append(namespaceURI).append(":").append(localPart).toString();
    }

    public static void setSkipTimestampCheck(boolean skipTimestampCheck) {
        CompilerAPI.skipTimestampCheck = skipTimestampCheck;
    }

    public static class CompileTime
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -4940316315109571708L;
        public final String phase;

        public CompileTime(String phase) {
            this.phase = phase;
        }
    }

    public static class BatchTime
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -1020248542254534482L;
        public final String phase;
        public final String sourceName;

        public BatchTime(String phase, String sourceName) {
            this.phase = phase;
            this.sourceName = sourceName;
        }
    }

    public static class UnableToResolveResourceBundleForLocale
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8272953403512518246L;
        public final String bundleName;
        public final String locale;

        public UnableToResolveResourceBundleForLocale(String bundleName, String locale) {
            this.bundleName = bundleName;
            this.locale = locale;
        }
    }

    public static class UnableToResolveResourceBundle
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 8772827635337487217L;
        public final String bundleName;

        public UnableToResolveResourceBundle(String bundleName) {
            this.bundleName = bundleName;
        }
    }

    public static class UnableToResolveNeededClass
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 7916145250681811567L;
        public final String className;

        public UnableToResolveNeededClass(String className) {
            this.className = className;
        }
    }

    public static class UnableToResolveClass
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 9098665492278450430L;
        public final String type;
        public final String className;

        public UnableToResolveClass(String type, String className) {
            this.type = type;
            this.className = className;
        }
    }

    public static class UnableToWriteSizeReport
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 9098665499898450430L;
        public final String fileName;

        public UnableToWriteSizeReport(String fileName) {
            this.fileName = fileName;
        }
    }

    public static class ForcedToStop
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -8162250327019786018L;
    }

    public static class TooManyErrors
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 3209927829940607725L;
    }

    public static class ChannelDefinitionNotFound
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 5848003710927048218L;
        public final String clientType;

        public ChannelDefinitionNotFound(String clientType) {
            this.clientType = clientType;
        }
    }

    public static class LoadingCompilationUnits
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 6116416220246580099L;
        public final int count;

        public LoadingCompilationUnits(int count) {
            this.count = count;
        }
    }

    public static class FailedToMatchCacheFile
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 555051683127823122L;
        public final String cacheName;

        public FailedToMatchCacheFile(String cacheName) {
            this.cacheName = cacheName;
        }
    }

    public static class PersistingCompilationUnits
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 3560732877476940286L;
        public final int count;

        public PersistingCompilationUnits(int count) {
            this.count = count;
        }
    }

    public static class SWFEncoding
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 5936641849426685640L;
    }

    public static class AmbiguousMultiname
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3521126109099117806L;
        public final QName qName1;
        public final QName qName2;
        public final String source1;
        public final String source2;

        public AmbiguousMultiname(QName qName1, String source1, QName qName2, String source2) {
            this.qName1 = qName1;
            this.source1 = source1;
            this.qName2 = qName2;
            this.source2 = source2;
        }
    }

    public static class UnableToResolveDependency
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -5981015158191974877L;
        public final String localPart;

        public UnableToResolveDependency(String localPart) {
            this.localPart = localPart;
        }
    }

    public static class DependencyUpdated
    extends CompilerMessage.CompilerWarning {
        public final String dependency;

        public DependencyUpdated(String dependency) {
            this.dependency = dependency;
        }
    }

    public static class CircularInheritance
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2395431275577572954L;
    }

    public static class WrongDefinitionName
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -6793666173106638874L;
        public final String pathName;
        public final String defName;

        public WrongDefinitionName(String pathName, String defName) {
            this.pathName = pathName;
            this.defName = defName;
        }
    }

    public static class WrongPackageName
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2915859996892576941L;
        public final String pathPackage;
        public final String defPackage;

        public WrongPackageName(String pathPackage, String defPackage) {
            this.pathPackage = pathPackage;
            this.defPackage = defPackage;
        }
    }

    public static class MustHaveOneDefinition
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3136994771425079174L;
    }

    public static class MoreThanOneDefinition
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4656607717787554720L;
        public final List topLevelDefinitions;

        public MoreThanOneDefinition(List topLevelDefinitions) {
            this.topLevelDefinitions = topLevelDefinitions;
        }
    }

    public static class FilesChangedAffected
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 567632711113318088L;
        public final int updateCount;
        public final int count;

        public FilesChangedAffected(int updateCount, int count) {
            this.updateCount = updateCount;
            this.count = count;
        }
    }

    public static class MultiNameMeaningChanged
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -2003160838933415991L;
        public final MultiName multiName;
        public final QName qName;

        public MultiNameMeaningChanged(MultiName multiName, QName qName) {
            this.multiName = multiName;
            this.qName = qName;
        }
    }

    public static class DependentFileModified
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -3397344779921936416L;
        public final String location;

        public DependentFileModified(String location) {
            this.location = location;
        }
    }

    public static class InvalidImportStatement
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -6431103025897195931L;
        public final String defName;

        public InvalidImportStatement(String defName) {
            this.defName = defName;
        }
    }

    public static class DependentFileNoLongerExists
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 4566054497729698471L;
        public final String location;

        public DependentFileNoLongerExists(String location) {
            this.location = location;
        }
    }

    public static class NotSourcePathFirstPreference
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -9215808965455458278L;
    }

    public static class DependencyNotCached
    extends CompilerMessage.CompilerInfo {
        public final String dependency;

        public DependencyNotCached(String dependency) {
            this.dependency = dependency;
        }
    }

    public static class SwcDefinitionObsoleted
    extends CompilerMessage.CompilerInfo {
        public final String newLocation;

        public SwcDefinitionObsoleted(String newLocation) {
            this.newLocation = newLocation;
        }
    }

    public static class AssetUpdated
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 4010801229607993419L;
    }

    public static class SourceFileUpdated
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -5950312800861211191L;
    }

    public static class SourceNoLongerExists
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -2704778045668485048L;
    }

    public static class NotFullyCompiled
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 4136933749063866830L;
    }

    public static class OutputTime
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -6051351911183837367L;
        public final int size;

        public OutputTime(int size) {
            this.size = size;
        }
    }

    public static class IncompatibleSWCArchive
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 1741319866432830221L;
        public final String swc;

        public IncompatibleSWCArchive(String swc) {
            this.swc = swc;
        }
    }

    public static class UnableToSetHeadless
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 3008724815757107600L;
    }
}

