/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerAPI;
import flex2.compiler.CompilerException;
import flex2.compiler.Source;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourcePathBase {
    protected static final String NO_DIR = "";
    protected final String[] mimeTypes;
    protected final Map<String, Source> sources;
    protected boolean allowSourcePathOverlap;
    protected final Set<String> hits;
    protected final Set<String> misses;
    protected final HashMap<String, String> dirs;
    protected final List<ClasspathOverlap> warnings;

    static void addApplicationParentToSourcePath(VirtualFile appPath, VirtualFile[] classPath, List<File> directories) {
        File f;
        if (appPath != null && (f = FileUtil.openFile(appPath.getParent())) != null && f.isDirectory() && FileUtil.isSubdirectoryOf(appPath.getParent(), classPath) == -1) {
            directories.add(f);
        }
    }

    static void addPathElements(VirtualFile[] classPath, List<File> directories, boolean allowSourcePathOverlap, List<ClasspathOverlap> warnings) {
        int length;
        boolean badPaths = false;
        int n = length = classPath == null ? 0 : classPath.length;
        for (int i = 0; i < length; ++i) {
            String dirPath;
            int index;
            String path = classPath[i].getName();
            File f = FileUtil.openFile(path);
            if (f == null || !f.isDirectory()) continue;
            if (!allowSourcePathOverlap && !badPaths && (index = FileUtil.isSubdirectoryOf(f, directories)) != -1 && SourcePathBase.checkValidPackageName(path, dirPath = directories.get(index).getAbsolutePath())) {
                warnings.add(new ClasspathOverlap(path, dirPath));
                badPaths = true;
            }
            directories.add(f);
        }
    }

    private static boolean checkValidPackageName(String path1, String path2) {
        if (path1.equals(path2)) {
            return true;
        }
        String packagePath = path1.length() > path2.length() ? path1.substring(path2.length()) : path2.substring(path1.length());
        StringTokenizer t = new StringTokenizer(packagePath, File.separator);
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (TextParser.isValidIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    public SourcePathBase(String[] mimeTypes, boolean allowSourcePathOverlap) {
        this.mimeTypes = mimeTypes;
        this.allowSourcePathOverlap = allowSourcePathOverlap;
        this.sources = new HashMap<String, Source>();
        this.hits = new HashSet<String>();
        this.misses = new HashSet<String>(1024);
        this.dirs = new HashMap();
        this.warnings = new ArrayList<ClasspathOverlap>(5);
    }

    public Source findSource(String namespaceURI, String localPart) throws CompilerException {
        assert (localPart.indexOf(46) == -1 && localPart.indexOf(47) == -1 && localPart.indexOf(58) == -1) : "findSource(" + namespaceURI + "," + localPart + ") has bad localPart";
        String className = CompilerAPI.constructClassName(namespaceURI, localPart);
        return this.findSource(className, namespaceURI, localPart);
    }

    protected Source findSource(String className, String namespaceURI, String localPart) throws CompilerException {
        CompilationUnit u;
        if (this.misses.contains(className)) {
            return null;
        }
        Source s = this.sources.get(className);
        if (s == null && (s = this.findFile(className, namespaceURI, localPart)) != null) {
            return s;
        }
        CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
        if (s != null && !s.exists()) {
            this.sources.remove(className);
            s = null;
        }
        if (this.adjustDefinitionName(namespaceURI, localPart, s, u)) {
            u = null;
            s = null;
        }
        if ((s == null || (u == null || u.isDone()) && !s.isUpdated()) && s != null && u != null) {
            s = s.copy();
            assert (s != null);
        }
        if (s == null) {
            this.misses.add(className);
        }
        return s;
    }

    protected boolean adjustDefinitionName(String namespaceURI, String localPart, Source s, CompilationUnit u) {
        if (s != null && u != null && u.topLevelDefinitions.size() == 1 && !u.topLevelDefinitions.contains(namespaceURI, localPart)) {
            String realName = u.topLevelDefinitions.first().toString();
            this.sources.put(realName, s);
            this.misses.remove(realName);
            return true;
        }
        return false;
    }

    abstract boolean checkPreference(Source var1);

    protected abstract Source findFile(String var1, String var2, String var3) throws CompilerException;

    protected File findFile(File directory, String relativePath, String[] mimeTypes) throws CompilerException {
        File found = null;
        int length = mimeTypes.length;
        for (int k = 0; k < length; ++k) {
            File f = this.findFile(directory, relativePath, mimeTypes[k]);
            if (f != null && found == null) {
                found = f;
                continue;
            }
            if (f == null) continue;
            throw new MoreThanOneComponentOfTheSameName(found.getAbsolutePath(), f.getAbsolutePath());
        }
        return found;
    }

    protected File findFile(File directory, String relativePath, String mimeType) {
        String fullPath = directory.getPath() + File.separator + relativePath;
        int lastSlash = fullPath.lastIndexOf(File.separator);
        String dir = null;
        if (lastSlash != -1 && this.dirs.get(dir = fullPath.substring(0, lastSlash)) == NO_DIR) {
            return null;
        }
        String path = relativePath + MimeMappings.getExtension(mimeType);
        File f = FileUtil.openFile(directory, path);
        if (f != null && f.isFile() && FileUtil.getCanonicalPath(f).endsWith(path)) {
            return f;
        }
        if (f != null && dir != null && !this.dirs.containsKey(dir)) {
            File p = f.getParentFile();
            this.dirs.put(dir, p != null && p.isDirectory() ? dir : NO_DIR);
        }
        return null;
    }

    String[] checkClassNameFileName(Source s) {
        QName def;
        String defName = null;
        String pathName = null;
        if (s.getOwner() == this && (defName = (def = s.getCompilationUnit().topLevelDefinitions.last()).getLocalPart()).equals(pathName = s.getShortName())) {
            return null;
        }
        return new String[]{pathName, defName};
    }

    String[] checkPackageNameDirectoryName(Source s) {
        QName def;
        String defPackage = null;
        String pathPackage = null;
        if (s.getOwner() == this && (defPackage = NameFormatter.normalizePackageName((def = s.getCompilationUnit().topLevelDefinitions.last()).getNamespace())).equals(pathPackage = NameFormatter.toDot(s.getRelativePath(), '/'))) {
            return null;
        }
        return new String[]{pathPackage, defPackage};
    }

    protected String constructRelativePath(Source s) {
        String relativePath = s.getName().substring(s.getPathRoot().getName().length() + 1);
        int length = this.mimeTypes.length;
        for (int k = 0; k < length; ++k) {
            String ext = MimeMappings.getExtension(this.mimeTypes[k]);
            if (!relativePath.endsWith(ext)) continue;
            relativePath = relativePath.substring(0, relativePath.length() - ext.length());
            return relativePath;
        }
        assert (false);
        return null;
    }

    public void removeSource(Source s) {
        Iterator<Map.Entry<String, Source>> i = this.sources.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Source> e = i.next();
            if (e.getValue() != s) continue;
            i.remove();
            return;
        }
        assert (false) : "couldn't find " + s;
    }

    public void clearCache() {
        this.hits.clear();
        this.misses.clear();
        this.dirs.clear();
    }

    String[] getMimeTypes() {
        return this.mimeTypes;
    }

    public Map<String, Source> sources() {
        return this.sources;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("SourcePath: \n");
        for (Source source : this.sources.values()) {
            buffer.append("\tsource = " + source + ", cu = " + source.getCompilationUnit() + "\n");
        }
        return buffer.toString();
    }

    public void displayWarnings() {
        int size = this.warnings.size();
        for (int i = 0; i < size; ++i) {
            ThreadLocalToolkit.log(this.warnings.get(i));
        }
    }

    public static class MoreThanOneComponentOfTheSameName
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 5943423934006966281L;
        public final String file1;
        public final String file2;

        public MoreThanOneComponentOfTheSameName(String file1, String file2) {
            this.file1 = file1;
            this.file2 = file2;
        }
    }

    public static class ClasspathOverlap
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -6314431057641028497L;
        public final String cpath;
        public final String directory;

        public ClasspathOverlap(String path, String directory) {
            this.cpath = path;
            this.directory = directory;
        }
    }
}

