/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.io;

import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.MimeMappings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

public class LocalFile
implements VirtualFile {
    private File f;
    private String name;
    private String mimeType;

    public LocalFile(File f) {
        this.f = f;
    }

    public String getName() {
        if (this.name == null) {
            this.name = FileUtil.getCanonicalPath(this.f);
            this.f = FileUtil.openFile(this.name);
        }
        return this.name;
    }

    public String getNameForReporting() {
        return this.getName();
    }

    public String getURL() {
        try {
            return this.f.toURL().toExternalForm();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public String getParent() {
        return this.f.getParentFile().getAbsolutePath();
    }

    public boolean isDirectory() {
        return this.f.isDirectory();
    }

    public long size() {
        return this.f.length();
    }

    public String getMimeType() {
        if (this.mimeType == null) {
            this.mimeType = MimeMappings.getMimeType(this.getName());
        }
        return this.mimeType;
    }

    public InputStream getInputStream() throws IOException {
        return FileUtil.openStream(this.f);
    }

    public byte[] toByteArray() throws IOException {
        return null;
    }

    public long getLastModified() {
        return this.f.lastModified();
    }

    public VirtualFile resolve(String relativeStr) {
        File relativeFile = null;
        if (FileUtils.isDirectory((File)this.f)) {
            relativeFile = FileUtil.openFile(this.f, relativeStr);
        } else if (FileUtils.isFile((File)this.f)) {
            relativeFile = FileUtil.openFile(this.f.getParentFile(), relativeStr);
        }
        LocalFile result = null;
        if (relativeFile != null && FileUtils.exists((File)relativeFile)) {
            result = new LocalFile(relativeFile);
        }
        if (result != null && Trace.pathResolver) {
            Trace.trace((String)("LocalFile.resolve: resolved " + relativeStr + " to " + result.getName()));
        }
        return result;
    }

    public void close() {
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof LocalFile) {
            result = this == obj || this.getName().equals(((LocalFile)obj).getName());
        }
        return result;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isTextBased() {
        return false;
    }

    public String toString() {
        return this.getName();
    }
}

