/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flex2.compiler.mxml.dom.DocumentNode;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.rep.Script;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentInfo {
    public static final String OUTER_DOCUMENT_PROP = "outerDocument";
    private DocumentNode rootNode;
    private final String path;
    private String className;
    private String packageName;
    private QName qname;
    private String qualifiedSuperClassName;
    private Set<NameInfo> interfaceNames;
    private Set<NameInfo> importNames;
    private Map<String, String[]> splitImportNames;
    private Set<String> stateNames;
    private Map<String, Collection<String>> stateGroups;
    private Map<String, VarDecl> varDecls;
    private List<Script> scripts;
    private List<Script> metadata;
    private String languageNamespace = "";
    private int version;
    private final StandardDefs standardDefs;

    public DocumentInfo(String path, StandardDefs standardDefs) {
        this.path = path;
        this.standardDefs = standardDefs;
    }

    public String getPath() {
        return this.path;
    }

    public void setRootNode(DocumentNode rootNode, int line) {
        assert (this.rootNode == null);
        this.rootNode = rootNode;
        String outerDocumentClassName = rootNode.getOuterDocumentClassName();
        if (outerDocumentClassName != null) {
            this.addVarDecl(OUTER_DOCUMENT_PROP, outerDocumentClassName, line);
        }
        this.version = rootNode.getVersion();
        this.languageNamespace = rootNode.getLanguageNamespace();
        if (this.version < 0 || this.languageNamespace == null) {
            ThreadLocalToolkit.log(new UnableToResolveLanguageVersion());
        }
    }

    public StandardDefs getStandardDefs() {
        return this.standardDefs;
    }

    public DocumentNode getRootNode() {
        assert (this.rootNode != null);
        return this.rootNode;
    }

    public void setClassName(String className) {
        assert (this.className == null);
        this.className = className;
    }

    public String getClassName() {
        assert (this.className != null);
        return this.className;
    }

    public void setPackageName(String packageName) {
        assert (this.packageName == null);
        this.packageName = packageName;
    }

    public String getPackageName() {
        assert (this.packageName != null);
        return this.packageName;
    }

    public QName getQName() {
        return this.qname != null ? this.qname : (this.qname = new QName(this.packageName, this.className));
    }

    public void setQualifiedSuperClassName(String qualifiedSuperClassName, int line) {
        assert (this.qualifiedSuperClassName == null);
        this.qualifiedSuperClassName = qualifiedSuperClassName;
        this.addImportName(qualifiedSuperClassName, line);
    }

    public String getQualifiedSuperClassName() {
        assert (this.qualifiedSuperClassName != null);
        return this.qualifiedSuperClassName;
    }

    public void addInterfaceName(String interfaceName, int line) {
        (this.interfaceNames != null ? this.interfaceNames : (this.interfaceNames = new TreeSet<NameInfo>())).add(new NameInfo(interfaceName, line));
        this.addImportName(interfaceName, line);
    }

    public Set<NameInfo> getInterfaceNames() {
        return this.interfaceNames != null ? this.interfaceNames : Collections.emptySet();
    }

    public void addImportName(String importName, int line) {
        if (importName.startsWith(StandardDefs.CLASS_VECTOR + ".<")) {
            this.addImportName(importName.substring(StandardDefs.CLASS_VECTOR.length() + 2, importName.length() - 1), line);
        } else if (!importName.equals("*") && !StandardDefs.isBuiltInTypeName(importName)) {
            (this.importNames != null ? this.importNames : (this.importNames = new TreeSet<NameInfo>())).add(new NameInfo(importName, line));
        }
    }

    public void addImportNames(Collection<String> names, int line) {
        for (String name : names) {
            this.addImportName(name, line);
        }
    }

    public Set<NameInfo> getImportNames() {
        return this.importNames != null ? this.importNames : Collections.emptySet();
    }

    public void removeImportName(String importName) {
        Iterator<NameInfo> iterator = this.importNames.iterator();
        while (iterator.hasNext()) {
            NameInfo nameInfo = iterator.next();
            if (!nameInfo.getName().equals(importName)) continue;
            iterator.remove();
            return;
        }
    }

    public void addSplitImportName(String importName, String[] splitImportName) {
        if (this.splitImportNames == null) {
            this.splitImportNames = new TreeMap<String, String[]>();
        }
        this.splitImportNames.put(importName, splitImportName);
    }

    public void addSplitImportNames(Map<String, String[]> names) {
        if (this.splitImportNames == null) {
            this.splitImportNames = new TreeMap<String, String[]>();
        }
        this.splitImportNames.putAll(names);
    }

    public Collection<String[]> getSplitImportNames() {
        return this.splitImportNames != null ? this.splitImportNames.values() : Collections.emptyList();
    }

    public void removeSplitImportName(String importName) {
        if (this.splitImportNames != null) {
            this.splitImportNames.remove(importName);
        }
    }

    public void addStateName(String stateName, int line) {
        if (this.stateGroups != null && this.stateGroups.containsKey(stateName)) {
            ThreadLocalToolkit.log((CompilerMessage)new AmbiguousStateIdentifier(stateName), this.path, line);
        }
        this.stateNames = this.stateNames != null ? this.stateNames : new LinkedHashSet<String>();
        this.stateNames.add(stateName);
    }

    public void addStateGroup(String groupName, String stateName, int line) {
        if (this.stateNames != null && this.stateNames.contains(groupName)) {
            ThreadLocalToolkit.log((CompilerMessage)new AmbiguousStateIdentifier(groupName), this.path, line);
        }
        this.stateGroups = this.stateGroups != null ? this.stateGroups : new HashMap<String, Collection<String>>();
        ArrayList<String> states = this.stateGroups.get(groupName);
        states = states != null ? states : new ArrayList<String>();
        states.add(stateName);
        this.stateGroups.put(groupName, states);
    }

    public Map<String, Collection<String>> getStateGroups() {
        return this.stateGroups != null ? this.stateGroups : Collections.emptyMap();
    }

    public Set<String> getStateNames() {
        return this.stateNames != null ? this.stateNames : Collections.EMPTY_SET;
    }

    public void addVarDecl(String name, String className, int line) {
        VarDecl ref = new VarDecl(name, className, line);
        (this.varDecls != null ? this.varDecls : (this.varDecls = new LinkedHashMap<String, VarDecl>())).put(name, ref);
        this.addImportName(className, line);
    }

    public void addVectorVarDecl(String name, int line, String elementTypeName) {
        VarDecl ref = new VarDecl(name, StandardDefs.CLASS_VECTOR + ".<" + elementTypeName + ">", line);
        (this.varDecls != null ? this.varDecls : (this.varDecls = new LinkedHashMap<String, VarDecl>())).put(name, ref);
        int dotLessThanIndex = elementTypeName.lastIndexOf(".<");
        if (dotLessThanIndex != -1) {
            int greaterThanIndex = elementTypeName.indexOf(">");
            if (greaterThanIndex != -1) {
                this.addImportName(StandardDefs.CLASS_VECTOR, line);
                this.addImportName(elementTypeName.substring(dotLessThanIndex + 2, greaterThanIndex), line);
            }
        } else {
            this.addImportName(elementTypeName, line);
        }
    }

    public Map<String, VarDecl> getVarDecls() {
        return this.varDecls != null ? this.varDecls : Collections.emptyMap();
    }

    public boolean containsVarDecl(String id) {
        return this.getVarDecls().containsKey(id);
    }

    public void addScript(Script script) {
        (this.scripts != null ? this.scripts : (this.scripts = new ArrayList<Script>())).add(script);
    }

    public List<Script> getScripts() {
        return this.scripts != null ? this.scripts : Collections.emptyList();
    }

    public void addMetadata(Script metadatum) {
        (this.metadata != null ? this.metadata : (this.metadata = new ArrayList<Script>())).add(metadatum);
    }

    public List<Script> getMetadata() {
        return this.metadata != null ? this.metadata : Collections.emptyList();
    }

    public void addLocalClass(String namespace, String localPart, String className) {
        assert (this.rootNode != null);
        this.rootNode.addLocalClass(namespace, localPart, className);
    }

    public String getLocalClass(String namespace, String localPart) {
        if (this.rootNode == null) {
            return null;
        }
        return this.rootNode.getLocalClass(namespace, localPart);
    }

    public NameMappings getLocalClassMappings() {
        if (this.rootNode == null) {
            return null;
        }
        return this.rootNode.getLocalClassMappings();
    }

    public String getLanguageNamespace() {
        return this.languageNamespace;
    }

    public void setLanguageNamespace(String namespace) {
        this.languageNamespace = namespace;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public static class NameInfo
    implements Comparable {
        private final String name;
        private final int line;

        NameInfo(String name, int line) {
            this.name = name;
            this.line = line;
        }

        public int compareTo(Object o) {
            return o instanceof NameInfo ? this.name.compareTo(((NameInfo)o).name) : 0;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public int getLine() {
            return this.line;
        }
    }

    public static class VarDecl {
        public final String name;
        public final String className;
        public final int line;

        VarDecl(String name, String className, int line) {
            this.name = name;
            this.className = className;
            this.line = line;
        }
    }

    public static class UnableToResolveLanguageVersion
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8221325833364429728L;
    }

    public static class AmbiguousStateIdentifier
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -7799411281259631895L;
        public String name;

        public AmbiguousStateIdentifier(String name) {
            this.name = name;
        }
    }
}

