/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.config;

import flash.util.Trace;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationFilter;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationBuffer {
    private final Map<String, List> varMap;
    private final Set<String> committed;
    private final Class configClass;
    private Map<String, ConfigurationInfo> varCache = new HashMap<String, ConfigurationInfo>();
    private List<String> requiredList = new LinkedList<String>();
    private List<String> varList = new LinkedList<String>();
    private Map<String, Class> childCache = new HashMap<String, Class>();
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<String, String> tokens = new HashMap<String, String>();
    private List<Object[]> positions = new ArrayList<Object[]>();
    private static final String SET_PREFIX = "cfg";
    private static final String GET_PREFIX = "get";
    private static final String CONFIGURATION_SUFFIX = "Configuration";
    private static final String INFO_SUFFIX = "Info";
    private String defaultVar;
    private StringBuilder compile_checksum = new StringBuilder();
    private StringBuilder compile_checksum_ts = new StringBuilder();
    private StringBuilder link_checksum = new StringBuilder();
    private StringBuilder link_checksum_ts = new StringBuilder();

    public ConfigurationBuffer(Class configClass) {
        this(configClass, new HashMap<String, String>());
    }

    public ConfigurationBuffer(Class configClass, Map<String, String> aliases) {
        this(configClass, aliases, null);
    }

    public ConfigurationBuffer(Class configClass, Map<String, String> aliases, ConfigurationFilter filter) {
        this.configClass = configClass;
        this.varMap = new HashMap<String, List>();
        this.committed = new HashSet<String>();
        this.loadCache(configClass, null, filter);
        assert (this.varCache.size() > 0) : "coding error: nothing was configurable in the provided object!";
        for (Map.Entry<String, String> e : aliases.entrySet()) {
            this.addAlias(e.getKey(), e.getValue());
        }
    }

    public ConfigurationBuffer(ConfigurationBuffer copyFrom, boolean copyCommitted) {
        this.configClass = copyFrom.configClass;
        this.varMap = new HashMap<String, List>(copyFrom.varMap);
        this.committed = copyCommitted ? new HashSet<String>(copyFrom.committed) : new HashSet();
        this.varCache = copyFrom.varCache;
        this.childCache = copyFrom.childCache;
        this.varList = copyFrom.varList;
        this.tokens = new HashMap<String, String>(copyFrom.tokens);
    }

    public void setVar(String var, String val, String source, int line) throws ConfigurationException {
        LinkedList<String> list = new LinkedList<String>();
        list.add(val);
        this.setVar(var, list, source, line, null, false);
    }

    public void setVar(String var, List<String> vals, String source, int line) throws ConfigurationException {
        this.setVar(var, vals, source, line, null, false);
    }

    public void setVar(String avar, List<String> vals, String source, int line, String contextPath, boolean append) throws ConfigurationException {
        String var = this.unalias(avar);
        if (!this.isValidVar(var)) {
            throw new ConfigurationException.UnknownVariable(var, source, line);
        }
        int argCount = this.getVarArgCount(var);
        if (argCount != -1 && vals.size() != argCount) {
            throw new ConfigurationException.IncorrectArgumentCount(argCount, vals.size(), var, source, line);
        }
        ConfigurationValue val = new ConfigurationValue(this, var, vals, source, line, contextPath);
        this.storeValue(var, val, append);
        this.committed.remove(var);
    }

    public void clearVar(String avar, String source, int line) throws ConfigurationException {
        String var = this.unalias(avar);
        if (!this.isValidVar(var)) {
            throw new ConfigurationException.UnknownVariable(var, source, line);
        }
        this.varMap.remove(var);
        this.committed.remove(var);
    }

    public void clearSourceVars(String source) {
        LinkedList<String> remove = new LinkedList<String>();
        for (Map.Entry<String, List> e : this.varMap.entrySet()) {
            String var = e.getKey();
            List vals = e.getValue();
            LinkedList<ConfigurationValue> newvals = new LinkedList<ConfigurationValue>();
            for (ConfigurationValue val : vals) {
                if (val.getSource().equals(source)) continue;
                newvals.add(val);
            }
            if (newvals.size() > 0) {
                this.varMap.put(var, newvals);
                continue;
            }
            remove.add(var);
        }
        Iterator<Map.Entry<String, List<Object>>> it = remove.iterator();
        while (it.hasNext()) {
            this.varMap.remove(it.next());
        }
    }

    public List<String> processValues(String var, List<String> args, String source, int line) throws ConfigurationException {
        LinkedList<String> newArgs = new LinkedList<String>();
        for (String arg : args) {
            int o;
            int depth = 100;
            while (depth-- > 0 && (o = arg.indexOf("${")) != -1) {
                int c = arg.indexOf("}", o);
                if (c == -1) {
                    throw new ConfigurationException.Token("MissingDelimiter", null, var, source, line);
                }
                String token = arg.substring(o + 2, c);
                String value = this.getToken(token);
                if (value == null && value == null) {
                    throw new ConfigurationException.Token("UnknownToken", token, var, source, line);
                }
                arg = arg.substring(0, o) + value + arg.substring(c + 1);
            }
            if (depth == 0) {
                throw new ConfigurationException.Token("RecursionLimit", null, var, source, line);
            }
            newArgs.add(arg);
        }
        return newArgs;
    }

    public void setToken(String token, String value) {
        this.tokens.put(token, value);
    }

    public String getToken(String token) {
        if (this.tokens.containsKey(token)) {
            return this.tokens.get(token);
        }
        try {
            return System.getProperty(token);
        }
        catch (SecurityException se) {
            return null;
        }
    }

    private void storeValue(String avar, ConfigurationValue val, boolean append) throws ConfigurationException {
        List<ConfigurationValue> vals;
        String var = this.unalias(avar);
        ConfigurationInfo info = this.getInfo(var);
        if (this.varMap.containsKey(var)) {
            vals = this.varMap.get(var);
            assert (vals.size() > 0);
            ConfigurationValue first = (ConfigurationValue)vals.get(0);
            if (!append && !first.getSource().equals(val.getSource())) {
                vals.clear();
            } else if (!info.allowMultiple()) {
                throw new ConfigurationException.IllegalMultipleSet(var, val.getSource(), val.getLine());
            }
        } else {
            vals = new LinkedList();
            this.varMap.put(var, vals);
        }
        vals.add(val);
    }

    public List getVar(String avar) {
        String var = this.unalias(avar);
        return this.varMap.get(var);
    }

    public Iterator<String> getVarIterator() {
        return this.varCache.keySet().iterator();
    }

    private Iterator<String> getSetVarIterator() {
        return this.varMap.keySet().iterator();
    }

    public void merge(ConfigurationBuffer other) {
        assert (this.configClass == other.configClass);
        this.varMap.putAll(other.varMap);
        this.committed.addAll(other.committed);
    }

    public void mergeChild(String prefix, ConfigurationBuffer child) {
        assert (this.isChildConfig(prefix)) : "coding error: " + prefix + " is not a child configuration object.";
        for (Map.Entry<String, List> e : child.varMap.entrySet()) {
            this.varMap.put(prefix + "." + e.getKey(), e.getValue());
        }
        for (String var : child.committed) {
            this.committed.add(prefix + "." + var);
        }
    }

    protected static String c2h(String camel) {
        StringBuilder b = new StringBuilder(camel.length() + 5);
        for (int i = 0; i < camel.length(); ++i) {
            char c = camel.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i != 0) {
                    b.append('-');
                }
                b.append(Character.toLowerCase(c));
                continue;
            }
            b.append(camel.charAt(i));
        }
        return b.toString();
    }

    protected static String h2c(String hyphenated, boolean studly) {
        StringBuilder b = new StringBuilder(hyphenated.length());
        boolean capNext = studly;
        for (int i = 0; i < hyphenated.length(); ++i) {
            char c = hyphenated.charAt(i);
            if (c == '-') {
                capNext = true;
                continue;
            }
            b.append(capNext ? Character.toUpperCase(c) : c);
            capNext = false;
        }
        return b.toString();
    }

    private static String varname(String membername, String basename) {
        return basename == null ? membername : basename + "." + membername;
    }

    private static ConfigurationInfo createInfo(Method setterMethod) {
        ConfigurationInfo info = null;
        String infoMethodName = GET_PREFIX + setterMethod.getName().substring(SET_PREFIX.length()) + INFO_SUFFIX;
        String getterMethodName = GET_PREFIX + setterMethod.getName().substring(SET_PREFIX.length());
        Class<?> cfgClass = setterMethod.getDeclaringClass();
        Method infoMethod = null;
        Method getterMethod = null;
        try {
            infoMethod = cfgClass.getMethod(infoMethodName, null);
            if (!Modifier.isStatic(infoMethod.getModifiers())) {
                assert (false) : "coding error: " + cfgClass.getName() + "." + infoMethodName + " needs to be static!";
                infoMethod = null;
            }
            info = (ConfigurationInfo)infoMethod.invoke(null, (Object[])null);
            getterMethod = cfgClass.getMethod(getterMethodName, null);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (info == null) {
            info = new ConfigurationInfo();
        }
        info.setSetterMethod(setterMethod);
        info.setGetterMethod(getterMethod);
        return info;
    }

    private static ConfigurationInfo createChildInfo(Method childGetMethod) {
        ConfigurationInfo info = null;
        int cfgIndex = childGetMethod.getName().lastIndexOf(CONFIGURATION_SUFFIX);
        assert (cfgIndex != -1);
        String infoMethodName = childGetMethod.getName().substring(0, cfgIndex) + INFO_SUFFIX;
        Class<?> cfgClass = childGetMethod.getDeclaringClass();
        Method infoMethod = null;
        try {
            infoMethod = cfgClass.getMethod(infoMethodName, null);
            if (!Modifier.isStatic(infoMethod.getModifiers())) {
                assert (false) : "coding error: " + cfgClass.getName() + "." + infoMethodName + " needs to be static!";
                infoMethod = null;
            }
            info = (ConfigurationInfo)infoMethod.invoke(null, (Object[])null);
            info.setSetterMethod(null);
            assert (info.getAliases() == null) : "coding error: child configurations cannot have aliases.";
            assert (info.getArgCount() == 0) : "coding error: child configurations do not have arguments";
            assert (info.getArgName(0) == null) : "coding error: child configuraitons do not have argnames";
        }
        catch (Exception e) {
            return null;
        }
        if (info == null) {
            info = new ConfigurationInfo();
        }
        return info;
    }

    private boolean loadCache(Class cfg, String basename, ConfigurationFilter filter) {
        Method method;
        int m;
        int count = 0;
        Method[] methods = cfg.getMethods();
        for (m = 0; m < methods.length; ++m) {
            Class<?>[] pt;
            method = methods[m];
            if (!method.getName().startsWith(SET_PREFIX) || (pt = method.getParameterTypes()).length <= 1 || pt[0] != ConfigurationValue.class) continue;
            ConfigurationInfo info = ConfigurationBuffer.createInfo(method);
            String leafname = ConfigurationBuffer.c2h(method.getName().substring(SET_PREFIX.length()));
            String name = ConfigurationBuffer.varname(leafname, basename);
            if (filter != null && !filter.select(name)) continue;
            this.varCache.put(name, info);
            this.varList.add(name);
            if (info.isRequired()) {
                this.requiredList.add(name);
            }
            ++count;
        }
        for (m = 0; m < methods.length; ++m) {
            method = methods[m];
            if (!method.getName().startsWith(GET_PREFIX) || !method.getName().endsWith(CONFIGURATION_SUFFIX)) continue;
            String leafname = ConfigurationBuffer.c2h(method.getName().substring(GET_PREFIX.length(), method.getName().length() - CONFIGURATION_SUFFIX.length()));
            String fullname = ConfigurationBuffer.varname(leafname, basename);
            if (!this.loadCache(method.getReturnType(), fullname, filter)) continue;
            this.childCache.put(fullname, method.getReturnType());
            ++count;
        }
        assert (count > 0 || filter != null) : "coding error: config class " + cfg.getName() + " did not define any setters or child configs";
        return count > 0;
    }

    String classToArgName(Class c) {
        String className = c.getName();
        if (className.startsWith("java.lang.")) {
            className = className.substring("java.lang.".length());
        }
        return className.toLowerCase();
    }

    public ConfigurationInfo getInfo(String avar) {
        String var = this.unalias(avar);
        return this.varCache.get(var);
    }

    String getVarArgName(String avar, int argnum) {
        String var = this.unalias(avar);
        ConfigurationInfo info = this.getInfo(var);
        if (info == null) assert (false) : "must call isValid to check vars!";
        return info.getArgName(argnum);
    }

    public boolean isValidVar(String avar) {
        String var = this.unalias(avar);
        ConfigurationInfo info = this.getInfo(var);
        return info != null;
    }

    public boolean isChildConfig(String var) {
        return this.childCache.keySet().contains(var);
    }

    public Class getChildConfigClass(String var) {
        return this.childCache.get(var);
    }

    int getVarArgCount(String avar) {
        ConfigurationInfo info = this.getInfo(avar);
        assert (info != null);
        return info.getArgCount();
    }

    public void commit(Object config) throws ConfigurationException {
        assert (config.getClass() == this.configClass) : "coding error: configuration " + config.getClass() + " != template " + this.configClass;
        HashSet<String> done = new HashSet<String>();
        for (String var : this.varList) {
            if (!this.varMap.containsKey(var)) continue;
            this.commitVariable(config, var, done);
        }
        for (String req : this.requiredList) {
            if (this.committed.contains(req)) continue;
            throw new ConfigurationException.MissingRequirement(req, null, null, -1);
        }
    }

    private void commitVariable(Object config, String var, Set<String> done) throws ConfigurationException {
        ConfigurationInfo info = this.getInfo(var);
        this.setPrerequisites(info.getPrerequisites(), var, done, config, true);
        this.setPrerequisites(info.getSoftPrerequisites(), var, done, config, false);
        if (this.committed.contains(var)) {
            return;
        }
        this.committed.add(var);
        done.add(var);
        assert (this.varMap.containsKey(var));
        List vals = this.varMap.get(var);
        if (vals.size() > 1) assert (info.allowMultiple());
        for (ConfigurationValue val : vals) {
            try {
                Object targetconfig = this.getParentConfiguration(config, var);
                Object[] args = this.buildArgList(info, val);
                info.getSetterMethod().invoke(targetconfig, args);
                this.calculateChecksum(targetconfig, info, var, args);
            }
            catch (Exception e) {
                Throwable t = e;
                if (e instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)e).getTargetException();
                }
                if (Trace.error) {
                    t.printStackTrace();
                }
                if (t instanceof ConfigurationException) {
                    throw (ConfigurationException)t;
                }
                throw new ConfigurationException.OtherThrowable(t, var, val.getSource(), val.getLine());
            }
        }
    }

    private void setPrerequisites(String[] prerequisites, String var, Set<String> done, Object config, boolean required) throws ConfigurationException {
        if (prerequisites != null) {
            for (int p = 0; p < prerequisites.length; ++p) {
                String depvar = prerequisites[p];
                int dot = var.lastIndexOf(46);
                if (dot >= 0) {
                    String car = var.substring(0, dot);
                    depvar = car + "." + depvar;
                }
                if (done.contains(depvar)) continue;
                if (!this.isValidVar(depvar)) {
                    assert (false) : "invalid " + var + " dependency " + depvar;
                    continue;
                }
                if (this.varMap.containsKey(depvar)) {
                    this.commitVariable(config, depvar, done);
                    continue;
                }
                if (!required || this.committed.contains(depvar)) continue;
                throw new ConfigurationException.MissingRequirement(depvar, var, null, -1);
            }
        }
    }

    Object getParentConfiguration(Object config, String varname) {
        block7: {
            int dot = varname.indexOf(46);
            if (dot < 0) {
                return config;
            }
            String car = varname.substring(0, dot);
            String cdr = varname.substring(dot + 1);
            String getConfigName = GET_PREFIX + ConfigurationBuffer.h2c(car, true) + CONFIGURATION_SUFFIX;
            try {
                Method getCfgMethod = config.getClass().getMethod(getConfigName, null);
                Object child = getCfgMethod.invoke(config, (Object[])null);
                return this.getParentConfiguration(child, cdr);
            }
            catch (NoSuchMethodException e) {
                assert (false) : "impossible: should have already confirmed this!";
            }
            catch (InvocationTargetException e) {
                assert (false) : "coding error: bad child config getter";
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)"coding error: bad child config getter");
            }
        }
        return null;
    }

    private String[] constructStringArray(List<String> args) {
        String[] sa = new String[args.size()];
        int i = 0;
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            sa[i++] = it.next();
        }
        return sa;
    }

    private Object constructValueObject(ConfigurationInfo info, ConfigurationValue cv) throws ConfigurationException {
        try {
            Class<?>[] pt = info.getSetterMethod().getParameterTypes();
            assert (pt.length == 2);
            Object o = pt[1].newInstance();
            Field[] fields = pt[1].getFields();
            assert (fields.length == cv.getArgs().size());
            Iterator<String> argsit = cv.getArgs().iterator();
            for (int f = 0; f < fields.length; ++f) {
                String val = argsit.next();
                Object valobj = null;
                Class<?> fc = fields[f].getType();
                assert (info.getArgType(f) == fc);
                assert (info.getArgName(f).equals(ConfigurationBuffer.c2h(fields[f].getName())));
                if (fc == String.class) {
                    valobj = val;
                } else if (fc == Boolean.class || fc == Boolean.TYPE) {
                    valobj = Boolean.valueOf(val);
                } else if (fc == Integer.class || fc == Integer.TYPE) {
                    valobj = Integer.decode(val);
                } else if (fc == Long.class || fc == Long.TYPE) {
                    valobj = Long.decode(val);
                } else assert (false);
                fields[f].set(o, valobj);
            }
            return o;
        }
        catch (InstantiationException e) {
            assert (false) : "coding error: unable to instantiate value object when trying to set var " + cv.getVar();
            throw new ConfigurationException.OtherThrowable(e, cv.getVar(), cv.getSource(), cv.getLine());
        }
        catch (IllegalAccessException e) {
            assert (false) : "coding error: " + e + " when trying to set var " + cv.getVar();
            throw new ConfigurationException.OtherThrowable(e, cv.getVar(), cv.getSource(), cv.getLine());
        }
    }

    protected static boolean isSupportedSimpleType(Class c) {
        return c == String.class || c == Integer.class || c == Integer.TYPE || c == Long.class || c == Long.TYPE || c == Boolean.class || c == Boolean.TYPE;
    }

    protected static boolean isSupportedListType(Class c) {
        return c == List.class || c == String[].class;
    }

    protected static boolean isSupportedValueType(Class c) {
        if (ConfigurationBuffer.isSupportedSimpleType(c)) {
            return false;
        }
        Field[] fields = c.getFields();
        for (int f = 0; f < fields.length; ++f) {
            if (ConfigurationBuffer.isSupportedSimpleType(fields[f].getType())) continue;
            return false;
        }
        return true;
    }

    private Object[] buildArgList(ConfigurationInfo info, ConfigurationValue val) throws ConfigurationException {
        Method setter = info.getSetterMethod();
        Class<?>[] pt = setter.getParameterTypes();
        List<String> args = this.processValues(val.getVar(), val.getArgs(), val.getSource(), val.getLine());
        if (info.getArgCount() == -1) {
            if (pt.length != 2) {
                assert (false) : "coding error: unlimited length setter " + val.getVar() + " must take a single argument of type List or String[]";
                return null;
            }
            if (List.class.isAssignableFrom(pt[1])) {
                return new Object[]{val, args};
            }
            if (String[].class.isAssignableFrom(pt[1])) {
                return new Object[]{val, this.constructStringArray(args)};
            }
            assert (false) : "coding error: unlimited length setter " + val.getVar() + " must take a single argument of type List or String[]";
            return null;
        }
        assert (pt.length > 1) : "coding error: config setter " + val.getVar() + " must accept at least one argument";
        if (pt.length == 2) {
            if (List.class.isAssignableFrom(pt[1])) {
                return new Object[]{val, args};
            }
            if (String[].class == pt[1]) {
                return new Object[]{val, this.constructStringArray(args)};
            }
            if (ConfigurationBuffer.isSupportedValueType(pt[1])) {
                return new Object[]{val, this.constructValueObject(info, val)};
            }
        }
        assert (pt.length == args.size() + 1) : "coding error: config setter " + val.getVar() + " does not have " + args.size() + " parameters!";
        Object[] pa = new Object[pt.length];
        pa[0] = val;
        for (int p = 1; p < pt.length; ++p) {
            String arg = args.get(p - 1);
            if (pt[p].isAssignableFrom(String.class)) {
                pa[p] = arg;
                continue;
            }
            if (pt[p] == Integer.TYPE || pt[p] == Integer.class) {
                try {
                    pa[p] = Integer.decode(arg);
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException.TypeMismatch("Integer", arg, val.getVar(), val.getSource(), val.getLine());
                }
            }
            if (pt[p] == Long.TYPE || pt[p] == Long.class) {
                try {
                    pa[p] = Long.decode(arg);
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException.TypeMismatch("Long", arg, val.getVar(), val.getSource(), val.getLine());
                }
            }
            if (pt[p] == Boolean.TYPE || pt[p] == Boolean.class) {
                try {
                    arg = arg.trim().toLowerCase();
                    if (!arg.equals("true") && !arg.equals("false")) {
                        throw new ConfigurationException.TypeMismatch("Boolean", arg, val.getVar(), val.getSource(), val.getLine());
                    }
                    pa[p] = Boolean.valueOf(arg);
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException.TypeMismatch("Boolean", arg, val.getVar(), val.getSource(), val.getLine());
                }
            }
            assert (false) : "coding error: " + val.getVar() + " setter argument " + p + " is not a supported type";
        }
        return pa;
    }

    public void addAlias(String alias, String var) {
        if (!this.isValidVar(var)) {
            assert (false) : "coding error: can't bind alias " + alias + " to nonexistent var " + var;
            return;
        }
        if (this.aliases.containsKey(alias)) {
            assert (false) : "coding error: alias " + alias + " already defined as " + this.aliases.get(alias);
            return;
        }
        if (this.varCache.containsKey(alias)) {
            assert (false) : "coding error: can't define alias " + alias + ", it already exists as a var";
            return;
        }
        this.aliases.put(alias, var);
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public String unalias(String var) {
        String realvar = this.aliases.get(var);
        return realvar == null ? var : realvar;
    }

    public String peekSimpleConfigurationVar(String avar) throws ConfigurationException {
        String val = null;
        List valList = this.getVar(avar);
        if (valList != null) {
            ConfigurationValue cv = (ConfigurationValue)valList.get(0);
            List<String> args = this.processValues(avar, cv.getArgs(), cv.getSource(), cv.getLine());
            val = args.get(0);
        }
        return val;
    }

    public List<ConfigurationValue> peekConfigurationVar(String avar) throws ConfigurationException {
        List srcList = this.getVar(avar);
        if (srcList == null) {
            return null;
        }
        LinkedList<ConfigurationValue> dstList = new LinkedList<ConfigurationValue>();
        for (ConfigurationValue srcVal : srcList) {
            List<String> args = this.processValues(avar, srcVal.getArgs(), srcVal.getSource(), srcVal.getLine());
            ConfigurationValue dstVal = new ConfigurationValue(srcVal.getBuffer(), avar, args, srcVal.getSource(), srcVal.getLine(), srcVal.getContext());
            dstList.add(dstVal);
        }
        return dstList;
    }

    public void addPosition(String var, int iStart, int iEnd) {
        this.positions.add(new Object[]{var, new Integer(iStart), new Integer(iEnd)});
    }

    public List<Object[]> getPositions() {
        return this.positions;
    }

    public void setDefaultVar(String var) {
        this.defaultVar = var;
    }

    private void calculateChecksum(Object targetConfig, ConfigurationInfo info, String var, Object[] args) throws Exception {
        if (var != null && var.equals(this.defaultVar)) {
            return;
        }
        if (info.doChecksum()) {
            this.compile_checksum.append(var);
        }
        this.link_checksum.append(var);
        for (int i = 1; i < args.length; ++i) {
            if (info.getGetterMethod() != null) {
                Class<?> retType = info.getGetterMethod().getReturnType();
                if (VirtualFile.class.isAssignableFrom(retType)) {
                    VirtualFile file = (VirtualFile)info.getGetterMethod().invoke(targetConfig, (Object[])null);
                    if (file == null) continue;
                    if (info.doChecksum()) {
                        this.compile_checksum.append(file.getName());
                    }
                    this.link_checksum.append(file.getName());
                    continue;
                }
                if (retType.isArray() && VirtualFile.class.isAssignableFrom(retType.getComponentType())) {
                    VirtualFile[] files = (VirtualFile[])info.getGetterMethod().invoke(targetConfig, (Object[])null);
                    for (int j = 0; files != null && j < files.length; ++j) {
                        if (files[j] == null) continue;
                        if (info.doChecksum()) {
                            this.compile_checksum.append(files[j].getName());
                        }
                        this.link_checksum.append(files[j].getName());
                    }
                    continue;
                }
            }
            if (args[i] instanceof Object[]) {
                Object[] a = (Object[])args[i];
                for (int j = 0; j < a.length; ++j) {
                    if (info.doChecksum()) {
                        this.compile_checksum.append(a[j]);
                    }
                    this.link_checksum.append(a[j]);
                }
                continue;
            }
            if (args[i] instanceof List) {
                List l = (List)args[i];
                for (int j = 0; j < l.size(); ++j) {
                    if (info.doChecksum()) {
                        this.compile_checksum.append(l.get(j));
                    }
                    this.link_checksum.append(l.get(j));
                }
                continue;
            }
            if (info.doChecksum()) {
                this.compile_checksum.append(args[i]);
            }
            this.link_checksum.append(args[i]);
        }
        if (info.getGetterMethod() == null) {
            return;
        }
        Class<?> retType = info.getGetterMethod().getReturnType();
        if (VirtualFile.class.isAssignableFrom(retType)) {
            VirtualFile file = (VirtualFile)info.getGetterMethod().invoke(targetConfig, (Object[])null);
            if (file != null && !file.isDirectory()) {
                if (info.doChecksum()) {
                    this.compile_checksum_ts.append(file.getLastModified());
                }
                this.link_checksum_ts.append(file.getLastModified());
            }
        } else if (retType.isArray() && VirtualFile.class.isAssignableFrom(retType.getComponentType())) {
            VirtualFile[] files = (VirtualFile[])info.getGetterMethod().invoke(targetConfig, (Object[])null);
            for (int i = 0; files != null && i < files.length; ++i) {
                if (files[i] == null || files[i].isDirectory()) continue;
                if (info.doChecksum()) {
                    this.compile_checksum_ts.append(files[i].getLastModified());
                }
                this.link_checksum_ts.append(files[i].getLastModified());
            }
        }
    }

    public void calculateChecksum(VirtualFile f) {
        this.compile_checksum.append(f.getName());
        this.compile_checksum_ts.append(f.getLastModified());
    }

    public void calculateChecksum(String name, Long lastModified) {
        this.compile_checksum.append(name);
        this.compile_checksum_ts.append(lastModified);
    }

    public void calculateLinkChecksum(String name, Long lastModified) {
        this.link_checksum.append(name);
        this.link_checksum_ts.append(lastModified);
    }

    private int calculateChecksum(String str) {
        byte[] b = null;
        try {
            b = str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            b = str.getBytes();
        }
        int checksum = 0;
        for (int i = 0; i < b.length; ++i) {
            checksum += b[i];
        }
        return checksum;
    }

    public int checksum() {
        return this.calculateChecksum(this.compile_checksum.toString());
    }

    public int checksum_ts() {
        return this.calculateChecksum(this.compile_checksum.toString() + this.compile_checksum_ts.toString());
    }

    public int link_checksum_ts() {
        return this.calculateChecksum(this.link_checksum.toString() + this.link_checksum_ts.toString());
    }

    public static List<String> formatText(String input, int columns) {
        ArrayList<String> lines;
        block15: {
            lines = new ArrayList<String>();
            if (input == null || input.length() == 0) {
                return lines;
            }
            int current = 0;
            int lineStart = -1;
            int lineEnd = -1;
            int wordStart = -1;
            int wordEnd = -1;
            boolean start = true;
            boolean preserve = true;
            while (current < input.length()) {
                boolean printable;
                boolean newline = input.charAt(current) == '\n';
                boolean bl = printable = preserve && !newline || !Character.isWhitespace(input.charAt(current));
                if (start) {
                    if (printable) {
                        if (lineStart == -1) {
                            lineStart = current;
                        }
                        wordStart = current;
                        start = false;
                        continue;
                    }
                    if (newline && lineStart != -1) {
                        lines.add(input.substring(lineStart, current));
                        lineStart = -1;
                    } else if (newline) {
                        lines.add("");
                    }
                    ++current;
                    continue;
                }
                preserve = false;
                if (printable) {
                    ++current;
                    continue;
                }
                wordEnd = current;
                if (lineEnd == -1) {
                    lineEnd = current;
                }
                if (wordEnd - lineStart < columns) {
                    if (newline) {
                        lines.add(input.substring(lineStart, current));
                        lineStart = -1;
                        lineEnd = -1;
                        wordStart = -1;
                        start = true;
                        preserve = true;
                        ++current;
                        continue;
                    }
                    start = true;
                    lineEnd = current;
                    continue;
                }
                lines.add(input.substring(lineStart, lineEnd));
                lineStart = wordStart;
                lineEnd = -1;
                wordStart = -1;
                start = true;
                if (!newline) continue;
                preserve = true;
            }
            if (lineStart == -1) break block15;
            wordEnd = current;
            if (lineEnd == -1) {
                lineEnd = current;
            }
            if (wordEnd - lineStart < columns || wordEnd == lineEnd) {
                lineEnd = wordEnd;
                lines.add(input.substring(lineStart, wordEnd));
            } else {
                lines.add(input.substring(lineStart, lineEnd));
                lines.add(input.substring(wordStart, wordEnd));
            }
        }
        return lines;
    }
}

