/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flex2.compiler.mxml.gen.CodeFragmentList;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.Reparent;
import flex2.compiler.mxml.rep.init.ArrayElementInitializer;
import flex2.compiler.mxml.rep.init.Initializer;
import flex2.compiler.util.IteratorList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array
extends Model {
    protected Collection<ArrayElementInitializer> list = new ArrayList<ArrayElementInitializer>();
    protected Type elementType;

    public Array(MxmlDocument document, int line, Type elementType) {
        this(document, null, line, elementType);
    }

    public Array(MxmlDocument document, Model parent, int line, Type elementType) {
        this(document, document.getTypeTable().arrayType, parent, line, elementType);
    }

    protected Array(MxmlDocument document, Type type, Model parent, int line, Type elementType) {
        super(document, type, parent, line);
        this.elementType = elementType;
    }

    public void setProperty(String name, Object value) {
        assert (false) : "Array may not have properties";
    }

    public void addEntry(Model entry) {
        ArrayElementInitializer initializer = new ArrayElementInitializer(this.elementType, this.list.size(), entry, entry.getXmlLineNumber(), this.standardDefs);
        initializer.setStateSpecific(entry.isStateSpecific());
        this.list.add(initializer);
    }

    public void addEntry(Object entry, int line) {
        this.list.add(new ArrayElementInitializer(this.elementType, this.list.size(), entry, line, this.standardDefs));
    }

    public void addEntries(Collection entries, int line) {
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            this.addEntry(iter.next(), line);
        }
    }

    public void setEntries(Collection<ArrayElementInitializer> entries) {
        this.list = entries;
    }

    public Collection<ArrayElementInitializer> getEntries() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public final Iterator<ArrayElementInitializer> getElementInitializerIterator() {
        return new FilterIterator(this.list.iterator(), new Predicate(){

            public boolean evaluate(Object object) {
                return !(((ArrayElementInitializer)object).getValue() instanceof Reparent);
            }
        });
    }

    @Override
    public Iterator<CodeFragmentList> getSubDefinitionsIterator() {
        IteratorList iterList = new IteratorList();
        Array.addDefinitionIterators(iterList, this.getElementInitializerIterator());
        return iterList.toIterator();
    }

    @Override
    public Iterator<Initializer> getSubInitializerIterator() {
        IteratorList iterList = new IteratorList();
        iterList.add(this.getElementInitializerIterator());
        return iterList.toIterator();
    }

    @Override
    public boolean hasBindings() {
        return this.bindingsOnly(this.getEntries().iterator()).hasNext() || super.hasBindings();
    }
}

